/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.FragmentKey;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierFetchMessage
extends GlacierMessage {
    public static final short TYPE = 2;
    protected FragmentKey[] keys;
    protected int request;
    public static final int FETCH_FRAGMENT = 1;
    public static final int FETCH_MANIFEST = 2;
    public static final int FETCH_FRAGMENT_AND_MANIFEST = 3;

    public GlacierFetchMessage(int uid, FragmentKey key, int request, NodeHandle source, Id dest, char tag) {
        this(uid, new FragmentKey[]{key}, request, source, dest, tag);
    }

    public GlacierFetchMessage(int uid, FragmentKey[] keys, int request, NodeHandle source, Id dest, char tag) {
        super(uid, source, dest, false, tag);
        this.keys = keys;
        this.request = request;
    }

    public FragmentKey[] getAllKeys() {
        return this.keys;
    }

    public int getRequest() {
        return this.request;
    }

    public int getNumKeys() {
        return this.keys.length;
    }

    public FragmentKey getKey(int index) {
        return this.keys[index];
    }

    public String toString() {
        return "[GlacierFetch for " + this.keys[0] + " and " + (this.keys.length - 1) + " other keys, req=" + this.request + "]";
    }

    public short getType() {
        return 2;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        super.serialize(buf);
        buf.writeInt(this.request);
        int l = this.keys.length;
        buf.writeInt(l);
        for (int i = 0; i < l; ++i) {
            this.keys[i].serialize(buf);
        }
    }

    public static GlacierFetchMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GlacierFetchMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private GlacierFetchMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        this.request = buf.readInt();
        int l = buf.readInt();
        this.keys = new FragmentKey[l];
        for (int i = 0; i < l; ++i) {
            this.keys[i] = new FragmentKey(buf, endpoint);
        }
    }
}

