/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation;

import java.util.Arrays;
import rice.environment.Environment;
import rice.environment.logging.Logger;

public class AggregationStatistics {
    public final long granularity;
    public int numObjectsTotal;
    public int numObjectsAlive;
    public int numAggregatesTotal;
    public int numPointerArrays;
    public int criticalAggregates;
    public int orphanedAggregates;
    public int[] objectLifetimeHisto;
    public int[] aggregateLifetimeHisto;
    public long totalObjectsSize;
    public long liveObjectsSize;
    public long time;
    private Environment environment;

    public AggregationStatistics(int histoLength, long granularityArg, Environment env) {
        this.environment = env;
        this.numObjectsTotal = 0;
        this.numObjectsAlive = 0;
        this.numAggregatesTotal = 0;
        this.numPointerArrays = 0;
        this.totalObjectsSize = 0L;
        this.liveObjectsSize = 0L;
        this.granularity = granularityArg;
        this.objectLifetimeHisto = new int[histoLength];
        Arrays.fill(this.objectLifetimeHisto, 0);
        this.aggregateLifetimeHisto = new int[histoLength];
        Arrays.fill(this.aggregateLifetimeHisto, 0);
        this.time = this.environment.getTimeSource().currentTimeMillis();
    }

    public void dump(Logger logger) {
        String s = "@L.AG interval=" + this.time + "-" + this.environment.getTimeSource().currentTimeMillis() + " granularity=" + this.granularity + "\n";
        s = s + "@L.AG   objsTotal=" + this.numObjectsTotal + " objsAlive=" + this.numObjectsAlive + "\n";
        s = s + "@L.AG   objBytesTotal=" + this.totalObjectsSize + " objBytesAlive=" + this.liveObjectsSize + "\n";
        s = s + "@L.AG   aggrTotal=" + this.numAggregatesTotal + " ptrArrays=" + this.numPointerArrays + " critical=" + this.criticalAggregates + " orphaned=" + this.orphanedAggregates;
        if (logger.level <= 800) {
            logger.log(s);
        }
    }
}

