/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.random.simple;

import java.net.InetAddress;
import java.util.Random;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.random.RandomSource;

public class SimpleRandomSource
implements RandomSource {
    Random rnd;
    Logger logger;
    String instance;

    public SimpleRandomSource(long seed, LogManager manager, String instance) {
        this.init(seed, manager, instance);
    }

    public SimpleRandomSource(long seed, LogManager manager) {
        this(seed, manager, null);
    }

    public SimpleRandomSource(LogManager manager) {
        this(manager, null);
    }

    public SimpleRandomSource(LogManager manager, String instance) {
        long time = System.currentTimeMillis();
        try {
            byte[] foo = InetAddress.getLocalHost().getAddress();
            for (int ctr = 0; ctr < foo.length; ++ctr) {
                int i = foo[ctr];
                time ^= (long)(i <<= ctr * 8);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.init(time, manager, instance);
    }

    public void setLogManager(LogManager manager) {
        this.logger = manager.getLogger(SimpleRandomSource.class, this.instance);
    }

    private void init(long seed, LogManager manager, String instance) {
        if (manager != null) {
            this.logger = manager.getLogger(SimpleRandomSource.class, instance);
        }
        if (this.logger != null && this.logger.level <= 800) {
            this.logger.log("RNG seed = " + seed);
        }
        this.rnd = new Random(seed);
    }

    public boolean nextBoolean() {
        boolean ret = this.rnd.nextBoolean();
        if (this.logger != null && this.logger.level <= 400) {
            this.logger.log("nextBoolean = " + ret);
        }
        return ret;
    }

    public void nextBytes(byte[] bytes) {
        this.rnd.nextBytes(bytes);
        if (this.logger != null && this.logger.level <= 400) {
            this.logger.log("nextBytes[" + bytes.length + "] = " + bytes);
        }
    }

    public double nextDouble() {
        double ret = this.rnd.nextDouble();
        if (this.logger != null && this.logger.level <= 400) {
            this.logger.log("nextDouble = " + ret);
        }
        return ret;
    }

    public float nextFloat() {
        float ret = this.rnd.nextFloat();
        if (this.logger != null && this.logger.level <= 400) {
            this.logger.log("nextFloat = " + ret);
        }
        return ret;
    }

    public double nextGaussian() {
        double ret = this.rnd.nextGaussian();
        if (this.logger != null && this.logger.level <= 400) {
            this.logger.log("nextGaussian = " + ret);
        }
        return ret;
    }

    public int nextInt() {
        int ret = this.rnd.nextInt();
        if (this.logger != null && this.logger.level <= 400) {
            this.logger.log("nextInt = " + ret);
        }
        return ret;
    }

    public int nextInt(int max) {
        int ret = this.rnd.nextInt(max);
        if (this.logger != null && this.logger.level <= 400) {
            this.logger.log("nextInt2 = " + ret);
        }
        return ret;
    }

    public long nextLong() {
        long ret = this.rnd.nextLong();
        if (this.logger != null && this.logger.level <= 400) {
            this.logger.log("nextLong = " + ret);
        }
        return ret;
    }
}

