/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.logging.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import rice.environment.logging.LogManager;
import rice.environment.logging.simple.SimpleLogManager;
import rice.environment.params.Parameters;
import rice.environment.time.TimeSource;
import rice.environment.time.simple.SimpleTimeSource;

public class FileLogManager
extends SimpleLogManager {
    String filePrefix;
    String fileSuffix;

    public FileLogManager(PrintStream stream, TimeSource timeSource, Parameters params) {
        this(stream, timeSource, params, "");
    }

    public FileLogManager(PrintStream stream, TimeSource timeSource, Parameters params, String prefix) {
        this(stream, timeSource, params, prefix, params.getString("fileLogManager_filePrefix"), params.getString("fileLogManager_fileSuffix"), null);
    }

    public FileLogManager(PrintStream stream, TimeSource timeSource, Parameters params, String prefix, String filePrefix, String fileSuffix, String dateFormat) {
        super(stream, timeSource, params, prefix, dateFormat);
        this.filePrefix = filePrefix;
        this.fileSuffix = fileSuffix;
    }

    public FileLogManager(Parameters params) {
        this(FileLogManager.getDefaultPrintStream(params), new SimpleTimeSource(), params);
    }

    public FileLogManager(PrintStream stream, Parameters params) {
        this(stream, new SimpleTimeSource(), params);
    }

    public FileLogManager(TimeSource timeSource, Parameters params) {
        this(FileLogManager.getDefaultPrintStream(params), timeSource, params);
    }

    private static PrintStream getDefaultPrintStream(Parameters params) {
        return FileLogManager.getPrintStream(params.getString("fileLogManager_filePrefix"), params.getString("fileLogManager_defaultFileName"), params.getString("fileLogManager_fileSuffix"), !params.getBoolean("fileLogManager_overwrite_existing_log_file"));
    }

    private static PrintStream getPrintStream(String filePrefix, String detail, String fileSuffix, boolean append) {
        PrintStream newPS = System.out;
        try {
            String fname = filePrefix + detail + fileSuffix;
            newPS = new PrintStream(new FileOutputStream(fname, append));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return newPS;
    }

    public LogManager clone(String detail) {
        boolean append;
        PrintStream newPS = this.ps;
        boolean bl = append = !this.params.getBoolean("fileLogManager_overwrite_existing_log_file");
        if (this.params.getBoolean("fileLogManager_multipleFiles")) {
            newPS = FileLogManager.getPrintStream(this.filePrefix, detail, this.fileSuffix, append);
        }
        String linePrefix = "";
        if (this.params.getBoolean("fileLogManager_keepLinePrefix")) {
            linePrefix = detail;
        }
        return new FileLogManager(newPS, this.time, this.params, linePrefix, this.filePrefix, this.fileSuffix, this.dateFormat);
    }
}

