/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.wire;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Map;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.wire.TCPLayer;
import rice.environment.logging.Logger;
import rice.selector.SelectionKeyHandler;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketManager
extends SelectionKeyHandler
implements P2PSocket<InetSocketAddress>,
SocketRequestHandle<InetSocketAddress> {
    protected SelectionKey key;
    protected SocketChannel channel;
    protected TimerTask timer;
    protected TCPLayer tcp;
    Logger logger;
    InetSocketAddress addr;
    Map<String, Object> options;
    protected P2PSocketReceiver<InetSocketAddress> reader;
    protected P2PSocketReceiver<InetSocketAddress> writer;
    boolean delivered = false;

    public SocketManager(TCPLayer tcp, SelectionKey serverKey) throws IOException {
        this.tcp = tcp;
        this.logger = tcp.logger;
        this.channel = ((ServerSocketChannel)serverKey.channel()).accept();
        this.channel.socket().setSendBufferSize(tcp.SOCKET_BUFFER_SIZE);
        this.channel.socket().setReceiveBufferSize(tcp.SOCKET_BUFFER_SIZE);
        this.channel.socket().setTcpNoDelay(tcp.TCP_NO_DELAY);
        this.channel.configureBlocking(false);
        this.addr = (InetSocketAddress)this.channel.socket().getRemoteSocketAddress();
        if (this.logger.level <= 500) {
            this.logger.log("(SA) Accepted incoming connection from " + this.addr);
        }
        this.key = tcp.wire.environment.getSelectorManager().register(this.channel, this, 0);
    }

    public SocketManager(final TCPLayer tcp, final InetSocketAddress addr, final SocketCallback<InetSocketAddress> c, Map<String, Object> options) throws IOException {
        this.tcp = tcp;
        this.options = options;
        this.logger = tcp.logger;
        this.addr = addr;
        this.channel = SocketChannel.open();
        this.channel.socket().setSendBufferSize(tcp.SOCKET_BUFFER_SIZE);
        this.channel.socket().setReceiveBufferSize(tcp.SOCKET_BUFFER_SIZE);
        if (tcp.wire.forceBindAddress && tcp.wire.bindAddress != null) {
            this.channel.socket().bind(new InetSocketAddress(tcp.wire.bindAddress.getAddress(), 0));
        }
        this.channel.configureBlocking(false);
        if (this.logger.level <= 500) {
            this.logger.log("(SM) Initiating socket connection to " + addr);
        }
        if (this.channel.connect(addr)) {
            this.key = tcp.wire.environment.getSelectorManager().register(this.channel, this, 0);
            this.delivered = true;
            if (this.logger.level <= 500) {
                this.logger.log("delivering1 " + this);
            }
            c.receiveResult(this, this);
        } else {
            this.key = tcp.wire.environment.getSelectorManager().register(this.channel, new SelectionKeyHandler(){

                public void write(SelectionKey key) {
                    SocketManager.this.write(key);
                }

                public void read(SelectionKey key) {
                    SocketManager.this.read(key);
                }

                public void modifyKey(SelectionKey key) {
                    SocketManager.this.modifyKey(key);
                }

                public void connect(SelectionKey key) {
                    try {
                        if (SocketManager.this.channel.finishConnect()) {
                            key = tcp.wire.environment.getSelectorManager().register(SocketManager.this.channel, SocketManager.this, key.interestOps() & 0xFFFFFFF7);
                            SocketManager.this.delivered = true;
                            if (SocketManager.this.logger.level <= 500) {
                                SocketManager.this.logger.log("delivering2 " + SocketManager.this);
                            }
                            tcp.wire.broadcastChannelOpened(addr, SocketManager.this.options, true);
                            c.receiveResult(SocketManager.this, SocketManager.this);
                        }
                    }
                    catch (IOException e) {
                        if (c == null) {
                            tcp.wire.errorHandler.receivedException(addr, e);
                        } else {
                            c.receiveException(SocketManager.this, e);
                        }
                        SocketManager.this.close();
                    }
                }
            }, 8);
        }
    }

    public String toString() {
        return "SM " + this.addr + " " + this.channel;
    }

    @Override
    public void close() {
        block7: {
            try {
                if (this.logger.level <= 500) {
                    this.logger.log("Closing " + this + " r:" + this.reader + " w:" + this.writer);
                } else if (this.logger.level <= 300) {
                    this.logger.logException("Closing " + this + " r:" + this.reader + " w:" + this.writer, new Exception("Stack Trace"));
                }
                if (this.key == null) {
                    return;
                }
                this.key.cancel();
                this.key.attach(null);
                this.key = null;
                if (this.channel != null) {
                    this.channel.close();
                }
                this.tcp.socketClosed(this);
                this.tcp.wire.environment.getSelectorManager().invoke(new Runnable(){

                    public void run() {
                        P2PSocketReceiver<InetSocketAddress> temp;
                        if (SocketManager.this.writer != null) {
                            if (SocketManager.this.writer == SocketManager.this.reader) {
                                temp = SocketManager.this.writer;
                                SocketManager.this.writer = null;
                                SocketManager.this.reader = null;
                                temp.receiveException(SocketManager.this, new ClosedChannelException("Channel closed. " + SocketManager.this));
                            } else {
                                temp = SocketManager.this.writer;
                                SocketManager.this.writer = null;
                                temp.receiveException(SocketManager.this, new ClosedChannelException("Channel closed. " + SocketManager.this));
                            }
                        }
                        if (SocketManager.this.reader != null) {
                            if (SocketManager.this.tcp.isDestroyed()) {
                                return;
                            }
                            temp = SocketManager.this.reader;
                            SocketManager.this.reader = null;
                            temp.receiveException(SocketManager.this, new ClosedChannelException("Channel closed."));
                        }
                    }
                });
            }
            catch (IOException e) {
                if (this.logger.level > 1000) break block7;
                this.logger.log("ERROR: Recevied exception " + e + " while closing socket!");
            }
        }
    }

    @Override
    public synchronized void modifyKey(SelectionKey key) {
        int flag = 0;
        if (this.reader != null) {
            flag |= 1;
        }
        if (this.writer != null) {
            flag |= 4;
        }
        key.interestOps(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(SelectionKey key) {
        P2PSocketReceiver<InetSocketAddress> temp = null;
        SocketManager socketManager = this;
        synchronized (socketManager) {
            if (this.reader == null) {
                key.interestOps(key.interestOps() & 0xFFFFFFFE);
                return;
            }
            temp = this.reader;
            this.reader = null;
        }
        try {
            temp.receiveSelectResult(this, true, false);
        }
        catch (IOException ioe) {
            temp.receiveException(this, ioe);
        }
        this.tcp.wire.environment.getSelectorManager().modifyKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(SelectionKey key) {
        P2PSocketReceiver<InetSocketAddress> temp = null;
        SocketManager socketManager = this;
        synchronized (socketManager) {
            if (this.writer == null) {
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                return;
            }
            temp = this.writer;
            this.writer = null;
        }
        try {
            temp.receiveSelectResult(this, false, true);
        }
        catch (IOException ioe) {
            temp.receiveException(this, ioe);
        }
        this.tcp.wire.environment.getSelectorManager().modifyKey(key);
    }

    @Override
    public synchronized void register(boolean wantToRead, boolean wantToWrite, P2PSocketReceiver<InetSocketAddress> receiver) {
        if (this.logger.level <= 400) {
            this.logger.log(this + ".register(" + (wantToRead ? "r" : "") + (wantToWrite ? "w" : "") + "," + receiver + ")");
        }
        if (this.key == null) {
            ClosedChannelException cce = new ClosedChannelException("Socket " + this.addr + " " + this + " is already closed.");
            if (this.logger.level <= 700) {
                this.logger.logException("Socket " + this.addr + " " + this + " is already closed.", cce);
            }
            receiver.receiveException(this, cce);
            return;
        }
        if (wantToWrite) {
            if (this.channel.socket().isOutputShutdown()) {
                receiver.receiveException(this, new ClosedChannelException("Socket " + this.addr + " " + this + " already shut down output."));
                return;
            }
            if (this.writer != null && this.writer != receiver) {
                throw new IllegalStateException("Already registered " + this.writer + " for writing, you can't register " + receiver + " for writing as well! SM:" + this);
            }
        }
        if (wantToRead) {
            if (this.reader != null && this.reader != receiver) {
                throw new IllegalStateException("Already registered " + this.reader + " for reading, you can't register " + receiver + " for reading as well!");
            }
            this.reader = receiver;
        }
        if (wantToWrite) {
            this.writer = receiver;
        }
        this.tcp.wire.environment.getSelectorManager().modifyKey(this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownOutput() {
        boolean closeMe = false;
        SocketManager socketManager = this;
        synchronized (socketManager) {
            if (this.key == null) {
                throw new IllegalStateException("Socket already closed.");
            }
            if (this.channel.socket().isClosed()) {
                // empty if block
            }
            try {
                if (this.logger.level <= 500) {
                    this.logger.log("Shutting down output on app connection " + this);
                }
                this.channel.socket().shutdownOutput();
                this.tcp.wire.environment.getSelectorManager().invoke(new Runnable(){

                    public void run() {
                        if (SocketManager.this.writer != null) {
                            SocketManager.this.writer.receiveException(SocketManager.this, new ClosedChannelException("Channel shut down."));
                            SocketManager.this.writer = null;
                        }
                    }
                });
            }
            catch (IOException e) {
                if (this.logger.level <= 1000) {
                    this.logger.log("ERROR: Received exception " + e + " while shutting down output for socket " + this);
                }
                closeMe = true;
            }
        }
        this.tcp.wire.environment.getSelectorManager().modifyKey(this.key);
        if (closeMe) {
            this.close();
        }
    }

    @Override
    public long read(ByteBuffer dst) throws IOException {
        if (this.key == null || this.channel.socket().isInputShutdown()) {
            return -1L;
        }
        try {
            long ret = this.channel.read(dst);
            if (this.logger.level <= 400) {
                if (this.logger.level <= 300) {
                    this.logger.log(this + "read(" + ret + "):" + Arrays.toString(dst.array()));
                } else {
                    this.logger.log(this + "read(" + ret + ")");
                }
            }
            return ret;
        }
        catch (IOException ioe) {
            if (this.logger.level <= 500) {
                this.logger.logException(this + " error reading", ioe);
            } else if (this.logger.level <= 800) {
                this.logger.log(this + " error reading");
            }
            this.close();
            throw ioe;
        }
    }

    @Override
    public long write(ByteBuffer src) throws IOException {
        if (this.key == null || this.channel.socket().isOutputShutdown()) {
            return -1L;
        }
        try {
            long ret = this.channel.write(src);
            if (this.logger.level <= 400) {
                if (this.logger.level <= 300) {
                    this.logger.log(this + "write(" + ret + "):" + Arrays.toString(src.array()));
                } else {
                    this.logger.log(this + "write(" + ret + ")");
                }
            }
            return ret;
        }
        catch (IOException ioe) {
            if (this.logger.level <= 400) {
                this.logger.logException(this + " error writing", ioe);
            } else if (this.logger.level <= 500) {
                this.logger.log(this + " error writing");
            }
            this.close();
            throw ioe;
        }
    }

    @Override
    public boolean cancel() {
        if (this.key == null) {
            return false;
        }
        if (this.delivered) {
            throw new IllegalStateException(this + ".cancel() Can't cancel, already delivered");
        }
        this.close();
        return true;
    }

    private void exceptionAndClose(IOException e) {
        this.tcp.wire.errorHandler.receivedException(this.addr, e);
        this.close();
    }

    @Override
    public InetSocketAddress getIdentifier() {
        return this.addr;
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    public SocketChannel getSocketChannel() {
        this.tcp.wire.environment.getSelectorManager().cancel(this.key);
        return this.channel;
    }
}

