/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketWrapperSocket<Identifier, SubIdentifier>
implements P2PSocket<Identifier>,
P2PSocketReceiver<SubIdentifier> {
    protected Identifier identifier;
    protected P2PSocket<SubIdentifier> socket;
    protected Logger logger;
    protected Map<String, Object> options;
    protected P2PSocketReceiver<Identifier> reader;
    protected P2PSocketReceiver<Identifier> writer;
    protected ErrorHandler<Identifier> errorHandler;

    public SocketWrapperSocket(Identifier identifier, P2PSocket<SubIdentifier> socket, Logger logger, ErrorHandler<Identifier> errorHandler, Map<String, Object> options) {
        this.identifier = identifier;
        this.socket = socket;
        this.logger = logger;
        this.options = options;
        this.errorHandler = errorHandler;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public void close() {
        if (this.logger.level <= 400) {
            this.logger.logException("Closing " + this, new Exception("Stack Trace"));
        } else if (this.logger.level <= 500) {
            this.logger.log("Closing " + this);
        }
        this.socket.close();
    }

    @Override
    public long read(ByteBuffer dsts) throws IOException {
        long ret = this.socket.read(dsts);
        if (this.logger.level <= 300) {
            this.logger.log(this + "read():" + ret);
        }
        return ret;
    }

    @Override
    public void register(boolean wantToRead, boolean wantToWrite, P2PSocketReceiver<Identifier> receiver) {
        if (this.logger.level <= 300) {
            this.logger.log(this + "register(" + wantToRead + "," + wantToWrite + "," + receiver + ")");
        }
        if (wantToRead) {
            if (this.reader != null && this.reader != receiver) {
                throw new IllegalStateException("Already registered " + this.reader + " for reading. Can't register " + receiver);
            }
            this.reader = receiver;
        }
        if (wantToWrite) {
            if (this.writer != null && this.writer != receiver) {
                throw new IllegalStateException("Already registered " + this.reader + " for writing. Can't register " + receiver);
            }
            this.writer = receiver;
        }
        this.socket.register(wantToRead, wantToWrite, this);
    }

    @Override
    public void receiveSelectResult(P2PSocket<SubIdentifier> socket, boolean canRead, boolean canWrite) throws IOException {
        P2PSocketReceiver<Identifier> temp;
        if (this.logger.level <= 300) {
            this.logger.log(this + "rsr(" + socket + "," + canRead + "," + canWrite + ")");
        }
        if (canRead && canWrite && this.reader == this.writer) {
            P2PSocketReceiver<Identifier> temp2 = this.reader;
            this.reader = null;
            this.writer = null;
            temp2.receiveSelectResult(this, canRead, canWrite);
            return;
        }
        if (canRead) {
            temp = this.reader;
            if (temp == null) {
                if (this.logger.level <= 900) {
                    this.logger.log("no reader in " + this + ".rsr(" + socket + "," + canRead + "," + canWrite + ")");
                }
            } else {
                this.reader = null;
                temp.receiveSelectResult(this, true, false);
            }
        }
        if (canWrite) {
            temp = this.writer;
            if (temp == null) {
                if (this.logger.level <= 900) {
                    this.logger.log("no writer in " + this + ".rsr(" + socket + "," + canRead + "," + canWrite + ")");
                }
            } else {
                this.writer = null;
                temp.receiveSelectResult(this, false, true);
            }
        }
    }

    @Override
    public void receiveException(P2PSocket<SubIdentifier> socket, Exception e) {
        P2PSocketReceiver<Identifier> temp;
        if (this.writer != null) {
            if (this.writer == this.reader) {
                temp = this.writer;
                this.writer = null;
                this.reader = null;
                temp.receiveException(this, e);
            } else {
                temp = this.writer;
                this.writer = null;
                temp.receiveException(this, e);
            }
        }
        if (this.reader != null) {
            temp = this.reader;
            this.reader = null;
            temp.receiveException(this, e);
        }
        if (this.reader == null && this.writer == null && this.errorHandler != null) {
            this.errorHandler.receivedException(this.getIdentifier(), e);
        }
    }

    @Override
    public void shutdownOutput() {
        this.socket.shutdownOutput();
    }

    @Override
    public long write(ByteBuffer srcs) throws IOException {
        long ret = this.socket.write(srcs);
        if (this.logger.level <= 300) {
            this.logger.log(this + "write():" + ret);
        }
        return ret;
    }

    public String toString() {
        if (this.getIdentifier() == this.socket.getIdentifier()) {
            return this.socket.toString();
        }
        return this.identifier + "-" + this.socket;
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }
}

