/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.util;

import java.nio.ByteBuffer;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.util.BufferReader;
import org.mpisws.p2p.transport.util.BufferWriter;
import rice.Continuation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferReaderWriter<Identifier> {
    boolean doneReading = false;
    boolean doneWriting = false;
    boolean failed = false;
    boolean sentException = false;
    ByteBuffer read = null;
    private Continuation<ByteBuffer, Exception> c;
    private P2PSocket<Identifier> socket;

    public BufferReaderWriter(P2PSocket<Identifier> sock, ByteBuffer writeMe, boolean writeSize, Continuation<ByteBuffer, Exception> c) {
        this(sock, writeMe, writeSize, c, -1);
    }

    public BufferReaderWriter(P2PSocket<Identifier> sock, ByteBuffer writeMe, boolean writeSize, Continuation<ByteBuffer, Exception> c, int readSize) {
        this.socket = sock;
        this.c = c;
        new BufferReader<Identifier>(sock, new Continuation<ByteBuffer, Exception>(){

            @Override
            public void receiveResult(ByteBuffer result) {
                BufferReaderWriter.this.read = result;
                BufferReaderWriter.this.doneReading = true;
                BufferReaderWriter.this.done(null);
            }

            @Override
            public void receiveException(Exception exception) {
                BufferReaderWriter.this.failed = true;
                BufferReaderWriter.this.done(exception);
            }
        }, readSize);
        new BufferWriter<Identifier>(writeMe, sock, new Continuation<P2PSocket<Identifier>, Exception>(){

            @Override
            public void receiveException(Exception exception) {
                BufferReaderWriter.this.failed = true;
                BufferReaderWriter.this.done(exception);
            }

            @Override
            public void receiveResult(P2PSocket<Identifier> result) {
                BufferReaderWriter.this.doneWriting = true;
                BufferReaderWriter.this.done(null);
            }
        }, writeSize);
    }

    public void done(Exception e) {
        if (this.failed) {
            if (!this.sentException) {
                this.sentException = true;
                this.c.receiveException(e);
                this.socket.close();
            }
            return;
        }
        if (this.doneReading && this.doneWriting) {
            this.c.receiveResult(this.read);
        }
    }
}

