/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.ssl;

import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.ssl.SSLSocketManager;
import org.mpisws.p2p.transport.ssl.SSLTransportLayer;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLTransportLayerImpl<Identifier, MessageType>
implements SSLTransportLayer<Identifier, MessageType> {
    protected TransportLayer<Identifier, MessageType> tl;
    protected TransportLayerCallback<Identifier, MessageType> callback;
    protected ErrorHandler<Identifier> errorHandler;
    protected Logger logger;
    protected Environment environment;
    protected SSLContext context;
    KeyPair keyPair;
    private int clientAuth;

    public SSLTransportLayerImpl(TransportLayer<Identifier, MessageType> tl, KeyStore keyStore, KeyStore trustStore, Environment env) throws IOException {
        this(tl, keyStore, trustStore, 1, env);
    }

    public SSLTransportLayerImpl(TransportLayer<Identifier, MessageType> tl, KeyStore keyStore, KeyStore trustStore, int clientAuth, Environment env) throws IOException {
        if (clientAuth != 0 && clientAuth != 1) {
            throw new IllegalArgumentException("clientAuth type:" + clientAuth + " not supported.");
        }
        this.environment = env;
        this.logger = env.getLogManager().getLogger(SSLTransportLayerImpl.class, null);
        this.tl = tl;
        this.errorHandler = new DefaultErrorHandler(this.logger, 900);
        this.clientAuth = clientAuth;
        try {
            this.context = SSLContext.getInstance("TLS");
            char[] passphrase = "".toCharArray();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keyStore, passphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(trustStore);
            TrustManager[] tms = tmf.getTrustManagers();
            if (clientAuth == 0) {
                tms = null;
            }
            this.context.init(kmf.getKeyManagers(), tms, null);
            tl.setCallback(this);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception nsae) {
            throw new RuntimeException(nsae);
        }
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(Identifier i, final SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
        final SocketRequestHandleImpl<Identifier> ret = new SocketRequestHandleImpl<Identifier>(i, options, this.logger);
        ret.setSubCancellable(this.tl.openSocket(i, new SocketCallback<Identifier>(){

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                deliverSocketToMe.receiveException(s, ex);
            }

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                SSLTransportLayerImpl.this.getSocketManager(SSLTransportLayerImpl.this, sock, new Continuation<SSLSocketManager<Identifier>, Exception>(){

                    @Override
                    public void receiveException(Exception exception) {
                        deliverSocketToMe.receiveException(ret, exception);
                    }

                    @Override
                    public void receiveResult(SSLSocketManager<Identifier> result) {
                        deliverSocketToMe.receiveResult(ret, result);
                    }
                }, false, SSLTransportLayerImpl.this.clientAuth != 0);
            }
        }, options));
        return ret;
    }

    @Override
    public void incomingSocket(final P2PSocket<Identifier> s) throws IOException {
        this.getSocketManager(this, s, new Continuation<SSLSocketManager<Identifier>, Exception>(){

            @Override
            public void receiveException(Exception exception) {
                SSLTransportLayerImpl.this.errorHandler.receivedException(s.getIdentifier(), exception);
            }

            @Override
            public void receiveResult(SSLSocketManager<Identifier> result) {
                try {
                    SSLTransportLayerImpl.this.callback.incomingSocket(result);
                }
                catch (IOException ioe) {
                    result.close();
                    SSLTransportLayerImpl.this.errorHandler.receivedException(s.getIdentifier(), ioe);
                }
            }
        }, true, this.clientAuth != 0);
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, MessageType> callback) {
        this.callback = callback;
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public void destroy() {
        this.tl.destroy();
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    @Override
    public MessageRequestHandle<Identifier, MessageType> sendMessage(Identifier i, MessageType m, MessageCallback<Identifier, MessageType> deliverAckToMe, Map<String, Object> options) {
        return this.tl.sendMessage(i, m, deliverAckToMe, options);
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.errorHandler = handler;
    }

    @Override
    public void messageReceived(Identifier i, MessageType m, Map<String, Object> options) throws IOException {
        this.callback.messageReceived(i, m, options);
    }

    protected SSLSocketManager<Identifier> getSocketManager(SSLTransportLayerImpl<Identifier, ?> sslTL, P2PSocket<Identifier> s, Continuation<SSLSocketManager<Identifier>, Exception> c, boolean server, boolean useClientAuth) {
        return new SSLSocketManager<Identifier>(sslTL, s, c, server, useClientAuth);
    }
}

