/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.ssl.SSLTransportLayerImpl;
import org.mpisws.p2p.transport.util.OptionsFactory;
import rice.Continuation;
import rice.Executable;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLSocketManager<Identifier>
implements P2PSocket<Identifier>,
P2PSocketReceiver<Identifier> {
    protected X509Certificate peerCert = null;
    protected P2PSocket<Identifier> socket;
    protected SSLEngine engine;
    protected SSLTransportLayerImpl<Identifier, ?> sslTL;
    protected Logger logger;
    protected boolean handshaking = true;
    protected boolean closed = true;
    protected SSLEngineResult result;
    protected SSLEngineResult.HandshakeStatus status;
    protected LinkedList<ByteBuffer> writeMe = new LinkedList();
    protected LinkedList<ByteBuffer> unwrapMe = new LinkedList();
    protected LinkedList<ByteBuffer> readMe;
    protected ByteBuffer bogusEncryptMe;
    protected int appBufferMax;
    protected int netBufferMax;
    protected Continuation<SSLSocketManager<Identifier>, Exception> c;
    protected boolean doneHandshaking = false;
    protected Map<String, Object> options;
    protected boolean useClientAuth;
    protected boolean server;
    protected String name;
    boolean handshakeFail = false;
    boolean runningTaskLock = false;
    P2PSocketReceiver<Identifier> registeredToRead;
    P2PSocketReceiver<Identifier> registeredToWrite;

    public SSLSocketManager(SSLTransportLayerImpl<Identifier, ?> sslTL, P2PSocket<Identifier> s, Continuation<SSLSocketManager<Identifier>, Exception> c, boolean server, boolean useClientAuth) {
        this.server = server;
        this.useClientAuth = useClientAuth;
        this.sslTL = sslTL;
        this.socket = s;
        this.c = c;
        this.logger = sslTL.logger;
        this.engine = sslTL.context.createSSLEngine(s.getIdentifier().toString(), 0);
        this.engine.setUseClientMode(!server);
        if (server && useClientAuth) {
            this.engine.setNeedClientAuth(true);
        }
        this.appBufferMax = this.engine.getSession().getApplicationBufferSize();
        this.netBufferMax = this.engine.getSession().getPacketBufferSize();
        this.bogusEncryptMe = ByteBuffer.allocate(0);
        this.readMe = new LinkedList();
        this.socket.register(true, false, this);
        this.handshakeWrap();
    }

    public String toString() {
        return "SSLSocket to " + (this.name == null ? "unknown" : this.name) + " at " + this.socket.toString();
    }

    protected void handleResult(SSLEngineResult result) {
        this.result = result;
        this.status = result.getHandshakeStatus();
    }

    @Override
    public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
        if (this.handshakeFail) {
            return;
        }
        if (canWrite) {
            Iterator i = this.writeMe.iterator();
            while (i.hasNext()) {
                ByteBuffer b = (ByteBuffer)i.next();
                socket.write(b);
                if (b.hasRemaining()) break;
                i.remove();
            }
            if (this.writeMe.isEmpty()) {
                if (this.registeredToWrite != null) {
                    P2PSocketReceiver<Identifier> temp = this.registeredToWrite;
                    this.registeredToWrite = null;
                    temp.receiveSelectResult(this, false, true);
                }
            } else {
                socket.register(false, true, this);
            }
        }
        if (canRead) {
            if (this.doneHandshaking) {
                if (this.read() && this.registeredToRead != null) {
                    P2PSocketReceiver<Identifier> temp = this.registeredToRead;
                    this.registeredToRead = null;
                    temp.receiveSelectResult(this, true, false);
                }
            } else {
                this.read();
                this.continueHandshaking();
            }
        }
    }

    protected boolean read() throws IOException {
        ByteBuffer foo = ByteBuffer.allocate(this.netBufferMax);
        if (this.socket.read(foo) < 0L) {
            this.closed = true;
            this.fail(new ClosedChannelException("Unexpected socket closure " + this));
        }
        if (foo.position() != 0) {
            foo.flip();
            this.unwrapMe.addLast(foo);
            return true;
        }
        return false;
    }

    protected void handshakeWrap() {
        try {
            ByteBuffer outgoing = ByteBuffer.allocate(this.netBufferMax);
            this.handleResult(this.engine.wrap(this.bogusEncryptMe, outgoing));
            if (outgoing.position() != 0) {
                outgoing.flip();
                this.writeMe.addLast(outgoing);
                this.socket.register(false, true, this);
            }
        }
        catch (SSLException e) {
            this.fail(e);
            return;
        }
        this.continueHandshaking();
    }

    protected void unwrap() throws SSLException {
        Iterator i = this.unwrapMe.iterator();
        while (i.hasNext()) {
            ByteBuffer b = (ByteBuffer)i.next();
            ByteBuffer foo = ByteBuffer.allocate(this.appBufferMax);
            this.handleResult(this.engine.unwrap(b, foo));
            if (foo.position() != 0) {
                foo.flip();
                this.readMe.addLast(foo);
            }
            if (b.hasRemaining()) break;
            i.remove();
        }
    }

    protected void handshakeUnwrap() {
        try {
            if (this.unwrapMe.isEmpty() && !this.read()) {
                this.socket.register(true, false, this);
                return;
            }
            this.unwrap();
        }
        catch (Exception e) {
            this.fail(e);
            return;
        }
        this.continueHandshaking();
    }

    protected void fail(Exception e) {
        if (this.doneHandshaking) {
            return;
        }
        this.logger.logException("fail:", e);
        Throwable e2 = e;
        while (e2.getCause() != null) {
            this.logger.logException("fail cause:", e2.getCause());
            e2 = e2.getCause();
        }
        this.handshakeFail = true;
        this.c.receiveException(e);
        this.socket.close();
        this.doneHandshaking = true;
    }

    protected void continueHandshaking() {
        if (this.runningTaskLock) {
            return;
        }
        switch (this.status) {
            case NOT_HANDSHAKING: {
                return;
            }
            case FINISHED: {
                this.checkDone();
                return;
            }
            case NEED_TASK: {
                this.runDelegatedTasks();
            }
            case NEED_WRAP: {
                this.handshakeWrap();
                return;
            }
            case NEED_UNWRAP: {
                this.handshakeUnwrap();
                return;
            }
        }
    }

    protected boolean checkDone() {
        if (this.status == SSLEngineResult.HandshakeStatus.FINISHED || this.status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (!this.server || this.useClientAuth) {
                try {
                    this.peerCert = (X509Certificate)this.engine.getSession().getPeerCertificates()[0];
                    this.name = this.peerCert.getSubjectDN().getName();
                    if (!this.name.startsWith("CN=")) {
                        this.fail(new IllegalArgumentException("CN must start with CN= " + this.name + " " + this));
                        return false;
                    }
                    this.name = this.name.substring(3);
                    this.options = OptionsFactory.addOption(this.socket.getOptions(), "ssl_certificate_subject", this.name);
                }
                catch (Exception e) {
                    this.fail(e);
                    return false;
                }
            }
            this.doneHandshaking = true;
            this.c.receiveResult(this);
            return true;
        }
        return false;
    }

    public X509Certificate getCert() {
        return this.peerCert;
    }

    private void runDelegatedTasks() {
        if (this.result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.runningTaskLock = true;
            this.sslTL.environment.getProcessor().process(new Executable<Object, Exception>(){

                @Override
                public Object execute() throws Exception {
                    Runnable runnable;
                    while ((runnable = SSLSocketManager.this.engine.getDelegatedTask()) != null) {
                        runnable.run();
                    }
                    SSLSocketManager.this.status = SSLSocketManager.this.engine.getHandshakeStatus();
                    if (SSLSocketManager.this.status == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        SSLSocketManager.this.fail(new IOException("handshake shouldn't need additional tasks"));
                        return null;
                    }
                    return null;
                }
            }, new Continuation<Object, Exception>(){

                @Override
                public void receiveException(Exception exception) {
                    exception.printStackTrace();
                }

                @Override
                public void receiveResult(Object result) {
                    SSLSocketManager.this.runningTaskLock = false;
                    SSLSocketManager.this.continueHandshaking();
                }
            }, this.sslTL.environment.getSelectorManager(), this.sslTL.environment.getTimeSource(), this.sslTL.environment.getLogManager());
        }
    }

    private static boolean isEngineClosed(SSLEngine engine) {
        return engine.isOutboundDone() && engine.isInboundDone();
    }

    @Override
    public void register(boolean wantToRead, boolean wantToWrite, P2PSocketReceiver<Identifier> receiver) {
        if (wantToRead) {
            if (!this.readMe.isEmpty()) {
                try {
                    receiver.receiveSelectResult(this, true, false);
                }
                catch (IOException ioe) {
                    receiver.receiveException(this, ioe);
                }
            } else {
                this.registeredToRead = receiver;
                this.socket.register(true, false, this);
            }
        }
        if (wantToWrite) {
            if (this.writeMe.isEmpty()) {
                try {
                    receiver.receiveSelectResult(this, false, true);
                }
                catch (IOException ioe) {
                    receiver.receiveException(this, ioe);
                }
            } else {
                this.registeredToWrite = receiver;
                this.socket.register(false, true, this);
            }
        }
    }

    @Override
    public long read(ByteBuffer dsts) throws IOException {
        long start = dsts.position();
        this.unwrap();
        while (dsts.hasRemaining() && !this.readMe.isEmpty()) {
            ByteBuffer foo = this.readMe.getFirst();
            int len = Math.min(dsts.remaining(), foo.remaining());
            int pos = foo.position();
            dsts.put(foo.array(), pos, len);
            foo.position(pos + len);
            if (foo.hasRemaining()) {
                return (long)dsts.position() - start;
            }
            this.readMe.removeFirst();
        }
        if (dsts.hasRemaining() && this.read()) {
            this.unwrap();
            dsts.put(this.readMe.getFirst());
            if (this.readMe.getFirst().hasRemaining()) {
                return (long)dsts.position() - start;
            }
            this.readMe.removeFirst();
        }
        return (long)dsts.position() - start;
    }

    @Override
    public long write(ByteBuffer srcs) throws IOException {
        ByteBuffer outgoing = ByteBuffer.allocate(this.netBufferMax);
        SSLEngineResult tempResult = this.engine.wrap(srcs, outgoing);
        if (outgoing.position() != 0) {
            outgoing.flip();
            this.writeMe.addLast(outgoing);
            this.receiveSelectResult(this.socket, false, true);
        }
        return tempResult.bytesConsumed();
    }

    @Override
    public void close() {
        this.socket.close();
    }

    @Override
    public Identifier getIdentifier() {
        return this.socket.getIdentifier();
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public void shutdownOutput() {
        this.engine.closeOutbound();
    }

    @Override
    public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
        this.c.receiveException(ioe);
    }
}

