/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.sourceroute.manager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.liveness.PingListener;
import org.mpisws.p2p.transport.proximity.ProximityListener;
import org.mpisws.p2p.transport.proximity.ProximityProvider;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import org.mpisws.p2p.transport.sourceroute.SourceRouteFactory;
import org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManager;
import org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManagerImpl;
import org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManagerP2PSocket;
import org.mpisws.p2p.transport.sourceroute.manager.SourceRouteStrategy;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.p2p.commonapi.Cancellable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceRouteManagerImpl<Identifier>
implements SourceRouteManager<Identifier>,
TransportLayerCallback<SourceRoute<Identifier>, ByteBuffer>,
LivenessListener<SourceRoute<Identifier>>,
ProximityListener<SourceRoute<Identifier>> {
    public static final int DEFAULT_PROXIMITY = 3600000;
    public long PING_THROTTLE;
    public int NUM_SOURCE_ROUTE_ATTEMPTS;
    public int CHECK_LIVENESS_THROTTLE = 5000;
    TransportLayer<SourceRoute<Identifier>, ByteBuffer> tl;
    LivenessProvider<SourceRoute<Identifier>> livenessProvider;
    ProximityProvider<SourceRoute<Identifier>> proxProvider;
    SourceRouteStrategy<Identifier> strategy;
    Environment environment;
    Logger logger;
    Identifier localAddress;
    Map<Identifier, AddressManager> addressManagers;
    private TransportLayerCallback<Identifier, ByteBuffer> callback;
    private ErrorHandler<Identifier> errorHandler;
    Set<AddressManager> hardLinks;
    List<LivenessListener<Identifier>> livenessListeners;
    List<PingListener<Identifier>> pingListeners;
    SourceRouteFactory<Identifier> srFactory;
    Collection<ProximityListener<Identifier>> listeners = new ArrayList<ProximityListener<Identifier>>();

    public SourceRouteManagerImpl(SourceRouteFactory<Identifier> srFactory, TransportLayer<SourceRoute<Identifier>, ByteBuffer> tl, LivenessProvider<SourceRoute<Identifier>> livenessProvider, ProximityProvider<SourceRoute<Identifier>> proxProvider, Environment env, SourceRouteStrategy<Identifier> strategy) {
        if (tl == null) {
            throw new IllegalArgumentException("tl == null");
        }
        if (proxProvider == null) {
            throw new IllegalArgumentException("proxProvider == null");
        }
        if (strategy == null) {
            throw new IllegalArgumentException("strategy == null");
        }
        this.tl = tl;
        this.livenessProvider = livenessProvider;
        this.proxProvider = proxProvider;
        this.proxProvider.addProximityListener(this);
        this.strategy = strategy;
        this.environment = env;
        this.logger = env.getLogManager().getLogger(SourceRouteManagerImpl.class, null);
        this.srFactory = srFactory;
        this.localAddress = tl.getLocalIdentifier().getFirstHop();
        tl.setCallback(this);
        livenessProvider.addLivenessListener(this);
        this.addressManagers = new HashMap<Identifier, AddressManager>();
        Parameters p = this.environment.getParameters();
        this.PING_THROTTLE = p.getLong("pastry_socket_srm_ping_throttle");
        this.NUM_SOURCE_ROUTE_ATTEMPTS = p.getInt("pastry_socket_srm_num_source_route_attempts");
        this.hardLinks = new HashSet<AddressManager>();
        this.livenessListeners = new ArrayList<LivenessListener<Identifier>>();
        this.pingListeners = new ArrayList<PingListener<Identifier>>();
    }

    @Override
    public MessageRequestHandle<Identifier, ByteBuffer> sendMessage(Identifier i, ByteBuffer m, MessageCallback<Identifier, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        return this.getAddressManager(i).sendMessage(m, deliverAckToMe, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AddressManager getAddressManager(Identifier address) {
        Map<Identifier, AddressManager> map = this.addressManagers;
        synchronized (map) {
            AddressManager manager = this.addressManagers.get(address);
            if (manager == null) {
                manager = new AddressManager(address);
                this.addressManagers.put(address, manager);
            }
            return manager;
        }
    }

    @Override
    public void clearState(Identifier i) {
        this.getAddressManager(i).clearLivenessState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHardLink(AddressManager am) {
        Set<AddressManager> set = this.hardLinks;
        synchronized (set) {
            this.hardLinks.add(am);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHardLink(AddressManager am) {
        Set<AddressManager> set = this.hardLinks;
        synchronized (set) {
            this.hardLinks.remove(am);
        }
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(Identifier i, SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
        if (this.logger.level <= 750) {
            this.logger.log("openSocket(" + i + "," + deliverSocketToMe + "," + options + ")");
        }
        return this.getAddressManager(i).openSocket(deliverSocketToMe, options);
    }

    @Override
    public boolean checkLiveness(Identifier address, Map<String, Object> options) {
        return this.getAddressManager(address).checkLiveness(options);
    }

    @Override
    public int getLiveness(Identifier address, Map<String, Object> options) {
        return this.getAddressManager(address).getLiveness(options);
    }

    @Override
    public int proximity(Identifier address, Map<String, Object> options) {
        return this.getAddressManager(address).proximity(options);
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.localAddress;
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.errorHandler = handler;
    }

    @Override
    public void destroy() {
        this.tl.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLivenessListener(LivenessListener<Identifier> name) {
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            this.livenessListeners.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLivenessListener(LivenessListener<Identifier> name) {
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            return this.livenessListeners.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLivenessListeners(Identifier i, int liveness, Map<String, Object> options) {
        ArrayList<LivenessListener<Identifier>> temp;
        if (this.logger.level <= 400) {
            this.logger.log("notifyLivenessListeners(" + i + "," + liveness + ")");
        }
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            temp = new ArrayList<LivenessListener<Identifier>>(this.livenessListeners);
        }
        for (LivenessListener livenessListener : temp) {
            livenessListener.livenessChanged(i, liveness, options);
        }
    }

    @Override
    public void incomingSocket(P2PSocket<SourceRoute<Identifier>> s) throws IOException {
        this.callback.incomingSocket(new SourceRouteManagerP2PSocket<Identifier>(s, this.logger, this.errorHandler, this.environment));
    }

    @Override
    public void messageReceived(SourceRoute<Identifier> i, ByteBuffer m, Map<String, Object> options) throws IOException {
        this.callback.messageReceived(i.getLastHop(), m, options);
    }

    @Override
    public void livenessChanged(SourceRoute<Identifier> i, int val, Map<String, Object> options) {
        if (this.logger.level <= 400) {
            this.logger.log("livenessChanged(" + i + "," + val + ")");
        }
        this.getAddressManager(i.getLastHop()).livenessChanged(i, val, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProximityListener(ProximityListener<Identifier> listener) {
        Collection<ProximityListener<Identifier>> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeProximityListener(ProximityListener<Identifier> listener) {
        Collection<ProximityListener<Identifier>> collection = this.listeners;
        synchronized (collection) {
            return this.listeners.remove(listener);
        }
    }

    @Override
    public void proximityChanged(SourceRoute<Identifier> i, int newProximity, Map<String, Object> options) {
        this.getAddressManager(i.getLastHop()).markProximity(i, newProximity, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyProximityListeners(Identifier i, int prox, Map<String, Object> options) {
        ArrayList<ProximityListener<Identifier>> temp;
        Collection<ProximityListener<Identifier>> collection = this.listeners;
        synchronized (collection) {
            temp = new ArrayList<ProximityListener<Identifier>>(this.listeners);
        }
        for (ProximityListener proximityListener : temp) {
            proximityListener.proximityChanged(i, prox, options);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AddressManager {
        protected Identifier address;
        protected SourceRoute<Identifier> best;
        protected LinkedList<org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManagerImpl$AddressManager.PendingMessage> pendingMessages;
        protected LinkedList<org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManagerImpl$AddressManager.PendingSocket> pendingSockets;
        protected int liveness;
        protected long updated;
        public static final int LIVENESS_UNKNOWN = -1;
        HashSet<SourceRoute<Identifier>> routes = new HashSet();

        public AddressManager(Identifier address) {
            this.address = address;
            this.pendingMessages = new LinkedList();
            this.pendingSockets = new LinkedList();
            if (SourceRouteManagerImpl.this.logger.level <= 500) {
                SourceRouteManagerImpl.this.logger.log("new AddressManager(" + address + ")");
            }
            this.clearLivenessState();
        }

        public void clearLivenessState() {
            ArrayList temp = new ArrayList(this.routes);
            this.routes.clear();
            for (SourceRoute sr : temp) {
                SourceRouteManagerImpl.this.livenessProvider.clearState(sr);
                SourceRouteManagerImpl.this.proxProvider.clearState(sr);
            }
            if (!this.pendingMessages.isEmpty() || !this.pendingSockets.isEmpty()) {
                NodeIsFaultyException reason = new NodeIsFaultyException(this.address, "State cleared. for " + this);
                ArrayList<org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManagerImpl$AddressManager.PendingSocket> temp3 = new ArrayList<org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManagerImpl$AddressManager.PendingSocket>(this.pendingSockets);
                this.pendingSockets.clear();
                for (PendingSocket pendingSocket : temp3) {
                    if (SourceRouteManagerImpl.this.logger.level <= 500) {
                        SourceRouteManagerImpl.this.logger.log(this + ".clearLivenessState()1 " + pendingSocket);
                    }
                    pendingSocket.fail(reason);
                }
                ArrayList<org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManagerImpl$AddressManager.PendingMessage> temp2 = new ArrayList<org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManagerImpl$AddressManager.PendingMessage>(this.pendingMessages);
                this.pendingMessages.clear();
                for (PendingMessage pendingMessage : temp2) {
                    if (SourceRouteManagerImpl.this.logger.level <= 500) {
                        SourceRouteManagerImpl.this.logger.log(this + ".clearLivenessState()2 " + pendingMessage);
                    }
                    pendingMessage.fail(reason);
                }
            }
            this.liveness = -1;
            this.updated = 0L;
            this.best = SourceRouteManagerImpl.this.srFactory.getSourceRoute(SourceRouteManagerImpl.this.localAddress, this.address);
            this.routes.add(this.best);
        }

        public int proximity(Map<String, Object> options) {
            if (this.best == null) {
                return 3600000;
            }
            return SourceRouteManagerImpl.this.proxProvider.proximity(this.best, options);
        }

        public int getLiveness(Map<String, Object> options) {
            if (this.liveness == -1) {
                if (SourceRouteManagerImpl.this.environment.getTimeSource().currentTimeMillis() >= this.updated + (long)SourceRouteManagerImpl.this.CHECK_LIVENESS_THROTTLE) {
                    this.checkLiveness(options);
                }
                return 2;
            }
            return this.liveness;
        }

        public MessageRequestHandle<Identifier, ByteBuffer> sendMessage(ByteBuffer message, final MessageCallback<Identifier, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
            if (this.liveness == 3) {
                SourceRouteManagerImpl.this.livenessProvider.checkLiveness(SourceRouteManagerImpl.this.srFactory.getSourceRoute(SourceRouteManagerImpl.this.getLocalIdentifier(), this.address), options);
                this.updated = SourceRouteManagerImpl.this.environment.getTimeSource().currentTimeMillis();
            }
            if (this.best == null) {
                PendingMessage pending = new PendingMessage(message, deliverAckToMe, options);
                this.pendingMessages.addLast((org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManagerImpl$AddressManager.PendingMessage)pending);
                SourceRouteManagerImpl.this.addHardLink(this);
                return pending;
            }
            final MessageRequestHandleImpl handle = new MessageRequestHandleImpl(this.address, message, options);
            handle.setSubCancellable(SourceRouteManagerImpl.this.tl.sendMessage(this.best, message, new MessageCallback<SourceRoute<Identifier>, ByteBuffer>(){

                @Override
                public void ack(MessageRequestHandle<SourceRoute<Identifier>, ByteBuffer> msg) {
                    if (handle.getSubCancellable() != null && msg != handle.getSubCancellable()) {
                        throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + handle.getSubCancellable());
                    }
                    if (deliverAckToMe != null) {
                        deliverAckToMe.ack(handle);
                    }
                }

                @Override
                public void sendFailed(MessageRequestHandle<SourceRoute<Identifier>, ByteBuffer> msg, Exception ex) {
                    if (handle.getSubCancellable() != null && msg != handle.getSubCancellable()) {
                        throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + handle.getSubCancellable());
                    }
                    if (deliverAckToMe == null) {
                        SourceRouteManagerImpl.this.errorHandler.receivedException(AddressManager.this.address, ex);
                    } else {
                        deliverAckToMe.sendFailed(handle, ex);
                    }
                }
            }, options));
            return handle;
        }

        public SocketRequestHandle<Identifier> openSocket(final SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
            if (deliverSocketToMe == null) {
                throw new IllegalArgumentException("deliverSocketToMe must be non-null!");
            }
            if (this.liveness == 3) {
                SourceRouteManagerImpl.this.livenessProvider.checkLiveness(SourceRouteManagerImpl.this.srFactory.getSourceRoute(SourceRouteManagerImpl.this.getLocalIdentifier(), this.address), options);
                this.updated = SourceRouteManagerImpl.this.environment.getTimeSource().currentTimeMillis();
            }
            if (this.best == null) {
                PendingSocket pending = new PendingSocket(deliverSocketToMe, options);
                this.pendingSockets.addLast((org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManagerImpl$AddressManager.PendingSocket)pending);
                SourceRouteManagerImpl.this.addHardLink(this);
                return pending;
            }
            final SocketRequestHandleImpl handle = new SocketRequestHandleImpl(this.address, options, SourceRouteManagerImpl.this.logger);
            handle.setSubCancellable(SourceRouteManagerImpl.this.tl.openSocket(this.best, new SocketCallback<SourceRoute<Identifier>>(){

                @Override
                public void receiveResult(SocketRequestHandle<SourceRoute<Identifier>> cancellable, P2PSocket<SourceRoute<Identifier>> sock) {
                    deliverSocketToMe.receiveResult(handle, new SourceRouteManagerP2PSocket(sock, SourceRouteManagerImpl.this.logger, SourceRouteManagerImpl.this.errorHandler, SourceRouteManagerImpl.this.environment));
                }

                @Override
                public void receiveException(SocketRequestHandle<SourceRoute<Identifier>> s, Exception ex) {
                    deliverSocketToMe.receiveException(handle, ex);
                }
            }, options));
            return handle;
        }

        public boolean checkLiveness(Map<String, Object> options) {
            long now;
            this.updated = now = SourceRouteManagerImpl.this.environment.getTimeSource().currentTimeMillis();
            switch (this.liveness) {
                case 3: 
                case 4: {
                    if (SourceRouteManagerImpl.this.logger.level <= 500) {
                        SourceRouteManagerImpl.this.logger.logException("(SSRM) CHECKLIVENESS: CHECKING DEAD ON DEAD ADDRESS " + this.address + " - JUST IN CASE, NO HARM ANYWAY", new Exception("Stack Trace"));
                    }
                    boolean ret = false;
                    if (SourceRouteManagerImpl.this.livenessProvider.checkLiveness(SourceRouteManagerImpl.this.srFactory.getSourceRoute(SourceRouteManagerImpl.this.getLocalIdentifier(), this.address), options)) {
                        ret = true;
                    }
                    Collection newroutes = SourceRouteManagerImpl.this.strategy.getSourceRoutes(this.address);
                    for (SourceRoute route : newroutes) {
                        if (!SourceRouteManagerImpl.this.livenessProvider.checkLiveness(route, options)) continue;
                        ret = true;
                    }
                    return ret;
                }
            }
            SourceRoute temp = this.best;
            if (temp != null) {
                boolean ret = SourceRouteManagerImpl.this.livenessProvider.checkLiveness(this.best, options);
                if (!temp.isDirect()) {
                    SourceRouteManagerImpl.this.livenessProvider.checkLiveness(SourceRouteManagerImpl.this.srFactory.getSourceRoute(SourceRouteManagerImpl.this.getLocalIdentifier(), this.address), options);
                }
                return ret;
            }
            return false;
        }

        public String toString() {
            return "AM " + this.address;
        }

        public void livenessChanged(SourceRoute<Identifier> i, int val, Map<String, Object> options) {
            this.routes.add(i);
            if (!i.getLastHop().equals(this.address)) {
                throw new IllegalArgumentException(i + "!=" + this.address + " val:" + val);
            }
            switch (val) {
                case 1: {
                    this.markAlive(i, options);
                    return;
                }
                case 2: {
                    this.markSuspected(i, options);
                    return;
                }
                case 3: {
                    this.markDead(i, options);
                    return;
                }
                case 4: {
                    this.markDeadForever(options);
                    return;
                }
            }
            throw new IllegalArgumentException("Unexpected val:" + val + " i:" + i + " address:" + this.address);
        }

        protected synchronized void markAlive(SourceRoute<Identifier> route, Map<String, Object> options) {
            if (SourceRouteManagerImpl.this.logger.level <= 400) {
                SourceRouteManagerImpl.this.logger.log(this + " markAlive(" + route + "):" + this.best);
            }
            if (this.best == null) {
                if (SourceRouteManagerImpl.this.logger.level <= 500) {
                    SourceRouteManagerImpl.this.logger.log("(SSRM) No previous best route existed to " + this.address + " route " + route + " is now the best");
                }
                this.best = route;
            }
            if (this.best.getNumHops() > route.getNumHops() || this.best.getNumHops() == route.getNumHops() && SourceRouteManagerImpl.this.proxProvider.proximity(this.best, options) > SourceRouteManagerImpl.this.proxProvider.proximity(route, options)) {
                if (SourceRouteManagerImpl.this.logger.level <= 500) {
                    SourceRouteManagerImpl.this.logger.log("(SSRM) Route " + route + " is better than previous best route " + this.best + " - replacing");
                }
                this.best = route;
            }
            this.setAlive(options);
        }

        protected synchronized void markSuspected(SourceRoute<Identifier> route, Map<String, Object> options) {
            if (SourceRouteManagerImpl.this.logger.level <= 400) {
                SourceRouteManagerImpl.this.logger.log(this + " markSuspected(" + route + "):" + this.best);
            }
            if ((this.best == null || this.best.equals(route)) && this.liveness < 3) {
                this.setSuspected(options);
            }
        }

        protected synchronized void markDead(SourceRoute<Identifier> deadRoute, Map<String, Object> options) {
            if (SourceRouteManagerImpl.this.logger.level <= 500) {
                SourceRouteManagerImpl.this.logger.log(this + " markDead(" + deadRoute + "):" + this.best);
            }
            if (this.liveness >= 3) {
                return;
            }
            if (this.best == null || deadRoute.equals(this.best)) {
                this.best = null;
                Collection newroutes = SourceRouteManagerImpl.this.strategy.getSourceRoutes(this.address);
                this.routes.addAll(newroutes);
                boolean found = false;
                SourceRoute newBest = null;
                for (SourceRoute route : new ArrayList(this.routes)) {
                    if (!route.getLastHop().equals(this.address)) {
                        if (SourceRouteManagerImpl.this.logger.level > 1000) continue;
                        SourceRouteManagerImpl.this.logger.log("SRStrategy " + SourceRouteManagerImpl.this.strategy + " is broken.  It returned " + route + " as a route to " + this.address);
                        continue;
                    }
                    if (SourceRouteManagerImpl.this.livenessProvider.checkLiveness(route, options)) {
                        if (SourceRouteManagerImpl.this.logger.level <= 300) {
                            SourceRouteManagerImpl.this.logger.log(this + " Checking " + route);
                        }
                        found = true;
                    }
                    if (SourceRouteManagerImpl.this.livenessProvider.getLiveness(route, options) >= 3) continue;
                    if (newBest == null || newBest.getNumHops() > route.getNumHops() || newBest.getNumHops() == route.getNumHops() && SourceRouteManagerImpl.this.proxProvider.proximity(newBest, options) > SourceRouteManagerImpl.this.proxProvider.proximity(route, options)) {
                        newBest = route;
                    }
                    if (SourceRouteManagerImpl.this.logger.level <= 300) {
                        SourceRouteManagerImpl.this.logger.log(this + " Found " + route);
                    }
                    found = true;
                }
                if (newBest != null) {
                    if (SourceRouteManagerImpl.this.logger.level <= 500) {
                        SourceRouteManagerImpl.this.logger.log("Found existing known route " + newBest + " to replace old dead route " + deadRoute + " - replacing");
                    }
                    this.best = newBest;
                    int tempLiveness = SourceRouteManagerImpl.this.livenessProvider.getLiveness(newBest, options);
                    if (tempLiveness == 1) {
                        this.setAlive(options);
                    } else if (tempLiveness == 2) {
                        this.setSuspected(options);
                    }
                    return;
                }
                if (found) {
                    this.setSuspected(options);
                } else {
                    this.setDead(options);
                }
            }
        }

        protected synchronized void markDeadForever(Map<String, Object> options) {
            this.best = null;
            this.setDeadForever(options);
        }

        protected synchronized void markProximity(SourceRoute<Identifier> route, int proximity, Map<String, Object> options) {
            if (this.best == null) {
                if (SourceRouteManagerImpl.this.logger.level <= 500) {
                    SourceRouteManagerImpl.this.logger.log("(SSRM) No previous best route existed to " + this.address + " route " + route + " is now the best");
                }
                this.best = route;
            }
            if (route.equals(this.best)) {
                SourceRouteManagerImpl.this.notifyProximityListeners(this.address, proximity, options);
            }
        }

        protected void setAlive(Map<String, Object> options) {
            if (SourceRouteManagerImpl.this.logger.level <= 500) {
                SourceRouteManagerImpl.this.logger.log(this + "setAlive():" + this.best);
            }
            if (this.best == null) {
                throw new IllegalStateException("best is null in " + this.toString());
            }
            while (!this.pendingMessages.isEmpty()) {
                PendingMessage pm = (PendingMessage)this.pendingMessages.removeFirst();
                pm.cancellable = SourceRouteManagerImpl.this.tl.sendMessage(this.best, pm.message, pm, pm.options);
            }
            while (!this.pendingSockets.isEmpty()) {
                PendingSocket pas = (PendingSocket)this.pendingSockets.removeFirst();
                pas.cancellable = SourceRouteManagerImpl.this.tl.openSocket(this.best, pas, pas.options);
            }
            if (this.pendingMessages.isEmpty() && this.pendingSockets.isEmpty()) {
                SourceRouteManagerImpl.this.hardLinks.remove(this);
            }
            switch (this.liveness) {
                case 3: 
                case 4: {
                    this.liveness = 1;
                    SourceRouteManagerImpl.this.notifyLivenessListeners(this.address, 1, options);
                    if (SourceRouteManagerImpl.this.logger.level > 500) break;
                    SourceRouteManagerImpl.this.logger.log("COUNT: " + SourceRouteManagerImpl.this.localAddress + " Found address " + this.address + " to be alive again.");
                    break;
                }
                case -1: 
                case 2: {
                    this.liveness = 1;
                    SourceRouteManagerImpl.this.notifyLivenessListeners(this.address, 1, options);
                    if (SourceRouteManagerImpl.this.logger.level > 500) break;
                    SourceRouteManagerImpl.this.logger.log("COUNT: " + SourceRouteManagerImpl.this.localAddress + " Found address " + this.address + " to be unsuspected.");
                }
            }
        }

        protected void setSuspected(Map<String, Object> options) {
            switch (this.liveness) {
                case -1: 
                case 1: {
                    this.liveness = 2;
                    SourceRouteManagerImpl.this.notifyLivenessListeners(this.address, 2, options);
                    if (SourceRouteManagerImpl.this.logger.level > 500) break;
                    SourceRouteManagerImpl.this.logger.log("COUNT: " + SourceRouteManagerImpl.this.environment.getTimeSource().currentTimeMillis() + " " + SourceRouteManagerImpl.this.localAddress + " Found address " + this.address + " to be suspected.");
                    break;
                }
                case 3: 
                case 4: {
                    this.liveness = 2;
                    SourceRouteManagerImpl.this.notifyLivenessListeners(this.address, 2, options);
                    if (SourceRouteManagerImpl.this.logger.level > 900) break;
                    SourceRouteManagerImpl.this.logger.logException("ERROR: Found node handle " + this.address + " to be suspected from dead - should not happen!", new Exception("Stack Trace"));
                }
            }
        }

        protected void setDead(Map<String, Object> options) {
            switch (this.liveness) {
                case 3: 
                case 4: {
                    return;
                }
            }
            this.best = null;
            this.liveness = 3;
            SourceRouteManagerImpl.this.notifyLivenessListeners(this.address, 3, options);
            if (SourceRouteManagerImpl.this.logger.level <= 500) {
                SourceRouteManagerImpl.this.logger.log("COUNT: " + SourceRouteManagerImpl.this.localAddress + " Found address " + this.address + " to be dead.");
            }
            this.purgeQueue();
        }

        protected void setDeadForever(Map<String, Object> options) {
            switch (this.liveness) {
                case 4: {
                    return;
                }
                case 3: {
                    this.liveness = 4;
                    if (SourceRouteManagerImpl.this.logger.level > 500) break;
                    SourceRouteManagerImpl.this.logger.log("Found address " + this.address + " to be dead forever.");
                    break;
                }
                default: {
                    this.best = null;
                    this.liveness = 4;
                    SourceRouteManagerImpl.this.notifyLivenessListeners(this.address, 4, options);
                    if (SourceRouteManagerImpl.this.logger.level > 500) break;
                    SourceRouteManagerImpl.this.logger.log("Found address " + this.address + " to be dead forever.");
                }
            }
            this.purgeQueue();
            this.clearLivenessState();
        }

        protected void purgeQueue() {
            while (!this.pendingMessages.isEmpty()) {
                PendingMessage pm = (PendingMessage)this.pendingMessages.removeFirst();
                if (pm.deliverAckToMe == null) continue;
                pm.deliverAckToMe.sendFailed(pm, new NodeIsFaultyException(this.address));
            }
            while (!this.pendingSockets.isEmpty()) {
                PendingSocket ps = (PendingSocket)this.pendingSockets.removeFirst();
                ps.deliverSocketToMe.receiveException(ps, new NodeIsFaultyException(this.address));
            }
            SourceRouteManagerImpl.this.removeHardLink(this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PendingMessage
        implements MessageRequestHandle<Identifier, ByteBuffer>,
        MessageCallback<SourceRoute<Identifier>, ByteBuffer> {
            private ByteBuffer message;
            private MessageCallback<Identifier, ByteBuffer> deliverAckToMe;
            private Map<String, Object> options;
            private Cancellable cancellable;

            public PendingMessage(ByteBuffer message, MessageCallback<Identifier, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
                this.message = message;
                this.deliverAckToMe = deliverAckToMe;
                this.options = options;
            }

            @Override
            public boolean cancel() {
                if (this.cancellable == null) {
                    return AddressManager.this.pendingMessages.remove(this);
                }
                return this.cancellable.cancel();
            }

            @Override
            public Map<String, Object> getOptions() {
                return this.options;
            }

            @Override
            public Identifier getIdentifier() {
                return AddressManager.this.address;
            }

            @Override
            public ByteBuffer getMessage() {
                return this.message;
            }

            @Override
            public void ack(MessageRequestHandle<SourceRoute<Identifier>, ByteBuffer> msg) {
                this.deliverAckToMe.ack(this);
            }

            @Override
            public void sendFailed(MessageRequestHandle<SourceRoute<Identifier>, ByteBuffer> msg, Exception reason) {
                this.deliverAckToMe.sendFailed(this, reason);
            }

            public void fail(Exception reason) {
                this.cancel();
                this.sendFailed((MessageRequestHandle<SourceRoute<Identifier>, ByteBuffer>)null, reason);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PendingSocket
        implements SocketRequestHandle<Identifier>,
        SocketCallback<SourceRoute<Identifier>> {
            private SocketCallback<Identifier> deliverSocketToMe;
            private Map<String, Object> options;
            private Cancellable cancellable;

            public PendingSocket(SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
                this.deliverSocketToMe = deliverSocketToMe;
                this.options = options;
            }

            @Override
            public void receiveResult(SocketRequestHandle<SourceRoute<Identifier>> cancellable, P2PSocket<SourceRoute<Identifier>> sock) {
                this.deliverSocketToMe.receiveResult(this, new SourceRouteManagerP2PSocket(sock, SourceRouteManagerImpl.this.logger, SourceRouteManagerImpl.this.errorHandler, SourceRouteManagerImpl.this.environment));
            }

            @Override
            public void receiveException(SocketRequestHandle<SourceRoute<Identifier>> s, Exception ex) {
                this.deliverSocketToMe.receiveException(this, ex);
            }

            public void fail(Exception ex) {
                this.cancel();
                this.receiveException((SocketRequestHandle<SourceRoute<Identifier>>)null, ex);
            }

            @Override
            public boolean cancel() {
                if (this.cancellable == null) {
                    return AddressManager.this.pendingSockets.remove(this);
                }
                return this.cancellable.cancel();
            }

            @Override
            public Identifier getIdentifier() {
                return AddressManager.this.address;
            }

            @Override
            public Map<String, Object> getOptions() {
                return this.options;
            }
        }
    }
}

