/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.rendezvous;

import java.io.IOException;
import java.net.BindException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.rendezvous.ContactDeserializer;
import org.mpisws.p2p.transport.rendezvous.ContactDirectStrategy;
import org.mpisws.p2p.transport.rendezvous.EphemeralDB;
import org.mpisws.p2p.transport.rendezvous.EphemeralDBImpl;
import org.mpisws.p2p.transport.rendezvous.IncomingPilotListener;
import org.mpisws.p2p.transport.rendezvous.OutgoingPilotListener;
import org.mpisws.p2p.transport.rendezvous.PilotFinder;
import org.mpisws.p2p.transport.rendezvous.PilotManager;
import org.mpisws.p2p.transport.rendezvous.RendezvousContact;
import org.mpisws.p2p.transport.rendezvous.RendezvousGenerationStrategy;
import org.mpisws.p2p.transport.rendezvous.RendezvousStrategy;
import org.mpisws.p2p.transport.rendezvous.RendezvousTransportLayer;
import org.mpisws.p2p.transport.rendezvous.ResponseStrategy;
import org.mpisws.p2p.transport.sourceroute.Forwarder;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.InsufficientBytesException;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.OptionsFactory;
import org.mpisws.p2p.transport.util.SocketInputBuffer;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketWrapperSocket;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.random.RandomSource;
import rice.environment.time.TimeSource;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.p2p.util.tuples.MutableTuple;
import rice.p2p.util.tuples.Tuple;
import rice.selector.SelectorManager;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendezvousTransportLayerImpl<Identifier, HighIdentifier extends RendezvousContact>
implements TransportLayer<Identifier, ByteBuffer>,
TransportLayerCallback<Identifier, ByteBuffer>,
PilotManager<HighIdentifier>,
RendezvousTransportLayer<HighIdentifier> {
    public static final byte NORMAL_SOCKET = 0;
    public static final byte CONNECTOR_SOCKET = 1;
    public static final byte ACCEPTOR_SOCKET = 2;
    public static final byte PILOT_SOCKET = 3;
    public static final byte CONNECTION_RESPONSE_FAILURE = 0;
    public static final byte CONNECTION_RESPONSE_SUCCESS = 1;
    public static final long NO_TAG = Long.MIN_VALUE;
    public static final String TAG_KEY = "RendezvousTransportLayer.UDP_TAG";
    public static final String FROM_OVERLAY = "rendezvous.from_overlay";
    public static final String OPTION_USE_PILOT = "USE_PILOT";
    public String RENDEZVOUS_CONTACT_STRING;
    protected TransportLayer<Identifier, ByteBuffer> tl;
    protected TransportLayerCallback<Identifier, ByteBuffer> callback;
    protected RendezvousGenerationStrategy<HighIdentifier> rendezvousGenerator;
    protected PilotFinder<HighIdentifier> pilotFinder;
    protected RendezvousStrategy<HighIdentifier> rendezvousStrategy;
    protected ResponseStrategy<Identifier> responseStrategy;
    protected HighIdentifier localNodeHandle;
    protected Logger logger;
    protected ContactDeserializer<Identifier, HighIdentifier> serializer;
    protected SelectorManager selectorManager;
    protected RandomSource random;
    protected TimeSource time;
    protected EphemeralDB<Identifier, HighIdentifier> ephemeralDB;
    protected ContactDirectStrategy<HighIdentifier> contactDirectStrategy;
    protected ErrorHandler<Identifier> errorHandler;
    Map<HighIdentifier, Map<Integer, Tuple<SocketCallback<Identifier>, SocketRequestHandle<Identifier>>>> expectedIncomingSockets = new HashMap<HighIdentifier, Map<Integer, Tuple<SocketCallback<Identifier>, SocketRequestHandle<Identifier>>>>();
    Map<HighIdentifier, Map<HighIdentifier, Map<Integer, P2PSocket<Identifier>>>> connectSockets = new HashMap<HighIdentifier, Map<HighIdentifier, Map<Integer, P2PSocket<Identifier>>>>();
    Map<HighIdentifier, OutgoingPilot> outgoingPilots = new HashMap<HighIdentifier, OutgoingPilot>();
    ArrayList<OutgoingPilotListener<HighIdentifier>> opListeners = new ArrayList();
    public static final byte PILOT_PING = 1;
    public static final byte PILOT_PONG = 2;
    public static final byte PILOT_REQUEST = 3;
    public static final byte[] PILOT_PING_BYTES = new byte[]{1};
    public static final byte[] PILOT_PONG_BYTES = new byte[]{2};
    public static final byte[] PILOT_SOCKET_BYTES = new byte[]{3};
    public static final int PILOT_PING_PERIOD = 5000;
    Map<HighIdentifier, IncomingPilot> incomingPilots = new HashMap<HighIdentifier, IncomingPilot>();
    ArrayList<IncomingPilotListener<HighIdentifier>> ipListeners = new ArrayList();

    public RendezvousTransportLayerImpl(TransportLayer<Identifier, ByteBuffer> tl, String RENDEZVOUS_CONTACT_STRING, HighIdentifier myRendezvousContact, ContactDeserializer<Identifier, HighIdentifier> deserializer, RendezvousGenerationStrategy<HighIdentifier> rendezvousGenerator, PilotFinder<HighIdentifier> pilotFinder, RendezvousStrategy<HighIdentifier> rendezvousStrategy, ResponseStrategy<Identifier> responseStrategy, ContactDirectStrategy<HighIdentifier> contactDirectStrategy, Environment env) {
        this.random = env.getRandomSource();
        this.time = env.getTimeSource();
        this.selectorManager = env.getSelectorManager();
        this.tl = tl;
        this.localNodeHandle = myRendezvousContact;
        this.serializer = deserializer;
        this.RENDEZVOUS_CONTACT_STRING = RENDEZVOUS_CONTACT_STRING;
        this.rendezvousGenerator = rendezvousGenerator;
        this.pilotFinder = pilotFinder;
        this.rendezvousStrategy = rendezvousStrategy;
        this.responseStrategy = responseStrategy;
        this.contactDirectStrategy = contactDirectStrategy;
        this.ephemeralDB = new EphemeralDBImpl(env, 0x6DDD00L);
        this.logger = env.getLogManager().getLogger(RendezvousTransportLayerImpl.class, null);
        this.errorHandler = new DefaultErrorHandler(this.logger);
        tl.setCallback(this);
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(Identifier i, final SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
        if (this.logger.level <= 300) {
            this.logger.log("openSocket(" + i + "," + deliverSocketToMe + "," + options + ")");
        }
        final SocketRequestHandleImpl<Identifier> handle = new SocketRequestHandleImpl<Identifier>(i, options, this.logger);
        HighIdentifier contact = this.getHighIdentifier(options);
        if (contact == null || contact.canContactDirect() || this.contactDirectStrategy.canContactDirect(contact)) {
            if (this.logger.level <= 400) {
                String s = "null";
                if (contact != null) {
                    s = contact + " strat:" + this.contactDirectStrategy.canContactDirect(contact);
                }
                this.logger.log("openSocket(" + i + "," + deliverSocketToMe + "," + options + ") contact:" + s);
            }
            this.tl.openSocket(i, new SocketCallback<Identifier>(){

                @Override
                public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                    sock.register(false, true, new ByteWriter(0, new Continuation<P2PSocket<Identifier>, Exception>(){

                        @Override
                        public void receiveResult(P2PSocket<Identifier> socket) {
                            deliverSocketToMe.receiveResult(handle, socket);
                        }

                        @Override
                        public void receiveException(Exception exception) {
                            deliverSocketToMe.receiveException(handle, exception);
                        }
                    }));
                }

                @Override
                public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                    deliverSocketToMe.receiveException(handle, ex);
                }
            }, options);
            return handle;
        }
        if (options.containsKey(OPTION_USE_PILOT)) {
            RendezvousContact middleMan = (RendezvousContact)options.get(OPTION_USE_PILOT);
            if (this.logger.level <= 400) {
                this.logger.log("Opening socket to " + contact + " OPTION_USE_PILOT->" + middleMan);
            }
            this.openSocketViaPilot(contact, middleMan, handle, deliverSocketToMe, options);
            return handle;
        }
        if (this.localNodeHandle.canContactDirect()) {
            if (this.openSocketUsingPilotToMe(contact, handle, deliverSocketToMe, options)) {
                return handle;
            }
            if (this.openSocketUsingPilotFinder(contact, handle, deliverSocketToMe, options)) {
                return handle;
            }
            this.openSocketUsingRouting(contact, handle, deliverSocketToMe, options);
            return handle;
        }
        if (this.openSocketUsingPilotFinder(contact, handle, deliverSocketToMe, options)) {
            return handle;
        }
        ArrayList<HighIdentifier> myPilots = new ArrayList<HighIdentifier>(this.outgoingPilots.keySet());
        if (myPilots.isEmpty()) {
            deliverSocketToMe.receiveException(handle, new IllegalStateException("No available outgoing pilots."));
        }
        RendezvousContact middleMan = (RendezvousContact)myPilots.get(this.random.nextInt(myPilots.size()));
        this.openSocketViaPilot(contact, middleMan, handle, deliverSocketToMe, options);
        return handle;
    }

    private void openSocketUsingRouting(final HighIdentifier contact, final SocketRequestHandle<Identifier> handle, final SocketCallback<Identifier> deliverSocketToMe, final Map<String, Object> options) {
        if (this.logger.level <= 400) {
            this.logger.log("opening a socket using routing to " + contact);
        }
        int uid = this.random.nextInt();
        this.putExpectedIncomingSocket(contact, uid, deliverSocketToMe, handle);
        this.rendezvousStrategy.openChannel(contact, this.localNodeHandle, this.localNodeHandle, uid, new Continuation<Integer, Exception>(){

            @Override
            public void receiveResult(Integer result) {
            }

            @Override
            public void receiveException(Exception exception) {
                if (RendezvousTransportLayerImpl.this.logger.level <= 800) {
                    RendezvousTransportLayerImpl.this.logger.logException("openSocket(" + contact + "," + deliverSocketToMe + "," + options + ")", exception);
                }
                deliverSocketToMe.receiveException(handle, exception);
            }
        }, options);
    }

    private boolean openSocketUsingPilotFinder(HighIdentifier contact, SocketRequestHandle<Identifier> handle, SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
        RendezvousContact middleMan = (RendezvousContact)this.pilotFinder.findPilot(contact);
        if (middleMan == null) {
            return false;
        }
        if (this.logger.level <= 400) {
            this.logger.log("opening a socket to " + contact + " via " + middleMan);
        }
        this.openSocketViaPilot(contact, middleMan, handle, deliverSocketToMe, options);
        return true;
    }

    protected boolean openSocketUsingPilotToMe(HighIdentifier contact, SocketRequestHandle<Identifier> handle, SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
        int uid = this.random.nextInt();
        this.putExpectedIncomingSocket(contact, uid, deliverSocketToMe, handle);
        if (this.incomingPilots.containsKey(contact)) {
            if (this.logger.level <= 500) {
                this.logger.log("Opening socket to firewalled node that I have a pilot to: " + contact + " uid:" + uid);
            }
            try {
                this.incomingPilots.get(contact).requestSocket(this.localNodeHandle, uid);
            }
            catch (IOException ioe) {
                this.removeExpectedIncomingSocket(contact, uid);
                deliverSocketToMe.receiveException(handle, ioe);
            }
            return true;
        }
        return false;
    }

    protected void openSocketViaPilot(HighIdentifier dest, HighIdentifier middleMan, final SocketRequestHandle<Identifier> handle, final SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
        if (middleMan.equals(this.localNodeHandle)) {
            throw new IllegalArgumentException("openSocketViaPilot(" + dest + "," + middleMan + "," + handle + "," + deliverSocketToMe + "," + options + ") can't use self as rendezvous.");
        }
        final int uid = this.random.nextInt();
        if (this.logger.level <= 500) {
            this.logger.log("openSocketViaPilot<" + uid + ">(" + dest + "," + middleMan + "," + handle + "," + deliverSocketToMe + "," + options + ")");
        }
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        try {
            sob.writeByte((byte)1);
            this.serializer.serialize(dest, sob);
            this.serializer.serialize(this.localNodeHandle, sob);
            sob.writeInt(uid);
        }
        catch (IOException ioe) {
            deliverSocketToMe.receiveException(handle, ioe);
        }
        final ByteBuffer writeBuffer = sob.getByteBuffer();
        ByteBuffer readBuffer = ByteBuffer.allocate(1);
        this.tl.openSocket(this.serializer.convert(middleMan), new SocketCallback<Identifier>((RendezvousContact)dest, (RendezvousContact)middleMan, readBuffer, options){
            final /* synthetic */ RendezvousContact val$dest;
            final /* synthetic */ RendezvousContact val$middleMan;
            final /* synthetic */ ByteBuffer val$readBuffer;
            final /* synthetic */ Map val$options;
            {
                this.val$dest = rendezvousContact;
                this.val$middleMan = rendezvousContact2;
                this.val$readBuffer = byteBuffer2;
                this.val$options = map;
            }

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                try {
                    new P2PSocketReceiver<Identifier>(){

                        @Override
                        public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                            if (writeBuffer.hasRemaining()) {
                                long bytesWritten = socket.write(writeBuffer);
                                if (bytesWritten < 0L) {
                                    deliverSocketToMe.receiveException(handle, new ClosedChannelException("Channel closed detected to <" + uid + "> " + val$dest + " via " + val$middleMan + " in " + RendezvousTransportLayerImpl.this));
                                    return;
                                }
                                if (writeBuffer.hasRemaining()) {
                                    socket.register(false, true, this);
                                    return;
                                }
                            }
                            if (!writeBuffer.hasRemaining()) {
                                if (val$readBuffer.hasRemaining()) {
                                    long bytesRead = socket.read(val$readBuffer);
                                    if (bytesRead < 0L) {
                                        deliverSocketToMe.receiveException(handle, new ClosedChannelException("Channel closed detected to <" + uid + "> " + val$dest + " via " + val$middleMan + " in " + RendezvousTransportLayerImpl.this));
                                        return;
                                    }
                                    if (val$readBuffer.hasRemaining()) {
                                        socket.register(true, false, this);
                                        return;
                                    }
                                }
                                val$readBuffer.flip();
                                byte response = val$readBuffer.get();
                                switch (response) {
                                    case 1: {
                                        if (RendezvousTransportLayerImpl.this.logger.level <= 500) {
                                            RendezvousTransportLayerImpl.this.logger.log("success in openSocketViaPilot<" + uid + ">(" + val$dest + "," + val$middleMan + "," + handle + "," + deliverSocketToMe + "," + val$options + ")");
                                        }
                                        deliverSocketToMe.receiveResult(handle, socket);
                                        return;
                                    }
                                }
                                deliverSocketToMe.receiveException(handle, new ClosedChannelException("Failed to connect to <" + uid + "> " + val$dest + " via " + val$middleMan + " in " + RendezvousTransportLayerImpl.this + " response:" + response));
                                return;
                            }
                        }

                        @Override
                        public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
                            deliverSocketToMe.receiveException(handle, ioe);
                        }
                    }.receiveSelectResult(sock, false, true);
                }
                catch (IOException ioe) {
                    deliverSocketToMe.receiveException(handle, ioe);
                }
            }

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                deliverSocketToMe.receiveException(handle, ex);
            }
        }, options);
    }

    protected void routeForSocket() {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
        if (this.logger.level <= 300) {
            this.logger.log("incomingSocket(" + s + ")");
        }
        new P2PSocketReceiver<Identifier>(){

            @Override
            public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                ByteBuffer buf;
                long bytesRead;
                if (RendezvousTransportLayerImpl.this.logger.level <= 300) {
                    RendezvousTransportLayerImpl.this.logger.log("incomingSocket(" + socket + ").rSR(" + canRead + "," + canWrite + ")");
                }
                if ((bytesRead = socket.read(buf = ByteBuffer.allocate(1))) == 0L) {
                    socket.register(true, false, this);
                    return;
                }
                if (bytesRead < 0L) {
                    socket.close();
                    return;
                }
                buf.flip();
                byte socketType = buf.get();
                switch (socketType) {
                    case 0: {
                        if (RendezvousTransportLayerImpl.this.logger.level <= 300) {
                            RendezvousTransportLayerImpl.this.logger.log("incomingSocket(" + socket + ").rSR(" + canRead + "," + canWrite + "):NORMAL");
                        }
                        RendezvousTransportLayerImpl.this.callback.incomingSocket(socket);
                        return;
                    }
                    case 1: {
                        RendezvousTransportLayerImpl.this.readConnectHeader(socket);
                        return;
                    }
                    case 2: {
                        RendezvousTransportLayerImpl.this.readAcceptHeader(socket);
                        return;
                    }
                    case 3: {
                        new IncomingPilot(socket);
                        return;
                    }
                }
            }

            @Override
            public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
            }
        }.receiveSelectResult(s, true, false);
    }

    protected void readConnectHeader(P2PSocket<Identifier> socket) throws IOException {
        if (this.logger.level <= 300) {
            this.logger.log("readConnectHeader(" + socket + ")");
        }
        final SocketInputBuffer sib = new SocketInputBuffer(socket, 1024);
        P2PSocketReceiver receiver = new P2PSocketReceiver<Identifier>(){

            @Override
            public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                try {
                    RendezvousContact target = (RendezvousContact)RendezvousTransportLayerImpl.this.serializer.deserialize(sib);
                    RendezvousContact opener = (RendezvousContact)RendezvousTransportLayerImpl.this.serializer.deserialize(sib);
                    int uid = sib.readInt();
                    if (RendezvousTransportLayerImpl.this.logger.level <= 300) {
                        RendezvousTransportLayerImpl.this.logger.log("readConnectHeader(" + socket + "," + target + "," + opener + "," + uid + ")");
                    }
                    RendezvousTransportLayerImpl.this.putConnectSocket(opener, target, uid, socket);
                    if (RendezvousTransportLayerImpl.this.incomingPilots.containsKey(target)) {
                        if (RendezvousTransportLayerImpl.this.logger.level <= 400) {
                            RendezvousTransportLayerImpl.this.logger.log("I'm the rendezevous for " + opener + " to " + target + " and I have a pilot.");
                        }
                        IncomingPilot pilot = RendezvousTransportLayerImpl.this.incomingPilots.get(target);
                        pilot.requestSocket(opener, uid);
                    } else {
                        if (RendezvousTransportLayerImpl.this.logger.level <= 800) {
                            RendezvousTransportLayerImpl.this.logger.log("I'm the rendezevous for " + opener + " to " + target + " and I don't have a pilot.");
                        }
                        RendezvousTransportLayerImpl.this.rendezvousStrategy.openChannel(target, RendezvousTransportLayerImpl.this.localNodeHandle, opener, uid, null, socket.getOptions());
                    }
                }
                catch (InsufficientBytesException ibe) {
                    socket.register(true, false, this);
                }
            }

            @Override
            public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
                if (RendezvousTransportLayerImpl.this.logger.level <= 900) {
                    RendezvousTransportLayerImpl.this.logger.logException("error in readConnectHeader(" + socket + ") closing.", ioe);
                }
                socket.close();
            }
        };
        receiver.receiveSelectResult(socket, true, false);
    }

    protected void readAcceptHeader(P2PSocket<Identifier> acceptorSocket) throws IOException {
        if (this.logger.level <= 300) {
            this.logger.log("readAcceptHeader(" + acceptorSocket + ")");
        }
        final SocketInputBuffer sib = new SocketInputBuffer(acceptorSocket, 1024);
        P2PSocketReceiver receiver = new P2PSocketReceiver<Identifier>(){

            @Override
            public void receiveSelectResult(final P2PSocket<Identifier> acceptorSocket, boolean canRead, boolean canWrite) throws IOException {
                try {
                    P2PSocket connectorSocket;
                    final RendezvousContact target = (RendezvousContact)RendezvousTransportLayerImpl.this.serializer.deserialize(sib);
                    final RendezvousContact opener = (RendezvousContact)RendezvousTransportLayerImpl.this.serializer.deserialize(sib);
                    final int uid = sib.readInt();
                    if (opener.equals(RendezvousTransportLayerImpl.this.localNodeHandle)) {
                        final Tuple deliverSocketToMe = RendezvousTransportLayerImpl.this.removeExpectedIncomingSocket(target, uid);
                        if (deliverSocketToMe == null) {
                            if (RendezvousTransportLayerImpl.this.logger.level <= 900) {
                                RendezvousTransportLayerImpl.this.logger.log("Got accept socket to me, that I'm not expecting: t:" + target + " o:" + opener + " uid:" + uid + " " + acceptorSocket);
                            }
                            new ByteWriter(0, new Continuation<P2PSocket<Identifier>, Exception>(){

                                @Override
                                public void receiveException(Exception exception) {
                                }

                                @Override
                                public void receiveResult(P2PSocket<Identifier> result) {
                                    result.close();
                                }
                            }).receiveSelectResult(acceptorSocket, false, true);
                            return;
                        }
                        new ByteWriter(1, new Continuation<P2PSocket<Identifier>, Exception>(){

                            @Override
                            public void receiveException(Exception exception) {
                                ((SocketCallback)deliverSocketToMe.a()).receiveException((SocketRequestHandle)deliverSocketToMe.b(), exception);
                            }

                            @Override
                            public void receiveResult(P2PSocket<Identifier> result) {
                                ((SocketCallback)deliverSocketToMe.a()).receiveResult((SocketRequestHandle)deliverSocketToMe.b(), new SocketWrapperSocket(result.getIdentifier(), result, RendezvousTransportLayerImpl.this.logger, RendezvousTransportLayerImpl.this.errorHandler, OptionsFactory.merge(((SocketRequestHandle)deliverSocketToMe.b()).getOptions(), result.getOptions())));
                            }
                        }).receiveSelectResult(acceptorSocket, false, true);
                        return;
                    }
                    if (RendezvousTransportLayerImpl.this.logger.level <= 300) {
                        RendezvousTransportLayerImpl.this.logger.log("readAcceptHeader(" + acceptorSocket + "," + target + "," + opener + "," + uid + ")");
                    }
                    if ((connectorSocket = RendezvousTransportLayerImpl.this.removeConnectSocket(opener, target, uid)) == null) {
                        if (RendezvousTransportLayerImpl.this.logger.level <= 500) {
                            RendezvousTransportLayerImpl.this.logger.log("writing failed bytes in readAcceptHeader(" + acceptorSocket + "," + target + "," + opener + "," + uid + ")");
                        }
                        ByteWriter acceptorFailed = new ByteWriter(0, new Continuation<P2PSocket<Identifier>, Exception>(){

                            @Override
                            public void receiveResult(P2PSocket<Identifier> result) {
                                result.close();
                            }

                            @Override
                            public void receiveException(Exception exception) {
                                Logger cfr_ignored_0 = RendezvousTransportLayerImpl.this.logger;
                                if (RendezvousTransportLayerImpl.this.logger.level <= 900) {
                                    RendezvousTransportLayerImpl.this.logger.logException("Error writing failed bytes in readAcceptHeader(" + acceptorSocket + "," + target + "," + opener + "," + uid + ")", exception);
                                }
                                acceptorSocket.close();
                            }
                        });
                        acceptorFailed.receiveSelectResult(acceptorSocket, false, true);
                    } else {
                        final MutableTuple forwardSockets = new MutableTuple();
                        if (RendezvousTransportLayerImpl.this.logger.level <= 300) {
                            RendezvousTransportLayerImpl.this.logger.log("writing success bytes in readAcceptHeader(" + acceptorSocket + "," + target + "," + opener + "," + uid + ")");
                        }
                        ByteWriter connectorSuccess = new ByteWriter(1, new Continuation<P2PSocket<Identifier>, Exception>(){

                            @Override
                            public void receiveResult(P2PSocket<Identifier> result) {
                                if (RendezvousTransportLayerImpl.this.logger.level <= 300) {
                                    RendezvousTransportLayerImpl.this.logger.log("Connector socket complete, setting up forwarding. readAcceptHeader(" + acceptorSocket + "," + target + "," + opener + "," + uid + ")");
                                }
                                forwardSockets.setA(result);
                                if (forwardSockets.b() != null) {
                                    RendezvousTransportLayerImpl.this.createForwarder((P2PSocket)forwardSockets.a(), (P2PSocket)forwardSockets.b(), opener, target, uid);
                                }
                            }

                            @Override
                            public void receiveException(Exception exception) {
                                Logger cfr_ignored_0 = RendezvousTransportLayerImpl.this.logger;
                                if (RendezvousTransportLayerImpl.this.logger.level <= 900) {
                                    RendezvousTransportLayerImpl.this.logger.logException("Error writing failed bytes in readAcceptHeader(" + acceptorSocket + "," + target + "," + opener + "," + uid + ")", exception);
                                }
                                acceptorSocket.close();
                            }
                        });
                        connectorSuccess.receiveSelectResult(connectorSocket, false, true);
                        ByteWriter acceptorSuccess = new ByteWriter(1, new Continuation<P2PSocket<Identifier>, Exception>(){

                            @Override
                            public void receiveResult(P2PSocket<Identifier> result) {
                                if (RendezvousTransportLayerImpl.this.logger.level <= 300) {
                                    RendezvousTransportLayerImpl.this.logger.log("Acceptor socket complete, setting up forwarding. readAcceptHeader(" + acceptorSocket + "," + target + "," + opener + "," + uid + ")");
                                }
                                forwardSockets.setB(result);
                                if (forwardSockets.a() != null) {
                                    RendezvousTransportLayerImpl.this.createForwarder((P2PSocket)forwardSockets.a(), (P2PSocket)forwardSockets.b(), opener, target, uid);
                                }
                            }

                            @Override
                            public void receiveException(Exception exception) {
                                Logger cfr_ignored_0 = RendezvousTransportLayerImpl.this.logger;
                                if (RendezvousTransportLayerImpl.this.logger.level <= 900) {
                                    RendezvousTransportLayerImpl.this.logger.logException("Error writing failed bytes in readAcceptHeader(" + acceptorSocket + "," + target + "," + opener + "," + uid + ")", exception);
                                }
                                connectorSocket.close();
                            }
                        });
                        acceptorSuccess.receiveSelectResult(acceptorSocket, false, true);
                    }
                }
                catch (InsufficientBytesException ibe) {
                    acceptorSocket.register(true, false, this);
                }
            }

            @Override
            public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
                if (RendezvousTransportLayerImpl.this.logger.level <= 900) {
                    RendezvousTransportLayerImpl.this.logger.logException("error in readConnectHeader(" + socket + ") closing.", ioe);
                }
                socket.close();
            }
        };
        receiver.receiveSelectResult(acceptorSocket, true, false);
    }

    protected void putExpectedIncomingSocket(HighIdentifier contact, int uid, SocketCallback<Identifier> deliverSocketToMe, SocketRequestHandle<Identifier> requestHandle) {
        Map<Integer, Tuple<SocketCallback<Identifier>, SocketRequestHandle<Identifier>>> one;
        if (this.logger.level <= 300) {
            this.logger.log("putExpectedIncomingSocket(" + contact + "@" + System.identityHashCode(contact) + "," + uid + "," + deliverSocketToMe + "," + requestHandle + ")");
        }
        if ((one = this.expectedIncomingSockets.get(contact)) == null) {
            one = new HashMap<Integer, Tuple<SocketCallback<Identifier>, SocketRequestHandle<Identifier>>>();
            this.expectedIncomingSockets.put(contact, one);
        }
        if (one.containsKey(uid)) {
            throw new IllegalStateException("putExpectedIncomingSockets(" + contact + "," + uid + "," + deliverSocketToMe + ") already contains " + one.get(uid));
        }
        one.put(uid, new Tuple<SocketCallback<Identifier>, SocketRequestHandle<Identifier>>(deliverSocketToMe, requestHandle));
    }

    protected Tuple<SocketCallback<Identifier>, SocketRequestHandle<Identifier>> removeExpectedIncomingSocket(HighIdentifier target, int uid) {
        Map<Integer, Tuple<SocketCallback<Identifier>, SocketRequestHandle<Identifier>>> one;
        if (this.logger.level <= 300) {
            this.logger.log("removeExpectedIncomingSocket(" + target + "@" + System.identityHashCode(target) + "," + uid + ")");
        }
        if ((one = this.expectedIncomingSockets.get(target)) == null) {
            if (this.logger.level <= 400) {
                String s = "";
                for (RendezvousContact h : this.expectedIncomingSockets.keySet()) {
                    s = s + " " + h;
                }
                this.logger.log("removeExpectedIncomingSocket(" + target + "@" + System.identityHashCode(target) + "," + uid + ") had no first level entry for target" + s);
            }
            return null;
        }
        Tuple<SocketCallback<Identifier>, SocketRequestHandle<Identifier>> ret = one.get(uid);
        if (ret == null) {
            if (this.logger.level <= 400) {
                String s = "";
                for (Integer h : one.keySet()) {
                    s = s + " " + h;
                }
                this.logger.log("removeExpectedIncomingSocket(" + target + "@" + System.identityHashCode(target) + "," + uid + ") had no uid for target" + s);
            }
        } else {
            one.remove(uid);
        }
        if (one.isEmpty()) {
            this.expectedIncomingSockets.remove(target);
        }
        return ret;
    }

    protected void createForwarder(P2PSocket<Identifier> a, P2PSocket<Identifier> b, HighIdentifier connector, HighIdentifier acceptor, int uid) {
        if (this.logger.level <= 500) {
            this.logger.log("createForwarder(" + a + "," + b + "," + connector + "," + acceptor + "," + uid + ")");
        }
        new Forwarder<Identifier>(null, a, b, this.logger);
    }

    public void putConnectSocket(HighIdentifier requestor, HighIdentifier target, int uid, P2PSocket<Identifier> socket) {
        P2PSocket<Identifier> three;
        Map<Integer, P2PSocket<Identifier>> two;
        Map<HighIdentifier, Map<Integer, P2PSocket<Identifier>>> one = this.connectSockets.get(requestor);
        if (one == null) {
            one = new HashMap<HighIdentifier, Map<Integer, P2PSocket<Identifier>>>();
            this.connectSockets.put(requestor, one);
        }
        if ((two = one.get(target)) == null) {
            two = new HashMap<Integer, P2PSocket<Identifier>>();
            one.put(target, two);
        }
        if ((three = two.get(uid)) != null) {
            if (this.logger.level <= 900) {
                this.logger.log("error in storeConnectSocket() there is already a connector with the same UID!!!, dropping the new one.  Old:" + three + " new:" + socket);
            }
            socket.close();
            return;
        }
        two.put(uid, socket);
    }

    public P2PSocket<Identifier> removeConnectSocket(HighIdentifier requestor, HighIdentifier target, int uid) {
        Map<HighIdentifier, Map<Integer, P2PSocket<Identifier>>> one = this.connectSockets.get(requestor);
        if (one == null) {
            return null;
        }
        Map<Integer, P2PSocket<Identifier>> two = one.get(target);
        if (two == null) {
            return null;
        }
        P2PSocket<Identifier> three = two.remove(uid);
        if (two.isEmpty()) {
            one.remove(target);
        }
        if (one.isEmpty()) {
            this.connectSockets.remove(requestor);
        }
        return three;
    }

    @Override
    public void openChannel(HighIdentifier requestor, HighIdentifier middleMan, int uid) {
        if (this.logger.level <= 800) {
            this.logger.log("openChannel(" + requestor + "," + middleMan + "," + uid + ")");
        }
        this.openAcceptSocket(requestor, middleMan, uid);
    }

    protected void openAcceptSocket(HighIdentifier requestor, HighIdentifier middleMan, int uid) {
        if (this.logger.level <= 400) {
            this.logger.log("openAcceptSocket(" + requestor + "," + middleMan + "," + uid + ")");
        }
        if (!middleMan.canContactDirect()) {
            throw new IllegalArgumentException("openAcceptSocket(" + requestor + "," + middleMan + "," + uid + ") middleMan is firewalled.");
        }
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        try {
            sob.writeByte((byte)2);
            this.serializer.serialize(this.localNodeHandle, sob);
            this.serializer.serialize(requestor, sob);
            sob.writeInt(uid);
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.logException("Error serializing in openAcceptSocket(" + requestor + "," + middleMan + "," + uid + ")", ioe);
            }
            return;
        }
        final ByteBuffer writeBuffer = sob.getByteBuffer();
        ByteBuffer readBuffer = ByteBuffer.allocate(1);
        this.tl.openSocket(this.serializer.convert(middleMan), new SocketCallback<Identifier>((RendezvousContact)requestor, (RendezvousContact)middleMan, uid, readBuffer){
            final /* synthetic */ RendezvousContact val$requestor;
            final /* synthetic */ RendezvousContact val$middleMan;
            final /* synthetic */ int val$uid;
            final /* synthetic */ ByteBuffer val$readBuffer;
            {
                this.val$requestor = rendezvousContact;
                this.val$middleMan = rendezvousContact2;
                this.val$uid = n;
                this.val$readBuffer = byteBuffer2;
            }

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                block2: {
                    try {
                        new P2PSocketReceiver<Identifier>(){

                            @Override
                            public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                                if (writeBuffer.hasRemaining()) {
                                    long bytesWritten = socket.write(writeBuffer);
                                    if (bytesWritten < 0L) {
                                        if (RendezvousTransportLayerImpl.this.logger.level <= 900) {
                                            RendezvousTransportLayerImpl.this.logger.log("Channel closed in openAcceptSocket(" + val$requestor + "," + val$middleMan + "," + val$uid + ")");
                                        }
                                        return;
                                    }
                                    if (writeBuffer.hasRemaining()) {
                                        socket.register(false, true, this);
                                        return;
                                    }
                                }
                                if (!writeBuffer.hasRemaining()) {
                                    if (val$readBuffer.hasRemaining()) {
                                        long bytesRead = socket.read(val$readBuffer);
                                        if (bytesRead < 0L) {
                                            if (RendezvousTransportLayerImpl.this.logger.level <= 900) {
                                                RendezvousTransportLayerImpl.this.logger.log("Channel closed in openAcceptSocket(" + val$requestor + "," + val$middleMan + "," + val$uid + ")");
                                            }
                                            return;
                                        }
                                        if (val$readBuffer.hasRemaining()) {
                                            socket.register(true, false, this);
                                            return;
                                        }
                                    }
                                    val$readBuffer.flip();
                                    byte response = val$readBuffer.get();
                                    switch (response) {
                                        case 1: {
                                            if (RendezvousTransportLayerImpl.this.logger.level <= 400) {
                                                RendezvousTransportLayerImpl.this.logger.log("success in openAcceptSocket(" + val$requestor + "," + val$middleMan + "," + val$uid + ")");
                                            }
                                            RendezvousTransportLayerImpl.this.callback.incomingSocket(socket);
                                            return;
                                        }
                                    }
                                    if (RendezvousTransportLayerImpl.this.logger.level <= 900) {
                                        RendezvousTransportLayerImpl.this.logger.log("Failed to connect in openAcceptSocket(" + val$requestor + "," + val$middleMan + "," + val$uid + ")");
                                    }
                                    return;
                                }
                            }

                            @Override
                            public void receiveException(P2PSocket<Identifier> s, Exception ex) {
                                if (RendezvousTransportLayerImpl.this.logger.level <= 900) {
                                    RendezvousTransportLayerImpl.this.logger.logException("Failure opening socket in openAcceptSocket(" + val$requestor + "," + val$middleMan + "," + val$uid + ")", ex);
                                }
                            }
                        }.receiveSelectResult(sock, false, true);
                    }
                    catch (IOException ioe) {
                        if (RendezvousTransportLayerImpl.this.logger.level > 900) break block2;
                        RendezvousTransportLayerImpl.this.logger.logException("Exception in openAcceptSocket(" + this.val$requestor + "," + this.val$middleMan + "," + this.val$uid + ")", ioe);
                    }
                }
            }

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                if (ex instanceof BindException) {
                    RendezvousTransportLayerImpl.this.openAcceptSocket(this.val$requestor, this.val$middleMan, this.val$uid);
                    return;
                }
                if (RendezvousTransportLayerImpl.this.logger.level <= 900) {
                    RendezvousTransportLayerImpl.this.logger.logException("Failure opening socket in openAcceptSocket(" + this.val$requestor + "," + this.val$middleMan + "," + this.val$uid + ")", ex);
                }
            }
        }, OptionsFactory.addOption(null, this.RENDEZVOUS_CONTACT_STRING, requestor));
    }

    @Override
    public void messageReceivedFromOverlay(HighIdentifier i, ByteBuffer m, Map<String, Object> options) throws IOException {
        if (this.logger.level <= 400) {
            this.logger.log("messageReceivedFromOverlay(" + i + "," + m + "," + options + ")");
        }
        this.messageReceived(this.serializer.convert(i), m, OptionsFactory.addOption(options, FROM_OVERLAY, true));
    }

    @Override
    public void messageReceived(Identifier i, ByteBuffer m, Map<String, Object> options) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("messageReceived(" + i + "," + m + "," + options + ")");
        }
        if (!options.containsKey(FROM_OVERLAY) || !((Boolean)options.get(FROM_OVERLAY)).booleanValue()) {
            this.responseStrategy.messageReceived(i, m, options);
            options = OptionsFactory.addOption(options, TAG_KEY, this.ephemeralDB.getTagForEphemeral(i));
        }
        this.callback.messageReceived(i, m, options);
    }

    protected HighIdentifier getHighIdentifier(Map<String, Object> options) {
        if (options == null) {
            return null;
        }
        return (HighIdentifier)((RendezvousContact)options.get(this.RENDEZVOUS_CONTACT_STRING));
    }

    protected long getTag(Map<String, Object> options) {
        if (options == null) {
            return Long.MIN_VALUE;
        }
        Object ret = options.get(TAG_KEY);
        if (ret == null) {
            return Long.MIN_VALUE;
        }
        return (Long)ret;
    }

    @Override
    public MessageRequestHandle<Identifier, ByteBuffer> sendMessage(Identifier i, ByteBuffer m, final MessageCallback<Identifier, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        Identifier ephemeral;
        HighIdentifier high;
        if (this.logger.level <= 300) {
            this.logger.log("sendMessage(" + i + "," + m + "," + deliverAckToMe + "," + options + ")");
        }
        if ((high = this.getHighIdentifier(options)) == null) {
            long tag = this.getTag(options);
            if (tag != Long.MIN_VALUE) {
                i = this.ephemeralDB.getEphemeral(tag, i);
            }
            this.responseStrategy.messageSent(i, m, options);
            return this.tl.sendMessage(i, m, deliverAckToMe, options);
        }
        if (high.canContactDirect() || this.contactDirectStrategy.canContactDirect(high)) {
            this.responseStrategy.messageSent(i, m, options);
            return this.tl.sendMessage(i, m, deliverAckToMe, options);
        }
        long tag = this.getTag(options);
        if (tag != Long.MIN_VALUE) {
            this.ephemeralDB.mapHighToTag(high, tag);
        }
        if ((ephemeral = this.ephemeralDB.getEphemeral(high)) != null && this.responseStrategy.sendDirect(ephemeral, m, options)) {
            if (this.logger.level <= 500) {
                this.logger.log("Sending directly on ephemeral " + ephemeral + " for " + high);
            }
            this.responseStrategy.messageSent(ephemeral, m, options);
            return this.tl.sendMessage(ephemeral, m, deliverAckToMe, options);
        }
        if (this.logger.level <= 500) {
            this.logger.log("Not sending directly on ephemeral " + ephemeral + " for " + high);
        }
        final MessageRequestHandleImpl<Identifier, ByteBuffer> ret = new MessageRequestHandleImpl<Identifier, ByteBuffer>(i, m, options);
        MessageCallback ack = deliverAckToMe == null ? null : new MessageCallback<HighIdentifier, ByteBuffer>(){

            @Override
            public void ack(MessageRequestHandle<HighIdentifier, ByteBuffer> msg) {
                deliverAckToMe.ack(ret);
            }

            @Override
            public void sendFailed(MessageRequestHandle<HighIdentifier, ByteBuffer> msg, Exception reason) {
                deliverAckToMe.sendFailed(ret, reason);
            }
        };
        if (this.incomingPilots.containsKey(high)) {
            options = OptionsFactory.addOption(options, OPTION_USE_PILOT, high);
        }
        ret.setSubCancellable(this.rendezvousStrategy.sendMessage(high, m, ack, options));
        return ret;
    }

    public String toString() {
        return "RendezvousTL{" + this.localNodeHandle + "}";
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.errorHandler = handler;
    }

    @Override
    public void destroy() {
        this.tl.destroy();
    }

    protected void notifyOutgoingPilotAdded(HighIdentifier i) {
        ArrayList<OutgoingPilotListener<HighIdentifier>> temp = new ArrayList<OutgoingPilotListener<HighIdentifier>>(this.opListeners);
        for (OutgoingPilotListener<HighIdentifier> l : temp) {
            l.pilotOpening(i);
        }
    }

    protected void notifyOutgoingPilotRemoved(HighIdentifier i) {
        ArrayList<OutgoingPilotListener<HighIdentifier>> temp = new ArrayList<OutgoingPilotListener<HighIdentifier>>(this.opListeners);
        for (OutgoingPilotListener<HighIdentifier> l : temp) {
            l.pilotClosed(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOutgoingPilotListener(OutgoingPilotListener<HighIdentifier> listener) {
        ArrayList<OutgoingPilotListener<HighIdentifier>> arrayList = this.opListeners;
        synchronized (arrayList) {
            this.opListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOutgoingPilotListener(OutgoingPilotListener<HighIdentifier> listener) {
        ArrayList<OutgoingPilotListener<HighIdentifier>> arrayList = this.opListeners;
        synchronized (arrayList) {
            this.opListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketRequestHandle<HighIdentifier> openPilot(HighIdentifier i, final Continuation<SocketRequestHandle<HighIdentifier>, Exception> deliverAckToMe) {
        OutgoingPilot o2;
        Map<String, Object> options;
        if (this.logger.level <= 500) {
            this.logger.log("openPilot(" + i + ")");
        }
        if (!i.canContactDirect()) {
            throw new IllegalArgumentException("can't open pilot to natted node:" + i);
        }
        Map<HighIdentifier, OutgoingPilot> map = this.outgoingPilots;
        synchronized (map) {
            if (this.outgoingPilots.containsKey(i)) {
                if (this.logger.level <= 400) {
                    this.logger.log("openPilot(" + i + ") already had one.");
                }
                if (deliverAckToMe != null) {
                    deliverAckToMe.receiveResult(this.outgoingPilots.get(i));
                }
                return this.outgoingPilots.get(i);
            }
            options = this.serializer.getOptions(i);
            o2 = new OutgoingPilot(this, i, options);
            this.outgoingPilots.put(i, o2);
        }
        o2.init();
        this.notifyOutgoingPilotAdded(i);
        final OutgoingPilot o = o2;
        o.setCancellable(this.tl.openSocket(this.serializer.convert(i), new SocketCallback<Identifier>(){

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                o.setSocket(sock);
                if (deliverAckToMe != null) {
                    deliverAckToMe.receiveResult(o);
                }
            }

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                o.receiveException(ex);
                if (deliverAckToMe != null) {
                    deliverAckToMe.receiveException(ex);
                }
            }
        }, options));
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePilot(HighIdentifier i) {
        OutgoingPilot closeMe;
        if (this.logger.level <= 500) {
            this.logger.log("closePilot(" + i + ")");
        }
        Map<HighIdentifier, OutgoingPilot> map = this.outgoingPilots;
        synchronized (map) {
            closeMe = this.outgoingPilots.remove(i);
        }
        if (closeMe != null) {
            closeMe.cancel();
        }
    }

    protected void notifyIncomingPilotAdded(HighIdentifier i) {
        ArrayList<IncomingPilotListener<HighIdentifier>> temp = new ArrayList<IncomingPilotListener<HighIdentifier>>(this.ipListeners);
        for (IncomingPilotListener<HighIdentifier> l : temp) {
            l.pilotOpening(i);
        }
    }

    protected void notifyIncomingPilotRemoved(HighIdentifier i) {
        ArrayList<IncomingPilotListener<HighIdentifier>> temp = new ArrayList<IncomingPilotListener<HighIdentifier>>(this.ipListeners);
        for (IncomingPilotListener<HighIdentifier> l : temp) {
            l.pilotClosed(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIncomingPilotListener(IncomingPilotListener<HighIdentifier> listener) {
        ArrayList<IncomingPilotListener<HighIdentifier>> arrayList = this.ipListeners;
        synchronized (arrayList) {
            this.ipListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIncomingPilotListener(IncomingPilotListener<HighIdentifier> listener) {
        ArrayList<IncomingPilotListener<HighIdentifier>> arrayList = this.ipListeners;
        synchronized (arrayList) {
            this.ipListeners.remove(listener);
        }
    }

    private static byte[] makeByteArray(byte writeMe) {
        byte[] foo = new byte[]{writeMe};
        return foo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ByteWriter
    implements P2PSocketReceiver<Identifier> {
        ByteBuffer bytesToWrite;
        Continuation<P2PSocket<Identifier>, Exception> callMeWhenDone;

        public ByteWriter(byte writeMe, Continuation<P2PSocket<Identifier>, Exception> callMeWhenDone) {
            this(RendezvousTransportLayerImpl.makeByteArray(writeMe), callMeWhenDone);
        }

        public ByteWriter(byte[] writeMe, Continuation<P2PSocket<Identifier>, Exception> callMeWhenDone) {
            this.bytesToWrite = ByteBuffer.wrap(writeMe);
            this.callMeWhenDone = callMeWhenDone;
        }

        @Override
        public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
            long bytesWritten = socket.write(this.bytesToWrite);
            if (bytesWritten < 0L) {
                socket.close();
                this.callMeWhenDone.receiveException(new ClosedChannelException("Socket " + socket + " closed."));
                return;
            }
            if (this.bytesToWrite.hasRemaining()) {
                socket.register(false, true, this);
                return;
            }
            this.callMeWhenDone.receiveResult(socket);
        }

        @Override
        public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
            socket.close();
            this.callMeWhenDone.receiveException(ioe);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IncomingPilot
    extends AbstractPilot {
        public IncomingPilot(P2PSocket<Identifier> socket) throws IOException {
            this.socket = socket;
            this.sib = new SocketInputBuffer(socket, 1024);
            this.receiveSelectResult(socket, true, true);
        }

        protected void requestSocket(HighIdentifier requestor, int uid) throws IOException {
            if (RendezvousTransportLayerImpl.this.logger.level <= 300) {
                RendezvousTransportLayerImpl.this.logger.log("Requesting socket from: " + this.i + "requestor:" + requestor + " uid:" + uid);
            }
            SimpleOutputBuffer sob = new SimpleOutputBuffer();
            sob.writeByte((byte)3);
            RendezvousTransportLayerImpl.this.serializer.serialize(requestor, sob);
            sob.writeInt(uid);
            this.enqueue(sob.getByteBuffer());
        }

        @Override
        protected void read() throws IOException {
            if (this.i == null) {
                try {
                    this.i = (RendezvousContact)RendezvousTransportLayerImpl.this.serializer.deserialize(this.sib);
                    if (RendezvousTransportLayerImpl.this.logger.level <= 400) {
                        RendezvousTransportLayerImpl.this.logger.log("Received incoming Pilot from " + this.i);
                    }
                }
                catch (InsufficientBytesException ibe) {
                    this.socket.register(true, false, this);
                    return;
                }
                this.sib.clear();
                RendezvousTransportLayerImpl.this.incomingPilots.put(this.i, this);
                RendezvousTransportLayerImpl.this.notifyIncomingPilotAdded(this.i);
            }
            try {
                byte msgType = this.sib.readByte();
                switch (msgType) {
                    case 1: {
                        if (RendezvousTransportLayerImpl.this.logger.level <= 400) {
                            RendezvousTransportLayerImpl.this.logger.log(this + " received ping");
                        }
                        this.sib.clear();
                        this.enqueue(ByteBuffer.wrap(PILOT_PONG_BYTES));
                        this.read();
                    }
                }
            }
            catch (InsufficientBytesException ibe) {
                this.socket.register(true, false, this);
                return;
            }
            catch (IOException ioe) {
                this.cancel();
            }
        }

        @Override
        public boolean cancel() {
            return super.cancel();
        }

        @Override
        public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
            if (this.i != null) {
                IncomingPilot pilot;
                if (RendezvousTransportLayerImpl.this.logger.level <= 400) {
                    RendezvousTransportLayerImpl.this.logger.log("Shutdown of incoming pilot " + socket);
                }
                if ((pilot = RendezvousTransportLayerImpl.this.incomingPilots.remove(this.i)) != null) {
                    RendezvousTransportLayerImpl.this.notifyIncomingPilotRemoved(this.i);
                }
            }
            socket.close();
        }

        @Override
        public void run() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OutgoingPilot
    extends AbstractPilot
    implements SocketRequestHandle<HighIdentifier> {
        protected SocketRequestHandle<Identifier> cancellable;
        protected Map<String, Object> options;
        final /* synthetic */ RendezvousTransportLayerImpl this$0;

        public OutgoingPilot(HighIdentifier i, Map<String, Object> options) {
            this.this$0 = var1_1;
            this.i = i;
            this.options = options;
        }

        public void init() {
            this.this$0.selectorManager.schedule(this, 5000L, 5000L);
        }

        public void receiveException(Exception ex) {
            this.cancel();
        }

        public void setCancellable(SocketRequestHandle<Identifier> cancellable) {
            this.cancellable = cancellable;
        }

        public void setSocket(P2PSocket<Identifier> socket) {
            if (this.cancelled) {
                socket.close();
                return;
            }
            this.cancellable = null;
            this.socket = socket;
            if (this.this$0.logger.level <= 500) {
                this.this$0.logger.log(this + " success opening outgoing pilot");
            }
            try {
                this.enqueue(ByteBuffer.wrap(PILOT_SOCKET_BYTES));
                this.enqueue(this.this$0.serializer.serialize(this.this$0.localNodeHandle));
                this.sib = new SocketInputBuffer(socket, 1024);
                this.receiveSelectResult(socket, true, true);
            }
            catch (IOException ioe) {
                this.cancel();
            }
        }

        @Override
        public String toString() {
            return "OutgoingPilot{" + this.i + "}(" + this.socket + ")";
        }

        public boolean ping() {
            if (this.this$0.logger.level <= 300) {
                this.this$0.logger.log(this + ".ping " + this.socket);
            }
            if (this.socket == null) {
                return false;
            }
            this.enqueue(ByteBuffer.wrap(PILOT_PING_BYTES));
            return true;
        }

        @Override
        public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
            this.cancel();
        }

        @Override
        protected void read() throws IOException {
            try {
                byte msgType = this.sib.readByte();
                switch (msgType) {
                    case 2: {
                        if (this.this$0.logger.level <= 300) {
                            this.this$0.logger.log(this + " received pong");
                        }
                        this.sib.clear();
                        this.read();
                        break;
                    }
                    case 3: {
                        RendezvousContact requestor = (RendezvousContact)this.this$0.serializer.deserialize(this.sib);
                        int uid = this.sib.readInt();
                        if (this.this$0.logger.level <= 400) {
                            this.this$0.logger.log("Received socket request: requestor:" + requestor + " middleman:" + this.i + " uid:" + uid);
                        }
                        this.this$0.openAcceptSocket(requestor, this.i, uid);
                        this.sib.clear();
                        this.read();
                    }
                }
            }
            catch (InsufficientBytesException ibe) {
                this.socket.register(true, false, this);
                return;
            }
            catch (IOException ioe) {
                this.cancel();
            }
        }

        @Override
        public HighIdentifier getIdentifier() {
            return this.i;
        }

        @Override
        public Map<String, Object> getOptions() {
            return this.options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            super.cancel();
            if (this.socket == null) {
                if (this.cancellable != null) {
                    this.cancellable.cancel();
                    this.cancellable = null;
                }
            } else {
                this.socket.close();
            }
            OutgoingPilot pilot = null;
            Map map = this.this$0.outgoingPilots;
            synchronized (map) {
                pilot = this.this$0.outgoingPilots.remove(this.i);
            }
            if (pilot != null) {
                this.this$0.notifyOutgoingPilotRemoved(this.i);
            }
            return true;
        }

        @Override
        public void run() {
            this.ping();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractPilot
    extends TimerTask
    implements P2PSocketReceiver<Identifier> {
        protected P2PSocket<Identifier> socket;
        protected SocketInputBuffer sib;
        protected HighIdentifier i;
        private LinkedList<ByteBuffer> queue = new LinkedList();

        AbstractPilot() {
        }

        protected void enqueue(ByteBuffer bb) {
            if (RendezvousTransportLayerImpl.this.logger.level <= 300) {
                RendezvousTransportLayerImpl.this.logger.log(this + ".enqueue(" + bb + ")");
            }
            this.queue.add(bb);
            this.socket.register(false, true, this);
        }

        protected void write() throws IOException {
            if (this.queue.isEmpty()) {
                return;
            }
            long ret = this.socket.write(this.queue.getFirst());
            if (RendezvousTransportLayerImpl.this.logger.level <= 300) {
                RendezvousTransportLayerImpl.this.logger.log(this + " wrote " + ret + " bytes of " + this.queue.getFirst());
            }
            if (ret < 0L) {
                this.cancel();
            }
            if (this.queue.getFirst().hasRemaining()) {
                this.socket.register(false, true, this);
                return;
            }
            this.queue.removeFirst();
            this.write();
        }

        @Override
        public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
            if (canWrite) {
                this.write();
            }
            if (canRead) {
                this.read();
            }
        }

        public String toString() {
            return "" + this.i;
        }

        abstract void read() throws IOException;
    }
}

