/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.history.reader;

import java.io.IOException;
import org.mpisws.p2p.transport.peerreview.history.IndexEntry;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.history.SecureHistoryFactory;
import org.mpisws.p2p.transport.peerreview.history.reader.EntryDeserializer;

public class LogReader {
    EntryDeserializer deserializer;
    SecureHistory history;
    long entryIndex;

    public LogReader(String name, SecureHistoryFactory factory, EntryDeserializer deserializer) throws IOException {
        this.deserializer = deserializer;
        this.history = factory.open(name, "r");
        this.entryIndex = 0L;
    }

    public String readEntry() throws IOException {
        if (this.entryIndex >= this.history.getNumEntries()) {
            return null;
        }
        IndexEntry ie = this.history.statEntry(this.entryIndex);
        String ret = this.deserializer.read(ie, this.history);
        ++this.entryIndex;
        return ret;
    }
}

