/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.history.logentry;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mpisws.p2p.transport.peerreview.PeerReviewConstants;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import org.mpisws.p2p.transport.peerreview.history.logentry.HistoryEvent;
import org.mpisws.p2p.transport.util.Serializer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvtSend<Identifier extends RawSerializable>
extends HistoryEvent
implements PeerReviewConstants {
    public Identifier receiverId;
    public ByteBuffer payload;
    public byte[] hash;

    public EvtSend(Identifier receiverId, ByteBuffer payload, int relevantPayload, HashProvider hasher) {
        this.receiverId = receiverId;
        this.payload = ByteBuffer.wrap(payload.array(), payload.position(), relevantPayload);
        this.hash = hasher.hash(this.payload);
    }

    public EvtSend(Identifier receiverId, ByteBuffer payload) {
        this.receiverId = receiverId;
        this.payload = ByteBuffer.wrap(payload.array(), payload.position(), payload.remaining());
    }

    public EvtSend(InputBuffer buf, Serializer<Identifier> idSerializer, int hashSize) throws IOException {
        this.receiverId = (RawSerializable)idSerializer.deserialize(buf);
        boolean hasHash = buf.readBoolean();
        byte[] payload_bytes = hasHash ? new byte[buf.bytesRemaining() - hashSize] : new byte[hashSize];
        buf.read(payload_bytes);
        this.payload = ByteBuffer.wrap(payload_bytes);
        if (hasHash) {
            this.hash = new byte[hashSize];
            buf.read(this.hash);
        }
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        this.receiverId.serialize(buf);
        buf.writeBoolean(this.hash != null);
        buf.write(this.payload.array(), this.payload.position(), this.payload.remaining());
        if (this.hash != null) {
            buf.write(this.hash, 0, this.hash.length);
        }
    }

    @Override
    public short getType() {
        return 0;
    }
}

