/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.history.logentry;

import java.io.IOException;
import org.mpisws.p2p.transport.peerreview.history.logentry.HistoryEvent;
import org.mpisws.p2p.transport.util.Serializer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvtAck<Identifier extends RawSerializable>
extends HistoryEvent {
    Identifier remoteId;
    long ackedSeq;
    long hisSeq;
    byte[] hTopMinusOne;
    byte[] signature;

    public EvtAck(Identifier remoteId, long ackedSeq, long hisSeq, byte[] topMinusOne, byte[] signature) {
        this.remoteId = remoteId;
        this.ackedSeq = ackedSeq;
        this.hisSeq = hisSeq;
        this.hTopMinusOne = topMinusOne;
        this.signature = signature;
    }

    public EvtAck(InputBuffer buf, Serializer<Identifier> idSerializer, int hashSize, int signatureSize) throws IOException {
        this.remoteId = (RawSerializable)idSerializer.deserialize(buf);
        this.ackedSeq = buf.readLong();
        this.hisSeq = buf.readLong();
        this.hTopMinusOne = new byte[hashSize];
        buf.read(this.hTopMinusOne);
        this.signature = new byte[signatureSize];
        buf.read(this.signature);
    }

    @Override
    public short getType() {
        return 6;
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        this.remoteId.serialize(buf);
        buf.writeLong(this.ackedSeq);
        buf.writeLong(this.hisSeq);
        buf.write(this.hTopMinusOne, 0, this.hTopMinusOne.length);
        buf.write(this.signature, 0, this.signature.length);
    }

    public Identifier getRemoteId() {
        return this.remoteId;
    }

    public long getAckedSeq() {
        return this.ackedSeq;
    }

    public long getHisSeq() {
        return this.hisSeq;
    }

    public byte[] getHTopMinusOne() {
        return this.hTopMinusOne;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

