/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.history.hasher;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

public class SHA1HashProvider
implements HashProvider {
    private MessageDigest md = MessageDigest.getInstance("SHA");

    public byte[] getEmptyHash() {
        return new byte[this.getHashSizeBytes()];
    }

    public short getHashSizeBytes() {
        return 20;
    }

    public synchronized byte[] hash(long seq, short type, byte[] nodeHash, byte[] contentHash) {
        try {
            SimpleOutputBuffer sob = new SimpleOutputBuffer();
            sob.writeLong(seq);
            sob.writeShort(type);
            sob.write(nodeHash);
            sob.write(contentHash);
            return this.hash(sob.getByteBuffer());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public synchronized byte[] hash(ByteBuffer ... hashMe) {
        for (ByteBuffer bb : hashMe) {
            int pos = bb.position();
            this.md.update(bb);
            bb.position(pos);
        }
        byte[] ret = this.md.digest();
        return ret;
    }
}

