/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.audit;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.mpisws.p2p.transport.peerreview.audit.SnippetEntry;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogSnippet {
    byte[] baseHash;
    public List<SnippetEntry> entries;

    public LogSnippet(byte[] baseHash, List<SnippetEntry> entries) {
        this.baseHash = baseHash;
        this.entries = entries;
    }

    public String toString() {
        return "LogSnippet[" + this.entries.get((int)0).seq + "-" + this.entries.get((int)(this.entries.size() - 1)).seq + "]";
    }

    public boolean equals(Object o) {
        LogSnippet that = (LogSnippet)o;
        if (!Arrays.equals(this.baseHash, that.baseHash)) {
            return false;
        }
        if (this.entries.size() != that.entries.size()) {
            return false;
        }
        Iterator<SnippetEntry> i1 = this.entries.iterator();
        Iterator<SnippetEntry> i2 = that.entries.iterator();
        while (i1.hasNext()) {
            if (i1.next().equals(i2.next())) continue;
            return false;
        }
        return true;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeLong(this.entries.get((int)0).seq);
        buf.writeByte((byte)0);
        buf.write(this.baseHash, 0, this.baseHash.length);
        Iterator<SnippetEntry> i = this.entries.iterator();
        SnippetEntry prev = i.next();
        prev.serialize(buf, null);
        while (i.hasNext()) {
            SnippetEntry cur = i.next();
            cur.serialize(buf, prev);
            prev = cur;
        }
    }

    public LogSnippet(InputBuffer buf, int hashSize) throws IOException {
        long firstSeq = buf.readLong();
        if (buf.readByte() != 0) {
            throw new IOException("Unexpected extInfo");
        }
        this.baseHash = new byte[hashSize];
        buf.read(this.baseHash);
        this.entries = new ArrayList<SnippetEntry>();
        SnippetEntry prev = new SnippetEntry(buf, firstSeq, hashSize);
        this.entries.add(prev);
        while (buf.bytesRemaining() == -2 || buf.bytesRemaining() > 0) {
            prev = new SnippetEntry(buf, hashSize, prev);
            this.entries.add(prev);
        }
    }

    public byte[] getBaseHash() {
        return this.baseHash;
    }

    public long getFirstSeq() {
        return this.entries.get((int)0).seq;
    }

    public Object getExtInfo() {
        return null;
    }

    public boolean checkHashChainContains(byte[] keyNodeHash, long keyNodeSeq, HashProvider transport, Logger logger) {
        assert (keyNodeHash != null && keyNodeSeq >= 0L);
        byte[] currentNodeHash = this.baseHash;
        if (logger.level <= 500) {
            logger.log("Checking whether hash chain in snippet contains node #" + keyNodeSeq);
        }
        for (SnippetEntry entry : this.entries) {
            if (entry.seq > keyNodeSeq) break;
            if (logger.level <= 400) {
                logger.log("Entry " + entry);
            }
            byte[] contentHash = entry.isHash ? entry.content : transport.hash(ByteBuffer.wrap(entry.content));
            currentNodeHash = transport.hash(entry.seq, entry.type, currentNodeHash, contentHash);
            if (entry.seq != keyNodeSeq) continue;
            if (Arrays.equals(currentNodeHash, keyNodeHash)) {
                if (logger.level <= 400) {
                    logger.log("Yes, the node was found and has the specified hash");
                }
                return true;
            }
            if (logger.level <= 400) {
                logger.log("No, the node was found but has a different hash");
            }
            return false;
        }
        if (logger.level <= 400) {
            logger.log("No, a node with this sequence number was not found");
        }
        return false;
    }
}

