/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.audit;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mpisws.p2p.transport.peerreview.Basics;
import org.mpisws.p2p.transport.peerreview.PeerReview;
import org.mpisws.p2p.transport.peerreview.PeerReviewCallback;
import org.mpisws.p2p.transport.peerreview.audit.ActiveAuditInfo;
import org.mpisws.p2p.transport.peerreview.audit.ActiveInvestigationInfo;
import org.mpisws.p2p.transport.peerreview.audit.AuditProtocol;
import org.mpisws.p2p.transport.peerreview.audit.LogSnippet;
import org.mpisws.p2p.transport.peerreview.audit.SnippetEntry;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorStore;
import org.mpisws.p2p.transport.peerreview.evidence.AuditResponse;
import org.mpisws.p2p.transport.peerreview.evidence.ChallengeAudit;
import org.mpisws.p2p.transport.peerreview.evidence.EvidenceTransferProtocol;
import org.mpisws.p2p.transport.peerreview.evidence.ProofInconsistent;
import org.mpisws.p2p.transport.peerreview.evidence.ProofNonconformant;
import org.mpisws.p2p.transport.peerreview.history.IndexEntry;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.identity.IdentityTransport;
import org.mpisws.p2p.transport.peerreview.infostore.Evidence;
import org.mpisws.p2p.transport.peerreview.infostore.PeerInfoStore;
import org.mpisws.p2p.transport.peerreview.message.AuthRequest;
import org.mpisws.p2p.transport.peerreview.message.AuthResponse;
import org.mpisws.p2p.transport.peerreview.message.ChallengeMessage;
import org.mpisws.p2p.transport.peerreview.message.PeerReviewMessage;
import org.mpisws.p2p.transport.peerreview.replay.Verifier;
import org.mpisws.p2p.transport.peerreview.replay.playback.ReplaySM;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.RawSerializable;
import rice.p2p.util.MathUtils;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditProtocolImpl<Handle extends RawSerializable, Identifier extends RawSerializable>
implements AuditProtocol<Handle, Identifier> {
    PeerReview<Handle, Identifier> peerreview;
    SecureHistory history;
    PeerInfoStore<Handle, Identifier> infoStore;
    AuthenticatorStore<Identifier> authInStore;
    IdentityTransport<Handle, Identifier> transport;
    AuthenticatorStore<Identifier> authOutStore;
    EvidenceTransferProtocol<Handle, Identifier> evidenceTransferProtocol;
    AuthenticatorStore<Identifier> authCacheStore;
    Map<Identifier, ActiveInvestigationInfo<Handle>> activeInvestigation = new HashMap<Identifier, ActiveInvestigationInfo<Handle>>();
    Map<Identifier, ActiveAuditInfo<Handle, Identifier>> activeAudit = new HashMap<Identifier, ActiveAuditInfo<Handle, Identifier>>();
    int logDownloadTimeout;
    boolean replayEnabled;
    long lastAuditStarted;
    long auditIntervalMillis;
    protected TimerTask auditTimer;
    protected TimerTask progressTimer;
    Logger logger;

    public AuditProtocolImpl(PeerReview<Handle, Identifier> peerreview, SecureHistory history, PeerInfoStore<Handle, Identifier> infoStore, AuthenticatorStore<Identifier> authInStore, IdentityTransport<Handle, Identifier> transport, AuthenticatorStore<Identifier> authOutStore, EvidenceTransferProtocol<Handle, Identifier> evidenceTransferProtocol, AuthenticatorStore<Identifier> authCacheStore) {
        this.logger = peerreview.getEnvironment().getLogManager().getLogger(AuditProtocolImpl.class, null);
        this.peerreview = peerreview;
        this.history = history;
        this.infoStore = infoStore;
        this.authInStore = authInStore;
        this.transport = transport;
        this.authOutStore = authOutStore;
        this.evidenceTransferProtocol = evidenceTransferProtocol;
        this.authCacheStore = authCacheStore;
        this.progressTimer = null;
        this.logDownloadTimeout = 2000;
        this.replayEnabled = true;
        this.lastAuditStarted = peerreview.getTime();
        this.auditIntervalMillis = 10000L;
        this.auditTimer = peerreview.getEnvironment().getSelectorManager().schedule(new TimerTask(){

            public void run() {
                AuditProtocolImpl.this.auditsTimerExpired();
            }
        }, this.auditIntervalMillis);
    }

    public void setLogDownloadTimeout(int timeoutMicros) {
        this.logDownloadTimeout = timeoutMicros;
    }

    public void disableReplay() {
        this.replayEnabled = false;
    }

    void beginAudit(Handle target, Authenticator authFrom, Authenticator authTo, byte needPrevCheckpoint, boolean replayAnswer) {
        long evidenceSeq = this.peerreview.getEvidenceSeq();
        ChallengeAudit audit = new ChallengeAudit(needPrevCheckpoint, authFrom, authTo);
        ChallengeMessage<Identifier> auditRequest = new ChallengeMessage<Identifier>(this.peerreview.getLocalId(), evidenceSeq, audit);
        ActiveAuditInfo<Handle, Identifier> aai = new ActiveAuditInfo<Handle, Identifier>(target, replayAnswer, false, this.peerreview.getTime() + (long)this.logDownloadTimeout, auditRequest, evidenceSeq, null);
        this.activeAudit.put(this.peerreview.getIdentifierExtractor().extractIdentifier(target), aai);
        if (this.logger.level <= 500) {
            this.logger.log("Sending AUDIT request to " + aai.target + " (range=" + authFrom.getSeq() + "-" + authTo.getSeq() + ",eseq=" + evidenceSeq + ")");
        }
        this.peerreview.transmit(target, auditRequest, null, null);
    }

    public void startAudits() {
        Collection<Handle> buffer = this.peerreview.getApp().getMyWitnessedNodes();
        for (RawSerializable h : buffer) {
            RawSerializable i = (RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(h);
            int status = this.infoStore.getStatus(i);
            if (status != 0) {
                if (this.logger.level > 500) continue;
                this.logger.log("Node " + h + " is " + Basics.renderStatus(status) + "; skipping audit");
                continue;
            }
            if (!this.activeAudit.containsKey(h)) {
                Authenticator authTo;
                Authenticator authFrom;
                boolean haveEnoughAuthenticators = true;
                byte needPrevCheckpoint = 0;
                if (this.logger.level <= 800) {
                    this.logger.log("Starting to audit " + h);
                }
                if ((authFrom = this.infoStore.getLastCheckedAuth(i)) == null) {
                    authFrom = this.authInStore.getOldestAuthenticator(i);
                    if (authFrom != null) {
                        if (this.logger.level <= 500) {
                            this.logger.log("We haven't audited this node before; using oldest authenticator");
                        }
                        needPrevCheckpoint = 1;
                    } else {
                        if (this.logger.level <= 500) {
                            this.logger.log("We don't have any authenticators for this node; skipping this audit");
                        }
                        haveEnoughAuthenticators = false;
                    }
                }
                if ((authTo = this.authInStore.getMostRecentAuthenticator(i)) == null) {
                    if (this.logger.level <= 500) {
                        this.logger.log("No recent authenticator; skipping this audit");
                    }
                    haveEnoughAuthenticators = false;
                }
                if (haveEnoughAuthenticators && authFrom.getSeq() > authTo.getSeq()) {
                    if (this.logger.level <= 500) {
                        this.logger.log("authFrom>authTo; skipping this audit");
                    }
                    haveEnoughAuthenticators = false;
                }
                if (!haveEnoughAuthenticators) continue;
                this.beginAudit(h, authFrom, authTo, needPrevCheckpoint, true);
                continue;
            }
            if (this.logger.level > 900) continue;
            this.logger.log("Node " + h + " is already being audited; skipping");
        }
        this.scheduleProgressTimer();
    }

    protected void scheduleProgressTimer() {
        if (this.progressTimer == null) {
            this.progressTimer = this.peerreview.getEnvironment().getSelectorManager().schedule(new TimerTask(){

                public void run() {
                    AuditProtocolImpl.this.makeProgressTimerExpired();
                }
            }, 100L);
        }
    }

    void cleanupAudits() {
        long now = this.peerreview.getTime();
        for (ActiveAuditInfo<Handle, Identifier> foo : this.activeAudit.values()) {
            if (now < foo.currentTimeout || foo.isReplaying) continue;
            RawSerializable i = (RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(foo.target);
            if (this.logger.level <= 900) {
                this.logger.log("No response to AUDIT request; filing as evidence " + foo.evidenceSeq);
            }
            try {
                this.infoStore.addEvidence((RawSerializable)this.peerreview.getLocalId(), i, foo.evidenceSeq, foo.request.challenge);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.peerreview.sendEvidenceToWitnesses(i, foo.evidenceSeq, foo.request.challenge);
            this.terminateAudit((RawSerializable)foo.target);
        }
    }

    void terminateAudit(Handle h) {
        this.activeAudit.remove(h);
    }

    void terminateInvestigation(Handle h) {
        this.activeInvestigation.remove(h);
    }

    void makeProgressOnInvestigations() {
        long now = this.peerreview.getTime();
        for (ActiveInvestigationInfo<Handle> aii : this.activeInvestigation.values()) {
            long authToSeq;
            if (aii.currentTimeout >= now) continue;
            long authFromSeq = aii.authFrom != null ? aii.authFrom.getSeq() : -1L;
            long l = authToSeq = aii.authTo != null ? aii.authTo.getSeq() : -1L;
            if (0L <= authFromSeq && authFromSeq <= aii.since && aii.since < authToSeq) {
                if (this.logger.level <= 500) {
                    this.logger.log("Investigation of " + aii.target + " (since " + aii.since + ") is proceeding with an audit");
                }
                if (authToSeq > authFromSeq) {
                    if (this.logger.level <= 400) {
                        this.logger.log("Authenticators: " + authFromSeq + "-" + authToSeq);
                    }
                    this.beginAudit((RawSerializable)aii.target, aii.authFrom, aii.authTo, (byte)2, false);
                    this.terminateInvestigation((RawSerializable)aii.target);
                    continue;
                }
                if (this.logger.level <= 900) {
                    this.logger.log("Cannot start investigation; authTo<authFrom ?!? (since=" + aii.since + ", authFrom=" + authFromSeq + ", authTo=" + authToSeq + ")");
                }
                this.terminateInvestigation((RawSerializable)aii.target);
                continue;
            }
            if (this.logger.level <= 500) {
                this.logger.log("Retransmitting investigation requests for " + aii.target + " at " + aii.since);
            }
            this.sendInvestigation((RawSerializable)aii.target);
            aii.currentTimeout += 250L;
        }
    }

    private void sendInvestigation(Handle target) {
    }

    void setAuditInterval(long newIntervalMillis) {
        this.auditIntervalMillis = newIntervalMillis;
        this.auditTimer.cancel();
        this.startAuditTimer();
    }

    protected void auditsTimerExpired() {
        this.startAudits();
        this.lastAuditStarted = this.peerreview.getTime();
        this.startAuditTimer();
    }

    protected void startAuditTimer() {
        long now = this.peerreview.getTime();
        long nextTimeout = this.lastAuditStarted + (long)((double)(500 + this.peerreview.getRandomSource().nextInt(1000)) * 0.001 * (double)this.auditIntervalMillis);
        if (nextTimeout <= now) {
            nextTimeout = now + 1L;
        }
        this.auditTimer = this.peerreview.getEnvironment().getSelectorManager().schedule(new TimerTask(){

            public void run() {
                AuditProtocolImpl.this.auditsTimerExpired();
            }
        }, nextTimeout - now);
    }

    protected void makeProgressTimerExpired() {
        this.progressTimer.cancel();
        this.cleanupAudits();
        this.makeProgressOnInvestigations();
        if (this.progressTimer == null && (this.activeAudit.size() > 0 || this.activeInvestigation.size() > 0)) {
            this.progressTimer = this.peerreview.getEnvironment().getSelectorManager().schedule(new TimerTask(){

                public void run() {
                    AuditProtocolImpl.this.makeProgressTimerExpired();
                }
            }, 100L);
        }
    }

    @Override
    public void processAuditResponse(Identifier subject, long timestamp, AuditResponse<Handle> response) throws IOException {
        long nextAuthSeq;
        long currentSeq;
        LogSnippet snippet = response.getLogSnippet();
        ActiveAuditInfo<Handle, Identifier> aai = this.findOngoingAudit(subject, timestamp);
        ChallengeAudit challengeAudit = (ChallengeAudit)aai.request.challenge;
        long fromSeq = challengeAudit.from.getSeq();
        Authenticator toAuthenticator = challengeAudit.to;
        long toSeq = toAuthenticator.getSeq();
        byte[] currentNodeHash = snippet.baseHash;
        byte[] initialNodeHash = snippet.baseHash;
        Handle subjectHandle = response.getLogOwner();
        long initialCurrentSeq = currentSeq = snippet.getFirstSeq();
        List<Authenticator> auths = this.authInStore.getAuthenticators(subject, fromSeq, toSeq);
        if (this.logger.level <= 500) {
            this.logger.log("Checking of AUDIT response against " + auths.size() + " authenticators [" + fromSeq + "-" + toSeq + "]");
        }
        long mostRecentAuthInCache = -1L;
        Authenticator mrauth = this.authCacheStore.getMostRecentAuthenticator(subject);
        if (mrauth != null) {
            mostRecentAuthInCache = mrauth.getSeq();
        }
        for (int i = auths.size() - 1; i >= 0; --i) {
            Authenticator thisAuth = auths.get(i);
            long thisSeq = thisAuth.getSeq();
            if (thisSeq <= mostRecentAuthInCache + 500000000L) continue;
            if (this.logger.level <= 400) {
                this.logger.log("Caching auth " + thisSeq + " for " + subject);
            }
            this.authCacheStore.addAuthenticator(subject, thisAuth);
            mostRecentAuthInCache = thisSeq;
        }
        int authPtr = auths.size() - 1;
        Authenticator nextAuth = authPtr < 0 ? null : auths.get(authPtr);
        long l = nextAuthSeq = authPtr < 0 ? -1L : nextAuth.getSeq();
        if (this.logger.level <= 400) {
            this.logger.log("  NA #" + authPtr + " " + nextAuthSeq);
        }
        for (SnippetEntry sEntry : snippet.entries) {
            byte[] contentHash;
            currentSeq = sEntry.seq;
            if (this.logger.level <= 400) {
                this.logger.log("[2] Entry type " + sEntry.type + ", size=" + sEntry.content.length + ", seq=" + currentSeq + (sEntry.isHash ? " (hashed)" : ""));
            }
            byte[] entry = sEntry.content;
            if (sEntry.isHash) {
                contentHash = sEntry.content;
                assert (contentHash.length == this.peerreview.getHashSizeInBytes());
            } else {
                contentHash = this.transport.hash(ByteBuffer.wrap(entry));
            }
            currentNodeHash = this.transport.hash(currentSeq, sEntry.type, currentNodeHash, contentHash);
            if (this.logger.level <= 300) {
                this.logger.log("NH [" + MathUtils.toBase64(currentNodeHash) + "]");
            }
            if (authPtr < 0) continue;
            boolean foundMisbehavior = false;
            if (currentSeq == nextAuthSeq) {
                if (!Arrays.equals(currentNodeHash, nextAuth.getHash())) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Found a divergence for node <" + subject + ">'s authenticator #" + currentSeq);
                    }
                    foundMisbehavior = true;
                } else {
                    if (this.logger.level <= 300) {
                        this.logger.log("Authenticator verified OK");
                    }
                    nextAuth = --authPtr < 0 ? null : auths.get(authPtr);
                    long l2 = nextAuthSeq = authPtr < 0 ? -1L : nextAuth.getSeq();
                    if (this.logger.level <= 300) {
                        this.logger.log("NA #" + authPtr + " " + nextAuthSeq);
                    }
                }
            } else if (currentSeq > nextAuthSeq) {
                if (this.logger.level <= 900) {
                    this.logger.log("Node " + subject + " is trying to hide authenticator #" + nextAuthSeq);
                }
                foundMisbehavior = true;
            }
            if (!foundMisbehavior) continue;
            if (this.logger.level <= 500) {
                this.logger.log("Extracting proof of misbehavior from audit response");
            }
            ProofInconsistent proof = new ProofInconsistent(toAuthenticator, nextAuth, snippet);
            long evidenceSeq = this.peerreview.getEvidenceSeq();
            if (this.logger.level <= 500) {
                this.logger.log("Filing proof against " + subject + " under evidence sequence number #" + evidenceSeq);
            }
            this.infoStore.addEvidence(this.peerreview.getLocalId(), subject, evidenceSeq, proof);
            this.peerreview.sendEvidenceToWitnesses(subject, evidenceSeq, proof);
            this.terminateAudit((RawSerializable)aai.target);
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("All authenticators in range [" + fromSeq + "," + toSeq + "] check out OK; flushing");
        }
        this.authInStore.flushAuthenticatorsFor(subject, Long.MIN_VALUE, toSeq);
        String namebuf = this.infoStore.getHistoryName(subject);
        if (this.logger.level <= 500) {
            this.logger.log("opening history for " + namebuf);
        }
        SecureHistory subjectHistory = this.peerreview.getHistoryFactory().open(namebuf, "w");
        boolean logCanBeAppended = false;
        long topSeq = 0L;
        if (subjectHistory != null) {
            topSeq = subjectHistory.getTopLevelEntry().getSeq();
            if (topSeq >= fromSeq) {
                logCanBeAppended = true;
            }
        } else {
            logCanBeAppended = true;
        }
        if (!aai.shouldBeReplayed) {
            if (this.logger.level <= 500) {
                this.logger.log("This audit response does not need to be replayed; discarding");
            }
            this.terminateAudit((RawSerializable)aai.target);
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("Adding entries in snippet to log '" + namebuf + "'");
        }
        if (!logCanBeAppended) {
            throw new RuntimeException("Cannot append snippet to local copy of node's history; there appears to be a gap (" + topSeq + "-" + fromSeq + ")!");
        }
        if (subjectHistory == null && (subjectHistory = this.peerreview.getHistoryFactory().create(namebuf, initialCurrentSeq - 1L, initialNodeHash)) == null) {
            throw new RuntimeException("Cannot create subject history: '" + namebuf + "'");
        }
        long firstNewSeq = currentSeq - currentSeq % 1000000L + 1000000L;
        subjectHistory.appendSnippetToHistory(snippet);
        if (this.replayEnabled) {
            short[] markerTypes = new short[]{4};
            long lastCheckpointIdx = subjectHistory.findLastEntry(markerTypes, fromSeq);
            if (this.logger.level <= 300) {
                this.logger.log("LastCheckpointIdx=" + lastCheckpointIdx + " (up to " + fromSeq + ")");
            }
            if (lastCheckpointIdx < 0L) {
                if (this.logger.level <= 900) {
                    this.logger.log("Cannot find last checkpoint in subject history " + namebuf);
                }
                this.terminateAudit(subjectHandle);
                return;
            }
            Verifier<Handle> verifier = this.peerreview.getVerifierFactory().getVerifier(subjectHistory, subjectHandle, lastCheckpointIdx, fromSeq / 1000000L, snippet.getExtInfo());
            PeerReviewCallback<Handle, Identifier> replayApp = this.peerreview.getApp().getReplayInstance(verifier);
            if (replayApp == null) {
                throw new RuntimeException("Application returned NULL when getReplayInstance() was called");
            }
            verifier.setApplication(replayApp);
            aai.verifier = verifier;
            aai.isReplaying = true;
            if (this.logger.level <= 800) {
                this.logger.log("REPLAY ============================================");
            }
            if (this.logger.level <= 500) {
                this.logger.log("Node being replayed: " + subjectHandle);
            }
            if (this.logger.level <= 500) {
                this.logger.log("Range in log       : " + fromSeq + "-" + toSeq);
            }
            ReplaySM sm = (ReplaySM)verifier.getEnvironment().getSelectorManager();
            while (sm.makeProgress()) {
            }
            boolean verifiedOK = verifier.verifiedOK();
            if (this.logger.level <= 800) {
                this.logger.log("END OF REPLAY: " + (verifiedOK ? "VERIFIED OK" : "VERIFICATION FAILED") + " =================");
            }
            if (!verifiedOK) {
                snippet = subjectHistory.serializeRange(lastCheckpointIdx, subjectHistory.getNumEntries() - 1L, null);
                if (snippet == null) {
                    throw new RuntimeException("Cannot serialize range for PROOF " + subject);
                }
                IndexEntry foo = subjectHistory.statEntry(lastCheckpointIdx);
                if (foo == null) {
                    throw new RuntimeException("Cannot stat checkpoint entry");
                }
                long lastCheckpointSeq = foo.getSeq();
                if (this.logger.level <= 900) {
                    this.logger.log("Audit revealed a protocol violation; filing evidence (snippet from " + lastCheckpointSeq + ")");
                }
                ProofNonconformant<Handle> proof = new ProofNonconformant<Handle>(toAuthenticator, subjectHandle, snippet);
                long evidenceSeq = this.peerreview.getEvidenceSeq();
                this.infoStore.addEvidence(this.peerreview.getLocalId(), subject, evidenceSeq, proof);
                this.peerreview.sendEvidenceToWitnesses(subject, evidenceSeq, proof);
            }
        }
        if (this.logger.level <= 500) {
            this.logger.log("Audit completed; terminating");
        }
        this.infoStore.setLastCheckedAuth(this.peerreview.getIdentifierExtractor().extractIdentifier(aai.target), ((ChallengeAudit)aai.request.challenge).to);
        this.terminateAudit((RawSerializable)aai.target);
    }

    public ActiveAuditInfo<Handle, Identifier> findOngoingAudit(Identifier subject, long evidenceSeq) {
        ActiveAuditInfo<Handle, Identifier> ret = this.activeAudit.get(subject);
        if (ret == null) {
            return null;
        }
        if (!ret.isReplaying && ret.evidenceSeq == evidenceSeq) {
            return ret;
        }
        return null;
    }

    @Override
    public Evidence statOngoingAudit(Identifier subject, long evidenceSeq) {
        ActiveAuditInfo<Handle, Identifier> aii = this.findOngoingAudit(subject, evidenceSeq);
        if (aii == null) {
            return null;
        }
        return aii.request.challenge;
    }

    @Override
    public void handleIncomingDatagram(Handle handle, PeerReviewMessage message) {
        switch (message.getType()) {
            case 22: {
                Authenticator foo;
                AuthRequest request = (AuthRequest)message;
                if (this.logger.level <= 800) {
                    this.logger.log("Received authenticator request for " + request.subject + " (since " + request.timestamp + ")");
                }
                Authenticator a1 = this.authInStore.getLastAuthenticatorBefore(request.subject, request.timestamp);
                Authenticator a2 = this.authCacheStore.getLastAuthenticatorBefore(request.subject, request.timestamp);
                Authenticator a3 = this.authInStore.getOldestAuthenticator(request.subject);
                Authenticator best = null;
                if (a1 != null && (best == null || best.getSeq() >= request.timestamp && a1.getSeq() < request.timestamp || best.getSeq() < request.timestamp && a1.getSeq() < request.timestamp && best.getSeq() < a1.getSeq())) {
                    best = a1;
                }
                if (a2 != null && (best == null || best.getSeq() >= request.timestamp && a2.getSeq() < request.timestamp || best.getSeq() < request.timestamp && a2.getSeq() < request.timestamp && best.getSeq() < a2.getSeq())) {
                    best = a2;
                }
                if (a3 != null && (best == null || best.getSeq() >= request.timestamp && a3.getSeq() < request.timestamp || best.getSeq() < request.timestamp && a3.getSeq() < request.timestamp && best.getSeq() < a3.getSeq())) {
                    best = a3;
                }
                if ((foo = this.authInStore.getMostRecentAuthenticator(request.subject)) == null) {
                    foo = this.authCacheStore.getMostRecentAuthenticator(request.subject);
                }
                if (best != null && foo != null) {
                    AuthResponse response = new AuthResponse(request.subject, best, foo);
                    this.peerreview.transmit(handle, response, null, null);
                    break;
                }
                if (this.logger.level > 900) break;
                this.logger.log("Cannot respond to this request; we don't have any authenticators for " + request.subject);
                break;
            }
            case 23: {
                AuthResponse response = (AuthResponse)message;
                if (this.logger.level <= 500) {
                    this.logger.log("Received AUTHRESP(<" + response.subject + ">, " + response.authFrom + ".." + response.authTo + ") from " + handle);
                }
                int idx = -1;
                ActiveInvestigationInfo<Handle> investigation = this.activeInvestigation.get(response.subject);
                if (idx >= 0) {
                    if (investigation.authFrom == null || response.authFrom.getSeq() < investigation.authFrom.getSeq()) {
                        investigation.authFrom = response.authFrom;
                    }
                    if (investigation.authTo != null && response.authTo.getSeq() <= investigation.authTo.getSeq()) break;
                    investigation.authTo = response.authTo;
                    break;
                }
                if (this.logger.level > 900) break;
                this.logger.log("AUTH response does not match any ongoing investigations; ignoring");
                break;
            }
            default: {
                throw new RuntimeException("AuditProtocol cannot handle incoming datagram type #" + message.getType());
            }
        }
    }

    protected void sendInvestigation(ActiveInvestigationInfo<Handle> investigation) {
        RawSerializable id = (RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(investigation.target);
        AuthRequest<RawSerializable> request = new AuthRequest<RawSerializable>(investigation.since, id);
        this.evidenceTransferProtocol.sendMessageToWitnesses(id, request, null, null);
    }

    public void investigate(Handle target, long since) {
        RawSerializable id = (RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(target);
        ActiveInvestigationInfo<Handle> investigation = this.activeInvestigation.get(id);
        if (investigation != null) {
            if (since * 1000000L > investigation.since) {
                if (this.logger.level <= 500) {
                    this.logger.log("Skipping investigation request for " + target + " at " + since + ", since an investigation at " + investigation.since + " is already ongoing");
                }
                return;
            }
            if (this.logger.level <= 500) {
                this.logger.log("Extending existing investigation from " + investigation.since + " to " + since * 1000000L);
            }
            investigation.since = since * 1000000L;
        } else {
            investigation = new ActiveInvestigationInfo<Handle>(target, since * 1000000L, this.peerreview.getTime() + 250L, null, null);
            this.activeInvestigation.put(id, investigation);
        }
        this.sendInvestigation(investigation);
        this.scheduleProgressTimer();
    }
}

