/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.identity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import org.mpisws.p2p.transport.identity.BindStrategy;
import org.mpisws.p2p.transport.identity.IdentitySerializer;
import org.mpisws.p2p.transport.identity.LowerIdentity;
import org.mpisws.p2p.transport.identity.MemoryExpiredException;
import org.mpisws.p2p.transport.identity.NodeChangeStrategy;
import org.mpisws.p2p.transport.identity.SanityChecker;
import org.mpisws.p2p.transport.identity.SerializerListener;
import org.mpisws.p2p.transport.identity.UpperIdentity;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.liveness.LivenessTypes;
import org.mpisws.p2p.transport.liveness.OverrideLiveness;
import org.mpisws.p2p.transport.proximity.ProximityListener;
import org.mpisws.p2p.transport.proximity.ProximityProvider;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.InsufficientBytesException;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.OptionsFactory;
import org.mpisws.p2p.transport.util.SocketInputBuffer;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketWrapperSocket;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityImpl<UpperIdentifier, MiddleIdentifier, UpperMsgType, LowerIdentifier>
implements LivenessTypes {
    protected byte[] localIdentifier;
    protected LowerIdentityImpl lower;
    protected UpperIdentityImpl upper;
    protected Map<UpperIdentifier, Set<IdentityMessageHandle>> pendingMessages;
    protected Set<UpperIdentifier> deadForever;
    protected Environment environment;
    protected Logger logger;
    protected IdentitySerializer<UpperIdentifier, MiddleIdentifier, LowerIdentifier> serializer;
    protected NodeChangeStrategy<UpperIdentifier> nodeChangeStrategy;
    protected SanityChecker<UpperIdentifier, MiddleIdentifier> sanityChecker;
    protected Map<MiddleIdentifier, UpperIdentifier> bindings;
    int intendedDestCtr = Integer.MIN_VALUE;
    public static final byte SUCCESS = 1;
    public static final byte FAILURE = 0;
    public static final byte NO_ID = 2;
    public static final byte NORMAL = 1;
    public static final byte INCORRECT_IDENTITY = 0;
    public static final String NODE_HANDLE_FROM_INDEX = "identity.node_handle_to_index";
    public static final String DONT_VERIFY = "identity.dont_verify_dest";
    public BindStrategy<UpperIdentifier, LowerIdentifier> bindStrategy;
    OverrideLiveness<LowerIdentifier> overrideLiveness;

    public IdentityImpl(byte[] localIdentifier, IdentitySerializer<UpperIdentifier, MiddleIdentifier, LowerIdentifier> serializer, NodeChangeStrategy<UpperIdentifier> nodeChangeStrategy, SanityChecker<UpperIdentifier, MiddleIdentifier> sanityChecker, BindStrategy<UpperIdentifier, LowerIdentifier> bindStrategy, Environment environment) {
        this.logger = environment.getLogManager().getLogger(IdentityImpl.class, null);
        this.bindStrategy = bindStrategy;
        this.sanityChecker = sanityChecker;
        if (sanityChecker == null) {
            throw new IllegalArgumentException("SanityChecker is null");
        }
        this.localIdentifier = localIdentifier;
        this.serializer = serializer;
        this.nodeChangeStrategy = nodeChangeStrategy;
        this.environment = environment;
        this.pendingMessages = new HashMap<UpperIdentifier, Set<IdentityMessageHandle>>();
        this.deadForever = Collections.synchronizedSet(new HashSet());
        this.bindings = new HashMap<MiddleIdentifier, UpperIdentifier>();
        serializer.addSerializerListener(new SerializerListener<UpperIdentifier>(){

            @Override
            public void nodeHandleFound(final UpperIdentifier handle) {
                Runnable r = new Runnable(){

                    public void run() {
                        IdentityImpl.this.addBinding(handle, null, null);
                    }
                };
                if (IdentityImpl.this.environment.getSelectorManager().isSelectorThread()) {
                    r.run();
                } else {
                    IdentityImpl.this.environment.getSelectorManager().invoke(r);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingMessage(UpperIdentifier i, IdentityMessageHandle ret) {
        if (this.logger.level <= 400) {
            this.logger.log("addPendingMessage(" + i + "," + ret + ")");
        }
        Map<UpperIdentifier, Set<IdentityMessageHandle>> map = this.pendingMessages;
        synchronized (map) {
            Set<IdentityMessageHandle> set = this.pendingMessages.get(i);
            if (set == null) {
                set = new HashSet<IdentityMessageHandle>();
                this.pendingMessages.put(i, set);
            }
            set.add(ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePendingMessage(UpperIdentifier i, IdentityMessageHandle ret) {
        Map<UpperIdentifier, Set<IdentityMessageHandle>> map = this.pendingMessages;
        synchronized (map) {
            Set<IdentityMessageHandle> set = this.pendingMessages.get(i);
            if (set == null) {
                return;
            }
            set.remove(ret);
            if (set.isEmpty()) {
                this.pendingMessages.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMemStats(int logLevel) {
        if (logLevel <= 500) {
            Map<UpperIdentifier, Set<IdentityMessageHandle>> map = this.pendingMessages;
            synchronized (map) {
                int queueSum = 0;
                for (UpperIdentifier i : this.pendingMessages.keySet()) {
                    Set<IdentityMessageHandle> theSet = this.pendingMessages.get(i);
                    int queueSize = 0;
                    if (theSet != null) {
                        queueSize = theSet.size();
                    }
                    queueSum += queueSize;
                    if (logLevel > 400) continue;
                    this.logger.log("PM{" + i + "," + this.upper.getLiveness(i, (Map<String, Object>)null) + "} queue:" + queueSize);
                }
                this.logger.log("NumUpperIds:" + this.pendingMessages.size() + " numPendingMsgs:" + queueSum);
            }
        }
    }

    public void setOverrideLiveness(OverrideLiveness<LowerIdentifier> ol) {
        this.overrideLiveness = ol;
    }

    public void setDeadForever(LowerIdentifier l, UpperIdentifier i, Map<String, Object> options) {
        if (this.deadForever.contains(i)) {
            return;
        }
        if (this.logger.level <= 400) {
            this.logger.logException("setDeadForever(" + l + "," + i + "," + options + ")", new Exception("Stack Trace"));
        }
        this.deadForever.add(i);
        Map<String, Object> o2 = OptionsFactory.addOption(options, NODE_HANDLE_FROM_INDEX, i);
        if (l == null) {
            if (this.logger.level <= 800) {
                this.logger.log("setDeadForever(" + l + "," + i + "," + options + "): l == null");
            }
            this.upper.setLiveness(i, 4, o2);
        } else {
            this.overrideLiveness.setLiveness(l, 4, o2);
        }
        Set<IdentityMessageHandle> cancelMe = this.pendingMessages.remove(i);
        if (cancelMe != null) {
            for (IdentityMessageHandle msg : cancelMe) {
                msg.deadForever();
            }
        }
        this.upper.clearState(i);
    }

    protected UpperIdentifier getIntendedDest(Map<String, Object> options) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        if (!options.containsKey(NODE_HANDLE_FROM_INDEX)) {
            throw new IllegalArgumentException("options doesn't have NODE_HANDLE_FROM_INDEX " + options);
        }
        return (UpperIdentifier)options.get(NODE_HANDLE_FROM_INDEX);
    }

    protected boolean addBinding(UpperIdentifier u, LowerIdentifier l, Map<String, Object> options) {
        if (!this.environment.getSelectorManager().isSelectorThread()) {
            throw new RuntimeException("Must be called on selector thread.");
        }
        if (this.bindStrategy != null && options != null && !this.bindStrategy.accept(u, l, options)) {
            return false;
        }
        MiddleIdentifier m = this.serializer.translateDown(u);
        if (this.deadForever.contains(u)) {
            return false;
        }
        UpperIdentifier old = this.bindings.get(m);
        if (old == null) {
            if (this.logger.level <= 500) {
                this.logger.log("addBinding(" + u + "," + l + ") old is null");
            }
            this.bindings.put(m, u);
            if (l != null) {
                this.overrideLiveness.setLiveness(l, 1, OptionsFactory.addOption(options, NODE_HANDLE_FROM_INDEX, u));
            } else {
                this.upper.setLiveness(u, 1, OptionsFactory.addOption(options, NODE_HANDLE_FROM_INDEX, u));
            }
            return true;
        }
        if (old.equals(u)) {
            if (this.logger.level <= 300) {
                this.logger.log("addBinding(" + u + "," + l + ") old is equal");
            }
            if (l != null) {
                this.overrideLiveness.setLiveness(l, 1, OptionsFactory.addOption(options, NODE_HANDLE_FROM_INDEX, u));
            } else {
                this.upper.setLiveness(u, 1, OptionsFactory.addOption(options, NODE_HANDLE_FROM_INDEX, u));
            }
            return true;
        }
        if (this.destinationChanged(old, u, l, options)) {
            this.bindings.put(m, u);
            if (this.logger.level <= 500) {
                this.logger.log("addBinding(" + u + "," + l + ") old " + old + " is dead");
            }
            if (l == null) {
                if (this.logger.level <= 800) {
                    this.logger.log("addBinding(" + u + "," + l + "): l == null");
                }
                this.upper.setLiveness(u, 1, OptionsFactory.addOption(options, NODE_HANDLE_FROM_INDEX, u));
            } else {
                this.overrideLiveness.setLiveness(l, 1, OptionsFactory.addOption(options, NODE_HANDLE_FROM_INDEX, u));
            }
            return true;
        }
        if (this.logger.level <= 800) {
            this.logger.log("The nodeChangeStrategy found identifier " + u + " to be stale.  Should be using " + old);
        }
        return false;
    }

    public boolean destinationChanged(UpperIdentifier oldDest, UpperIdentifier newDest, LowerIdentifier i, Map<String, Object> options) {
        if (oldDest.equals(newDest)) {
            return true;
        }
        if (this.deadForever.contains(oldDest)) {
            return true;
        }
        if (this.deadForever.contains(newDest)) {
            return false;
        }
        if (this.nodeChangeStrategy.canChange(oldDest, newDest)) {
            if (this.logger.level <= 800) {
                this.logger.log("destinationChanged(" + oldDest + "->" + newDest + "," + i + "," + options + ")");
            }
            this.setDeadForever(i, oldDest, options);
            return true;
        }
        if (this.logger.level <= 800) {
            this.logger.log("destinationDidntChange(" + newDest + "->" + oldDest + "," + i + "," + options + ")");
        }
        this.setDeadForever(i, newDest, options);
        return false;
    }

    public void initLowerLayer(TransportLayer<LowerIdentifier, ByteBuffer> tl, ErrorHandler<LowerIdentifier> handler) {
        this.lower = new LowerIdentityImpl(tl, handler);
    }

    public LowerIdentity<LowerIdentifier, ByteBuffer> getLowerIdentity() {
        return this.lower;
    }

    public UpperIdentity<UpperIdentifier, UpperMsgType> getUpperIdentity() {
        return this.upper;
    }

    public void initUpperLayer(UpperIdentifier localIdentifier, TransportLayer<MiddleIdentifier, UpperMsgType> tl, LivenessProvider<MiddleIdentifier> live, ProximityProvider<MiddleIdentifier> prox, OverrideLiveness<LowerIdentifier> overrideLiveness) {
        if (this.upper != null) {
            throw new IllegalStateException("upper already initialized:" + this.upper);
        }
        this.upper = new UpperIdentityImpl(localIdentifier, tl, live, prox);
        this.setOverrideLiveness(overrideLiveness);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IdentityMessageHandle
    implements MessageRequestHandle<UpperIdentifier, UpperMsgType>,
    MessageCallback<MiddleIdentifier, UpperMsgType> {
        private Cancellable subCancellable;
        private UpperIdentifier identifier;
        private UpperMsgType message;
        private Map<String, Object> options;
        private MessageCallback<UpperIdentifier, UpperMsgType> deliverAckToMe;

        public IdentityMessageHandle(UpperIdentifier identifier, UpperMsgType message, Map<String, Object> options, MessageCallback<UpperIdentifier, UpperMsgType> deliverAckToMe) {
            this.identifier = identifier;
            this.message = message;
            this.options = options;
            this.deliverAckToMe = deliverAckToMe;
        }

        @Override
        public UpperIdentifier getIdentifier() {
            return this.identifier;
        }

        @Override
        public UpperMsgType getMessage() {
            return this.message;
        }

        @Override
        public Map<String, Object> getOptions() {
            return this.options;
        }

        void deadForever() {
            this.cancel();
            if (this.deliverAckToMe != null) {
                this.deliverAckToMe.sendFailed(this, new NodeIsFaultyException(this.identifier, this.message));
            }
        }

        @Override
        public boolean cancel() {
            IdentityImpl.this.removePendingMessage(this.identifier, this);
            return this.subCancellable.cancel();
        }

        public void setSubCancellable(Cancellable cancellable) {
            this.subCancellable = cancellable;
        }

        public Cancellable getSubCancellable() {
            return this.subCancellable;
        }

        @Override
        public void ack(MessageRequestHandle<MiddleIdentifier, UpperMsgType> msg) {
            IdentityImpl.this.removePendingMessage(this.identifier, this);
            if (this.deliverAckToMe != null) {
                this.deliverAckToMe.ack(this);
            }
        }

        @Override
        public void sendFailed(MessageRequestHandle<MiddleIdentifier, UpperMsgType> msg, Exception reason) {
            IdentityImpl.this.removePendingMessage(this.identifier, this);
            if (this.deliverAckToMe != null) {
                this.deliverAckToMe.sendFailed(this, reason);
            }
        }

        public String toString() {
            return "IdMsgHdl{" + this.message + "}->" + this.identifier;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UpperIdentityImpl
    implements UpperIdentity<UpperIdentifier, UpperMsgType>,
    TransportLayerCallback<MiddleIdentifier, UpperMsgType>,
    LivenessListener<MiddleIdentifier>,
    ProximityListener<MiddleIdentifier> {
        TransportLayer<MiddleIdentifier, UpperMsgType> tl;
        ProximityProvider<MiddleIdentifier> prox;
        private ErrorHandler<UpperIdentifier> errorHandler;
        private TransportLayerCallback<UpperIdentifier, UpperMsgType> callback;
        Logger logger;
        private LivenessProvider<MiddleIdentifier> livenessProvider;
        private UpperIdentifier localIdentifier;
        List<LivenessListener<UpperIdentifier>> livenessListeners = new ArrayList();
        protected Map<UpperIdentifier, Integer> liveness = new HashMap();
        Collection<ProximityListener<UpperIdentifier>> proxListeners = new ArrayList();

        public UpperIdentityImpl(UpperIdentifier local, TransportLayer<MiddleIdentifier, UpperMsgType> tl, LivenessProvider<MiddleIdentifier> live, ProximityProvider<MiddleIdentifier> prox) {
            this.localIdentifier = local;
            this.tl = tl;
            this.livenessProvider = live;
            this.prox = prox;
            this.logger = IdentityImpl.this.environment.getLogManager().getLogger(IdentityImpl.class, "upper");
            tl.setCallback(this);
            this.livenessProvider.addLivenessListener(this);
            prox.addProximityListener(this);
        }

        @Override
        public void clearState(UpperIdentifier i) {
            this.livenessProvider.clearState(IdentityImpl.this.serializer.translateDown(i));
        }

        @Override
        public SocketRequestHandle<UpperIdentifier> openSocket(final UpperIdentifier i, final SocketCallback<UpperIdentifier> deliverSocketToMe, final Map<String, Object> options) {
            if (this.logger.level <= 500) {
                this.logger.log("openSocket(" + i + "," + deliverSocketToMe + "," + options + ")");
            }
            final SocketRequestHandleImpl handle = new SocketRequestHandleImpl(i, options, this.logger);
            Object middle = IdentityImpl.this.serializer.translateDown(i);
            if (!IdentityImpl.this.addBinding(i, null, options)) {
                deliverSocketToMe.receiveException(handle, new NodeIsFaultyException(i));
                return handle;
            }
            Map<String, Object> newOptions = OptionsFactory.copyOptions(options);
            newOptions.put(IdentityImpl.NODE_HANDLE_FROM_INDEX, i);
            handle.setSubCancellable(this.tl.openSocket(middle, new SocketCallback<MiddleIdentifier>(){

                @Override
                public void receiveException(SocketRequestHandle<MiddleIdentifier> s, Exception ex) {
                    deliverSocketToMe.receiveException(handle, ex);
                }

                @Override
                public void receiveResult(SocketRequestHandle<MiddleIdentifier> cancellable, P2PSocket<MiddleIdentifier> sock) {
                    deliverSocketToMe.receiveResult(handle, new SocketWrapperSocket(i, sock, UpperIdentityImpl.this.logger, UpperIdentityImpl.this.errorHandler, options));
                }
            }, newOptions));
            return handle;
        }

        @Override
        public MessageRequestHandle<UpperIdentifier, UpperMsgType> sendMessage(UpperIdentifier i, UpperMsgType m, MessageCallback<UpperIdentifier, UpperMsgType> deliverAckToMe, Map<String, Object> options) {
            if (!IdentityImpl.this.environment.getSelectorManager().isSelectorThread()) {
                throw new RuntimeException("Must be called on selector thread.");
            }
            if (this.logger.level <= 500) {
                this.logger.log("sendMessage(" + i + "," + m + "," + options + ")");
            }
            if (IdentityImpl.this.deadForever.contains(i)) {
                MessageRequestHandleImpl mrh = new MessageRequestHandleImpl(i, m, options);
                deliverAckToMe.sendFailed(mrh, new NodeIsFaultyException(i, m));
                return mrh;
            }
            Object middle = IdentityImpl.this.serializer.translateDown(i);
            if (!IdentityImpl.this.addBinding(i, null, options)) {
                MessageRequestHandleImpl mrh = new MessageRequestHandleImpl(i, m, options);
                deliverAckToMe.sendFailed(mrh, new NodeIsFaultyException(i, m));
                return mrh;
            }
            options = OptionsFactory.copyOptions(options);
            options.put(IdentityImpl.NODE_HANDLE_FROM_INDEX, i);
            IdentityMessageHandle ret = new IdentityMessageHandle(i, m, options, deliverAckToMe);
            IdentityImpl.this.addPendingMessage(i, ret);
            ret.setSubCancellable(this.tl.sendMessage(middle, m, ret, options));
            return ret;
        }

        @Override
        public void incomingSocket(P2PSocket<MiddleIdentifier> s) throws IOException {
            Object from;
            if (this.logger.level <= 500) {
                this.logger.log("incomingSocket(" + s + ")");
            }
            if ((from = IdentityImpl.this.getIntendedDest(s.getOptions())) == null) {
                this.errorHandler.receivedException(null, new MemoryExpiredException("No record of the upper identifier for " + s.getIdentifier() + " index=" + s.getOptions().get(IdentityImpl.NODE_HANDLE_FROM_INDEX)));
                s.close();
                return;
            }
            if (IdentityImpl.this.sanityChecker.isSane(from, s.getIdentifier())) {
                this.callback.incomingSocket(new SocketWrapperSocket(from, s, this.logger, this.errorHandler, s.getOptions()));
            } else {
                if (this.logger.level <= 900) {
                    this.logger.logException("incomingSocket() Sanity checker did not match " + from + " to " + s.getIdentifier() + " options:" + s.getOptions(), new Exception("Stack Trace"));
                }
                s.close();
            }
        }

        @Override
        public void messageReceived(MiddleIdentifier i, UpperMsgType m, Map<String, Object> options) throws IOException {
            Object from;
            if (this.logger.level <= 500) {
                this.logger.log("messageReceived(" + i + "," + m + "," + options + ")");
            }
            if ((from = IdentityImpl.this.getIntendedDest(options)) == null) {
                this.errorHandler.receivedException(null, new MemoryExpiredException("No record of the upper identifier for " + i + " index=" + options.get(IdentityImpl.NODE_HANDLE_FROM_INDEX) + " dropping message" + m));
                return;
            }
            if (IdentityImpl.this.sanityChecker.isSane(from, i)) {
                this.callback.messageReceived(from, m, options);
            } else if (this.logger.level <= 900) {
                this.logger.logException("messageReceived() Sanity checker did not match " + from + " to " + i + " options:" + options, new Exception("Stack Trace"));
            }
        }

        @Override
        public boolean checkLiveness(UpperIdentifier i, Map<String, Object> options) {
            if (this.logger.level <= 500) {
                this.logger.log("checkLiveness(" + i + "," + options + ")");
            }
            if (IdentityImpl.this.deadForever.contains(i)) {
                return false;
            }
            options = OptionsFactory.copyOptions(options);
            options.put(IdentityImpl.NODE_HANDLE_FROM_INDEX, i);
            return this.livenessProvider.checkLiveness(IdentityImpl.this.serializer.translateDown(i), options);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLivenessListener(LivenessListener<UpperIdentifier> name) {
            List list = this.livenessListeners;
            synchronized (list) {
                this.livenessListeners.add(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeLivenessListener(LivenessListener<UpperIdentifier> name) {
            List list = this.livenessListeners;
            synchronized (list) {
                return this.livenessListeners.remove(name);
            }
        }

        @Override
        public int getLiveness(UpperIdentifier i, Map<String, Object> options) {
            if (this.logger.level <= 400) {
                this.logger.log("getLiveness(" + i + "," + options + ")");
            }
            if (IdentityImpl.this.deadForever.contains(i)) {
                return 4;
            }
            options = OptionsFactory.copyOptions(options);
            options.put(IdentityImpl.NODE_HANDLE_FROM_INDEX, i);
            return this.livenessProvider.getLiveness(IdentityImpl.this.serializer.translateDown(i), options);
        }

        @Override
        public void livenessChanged(MiddleIdentifier i, int val, Map<String, Object> options) {
            if (IdentityImpl.this.deadForever.contains(i)) {
                if (val < 3 && this.logger.level <= 1000) {
                    this.logger.log("Node " + i + " came back from the dead!  It's a miracle! " + val + " Ignoring.");
                }
                return;
            }
            Object upper = IdentityImpl.this.getIntendedDest(options);
            if (upper == null) {
                if (this.logger.level <= 900) {
                    this.logger.logException("Memory for index " + options.get(IdentityImpl.NODE_HANDLE_FROM_INDEX) + " collected suppressing livenessChanged()", new Exception("Stack Trace"));
                }
                return;
            }
            this.setLiveness(upper, val, options);
        }

        protected void setLiveness(UpperIdentifier i, int val, Map<String, Object> options) {
            int oldLiveness = -55;
            if (this.liveness.containsKey(i)) {
                oldLiveness = this.liveness.get(i);
            }
            if (val != oldLiveness) {
                this.liveness.put(i, val);
                this.notifyLivenessListeners(i, val, options);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyLivenessListeners(UpperIdentifier i, int liveness, Map<String, Object> options) {
            ArrayList temp;
            if (this.logger.level <= 400) {
                this.logger.log("notifyLivenessListeners(" + i + "," + liveness + ")");
            }
            List list = this.livenessListeners;
            synchronized (list) {
                temp = new ArrayList(this.livenessListeners);
            }
            for (LivenessListener livenessListener : temp) {
                livenessListener.livenessChanged(i, liveness, options);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addProximityListener(ProximityListener<UpperIdentifier> name) {
            Collection collection = this.proxListeners;
            synchronized (collection) {
                this.proxListeners.add(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeProximityListener(ProximityListener<UpperIdentifier> name) {
            Collection collection = this.proxListeners;
            synchronized (collection) {
                return this.proxListeners.remove(name);
            }
        }

        @Override
        public int proximity(UpperIdentifier i, Map<String, Object> options) {
            if (this.logger.level <= 300) {
                this.logger.log("proximity(" + i + ")");
            }
            if (IdentityImpl.this.deadForever.contains(i)) {
                return Integer.MAX_VALUE;
            }
            return this.prox.proximity(IdentityImpl.this.serializer.translateDown(i), OptionsFactory.addOption(options, IdentityImpl.NODE_HANDLE_FROM_INDEX, i));
        }

        @Override
        public void proximityChanged(MiddleIdentifier i, int newProx, Map<String, Object> options) {
            Object upper = IdentityImpl.this.getIntendedDest(options);
            if (upper == null) {
                if (this.logger.level <= 900) {
                    this.logger.logException("Memory for " + options.get(IdentityImpl.NODE_HANDLE_FROM_INDEX) + " collected suppressing proximityChanged()", new Exception("Stack Trace"));
                }
                return;
            }
            this.notifyProximityListeners(upper, newProx, options);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyProximityListeners(UpperIdentifier i, int newProx, Map<String, Object> options) {
            ArrayList temp;
            if (this.logger.level <= 400) {
                this.logger.log("notifyProximityListeners(" + i + "," + newProx + ")");
            }
            Collection collection = this.proxListeners;
            synchronized (collection) {
                temp = new ArrayList(this.proxListeners);
            }
            for (ProximityListener proximityListener : temp) {
                proximityListener.proximityChanged(i, newProx, options);
            }
        }

        @Override
        public void acceptMessages(boolean b) {
            this.tl.acceptMessages(b);
        }

        @Override
        public void acceptSockets(boolean b) {
            this.tl.acceptSockets(b);
        }

        @Override
        public UpperIdentifier getLocalIdentifier() {
            return this.localIdentifier;
        }

        @Override
        public void setCallback(TransportLayerCallback<UpperIdentifier, UpperMsgType> callback) {
            this.callback = callback;
        }

        @Override
        public void setErrorHandler(ErrorHandler<UpperIdentifier> handler) {
            this.errorHandler = handler;
        }

        @Override
        public void destroy() {
            if (this.logger.level <= 800) {
                this.logger.log("destroy()");
            }
            this.tl.destroy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LowerIdentityImpl
    implements LowerIdentity<LowerIdentifier, ByteBuffer>,
    TransportLayerCallback<LowerIdentifier, ByteBuffer> {
        TransportLayer<LowerIdentifier, ByteBuffer> tl;
        TransportLayerCallback<LowerIdentifier, ByteBuffer> callback;
        ErrorHandler<LowerIdentifier> errorHandler;
        Logger logger;

        public LowerIdentityImpl(TransportLayer<LowerIdentifier, ByteBuffer> tl, ErrorHandler<LowerIdentifier> handler) {
            this.tl = tl;
            this.logger = IdentityImpl.this.environment.getLogManager().getLogger(IdentityImpl.class, "lower");
            this.errorHandler = handler != null ? handler : new DefaultErrorHandler(this.logger);
            tl.setCallback(this);
        }

        @Override
        public SocketRequestHandle<LowerIdentifier> openSocket(final LowerIdentifier i, final SocketCallback<LowerIdentifier> deliverSocketToMe, final Map<String, Object> options) {
            if (this.logger.level <= 750) {
                this.logger.log("openSocket(" + i + "," + deliverSocketToMe + "," + options + ")");
            }
            final SocketRequestHandleImpl ret = new SocketRequestHandleImpl(i, options, this.logger);
            SimpleOutputBuffer sob = new SimpleOutputBuffer();
            try {
                if (options == null || options.containsKey(IdentityImpl.DONT_VERIFY) && ((Boolean)options.get(IdentityImpl.DONT_VERIFY)).booleanValue()) {
                    sob.writeByte(0);
                } else {
                    sob.writeByte(1);
                    Object dest = IdentityImpl.this.getIntendedDest(options);
                    if (dest == null) {
                        deliverSocketToMe.receiveException(ret, new MemoryExpiredException("No record of the upper identifier for " + i + " index=" + options.get(IdentityImpl.NODE_HANDLE_FROM_INDEX)));
                        return ret;
                    }
                    if (!IdentityImpl.this.addBinding(dest, i, options)) {
                        deliverSocketToMe.receiveException(ret, new NodeIsFaultyException(i));
                        return ret;
                    }
                    IdentityImpl.this.serializer.serialize(sob, dest);
                }
                sob.write(IdentityImpl.this.localIdentifier);
            }
            catch (IOException ioe) {
                deliverSocketToMe.receiveException(ret, ioe);
                return ret;
            }
            final ByteBuffer buf = sob.getByteBuffer();
            ret.setSubCancellable(this.tl.openSocket(i, new SocketCallback<LowerIdentifier>(){

                @Override
                public void receiveResult(SocketRequestHandle<LowerIdentifier> cancellable, final P2PSocket<LowerIdentifier> sock) {
                    ret.setSubCancellable(new Cancellable(){

                        public boolean cancel() {
                            sock.close();
                            return true;
                        }
                    });
                    try {
                        new P2PSocketReceiver<LowerIdentifier>(){

                            @Override
                            public void receiveSelectResult(P2PSocket<LowerIdentifier> socket, boolean canRead, boolean canWrite) throws IOException {
                                if (canRead) {
                                    throw new IOException("Never asked to read!");
                                }
                                if (!canWrite) {
                                    throw new IOException("Can't write!");
                                }
                                if (socket.write(buf) < 0L) {
                                    deliverSocketToMe.receiveException(ret, new ClosedChannelException("Remote node closed socket while opening.  Try again."));
                                    return;
                                }
                                if (buf.hasRemaining()) {
                                    socket.register(false, true, this);
                                } else {
                                    socket.register(true, false, new P2PSocketReceiver<LowerIdentifier>(){
                                        ByteBuffer responseBuffer = ByteBuffer.allocate(1);

                                        @Override
                                        public void receiveException(P2PSocket<LowerIdentifier> socket, Exception ioe) {
                                            deliverSocketToMe.receiveException(ret, ioe);
                                        }

                                        @Override
                                        public void receiveSelectResult(final P2PSocket<LowerIdentifier> socket, boolean canRead, boolean canWrite) throws IOException {
                                            if (!canRead) {
                                                throw new IOException("Can't read!");
                                            }
                                            if (canWrite) {
                                                throw new IOException("Never asked to write!");
                                            }
                                            if (socket.read(this.responseBuffer) == -1L) {
                                                socket.close();
                                                deliverSocketToMe.receiveException(ret, new ClosedChannelException("Remote node closed socket while opening.  Try again."));
                                                return;
                                            }
                                            if (this.responseBuffer.remaining() > 0) {
                                                socket.register(true, false, this);
                                            } else {
                                                byte answer = this.responseBuffer.array()[0];
                                                if (answer == 0) {
                                                    Object newDest;
                                                    if (LowerIdentityImpl.this.logger.level <= 800) {
                                                        LowerIdentityImpl.this.logger.log("openSocket(" + i + "," + deliverSocketToMe + ") answer = FAILURE");
                                                    }
                                                    if (!IdentityImpl.this.addBinding(newDest = IdentityImpl.this.serializer.deserialize(new SocketInputBuffer(socket, IdentityImpl.this.localIdentifier.length), i), i, options)) {
                                                        socket.close();
                                                        deliverSocketToMe.receiveException(ret, new NodeIsFaultyException(i));
                                                    }
                                                    deliverSocketToMe.receiveException(ret, new NodeIsFaultyException(i));
                                                } else {
                                                    ret.setSubCancellable(new Cancellable(){

                                                        public boolean cancel() {
                                                            throw new IllegalStateException("Can't cancel, already delivered. ret:" + ret + " sock:" + socket);
                                                        }
                                                    });
                                                    deliverSocketToMe.receiveResult(ret, socket);
                                                }
                                            }
                                        }
                                    });
                                }
                            }

                            @Override
                            public void receiveException(P2PSocket<LowerIdentifier> socket, Exception ioe) {
                                deliverSocketToMe.receiveException(ret, ioe);
                            }
                        }.receiveSelectResult(sock, false, true);
                    }
                    catch (IOException ioe) {
                        deliverSocketToMe.receiveException(ret, ioe);
                    }
                }

                @Override
                public void receiveException(SocketRequestHandle<LowerIdentifier> s, Exception ex) {
                    deliverSocketToMe.receiveException(ret, ex);
                }
            }, options));
            return ret;
        }

        @Override
        public void incomingSocket(P2PSocket<LowerIdentifier> s) throws IOException {
            if (this.logger.level <= 500) {
                this.logger.log("incomingSocket(" + s + ")");
            }
            new P2PSocketReceiver<LowerIdentifier>(){
                ByteBuffer buf = ByteBuffer.allocate(1);

                @Override
                public void receiveException(P2PSocket<LowerIdentifier> socket, Exception ioe) {
                    LowerIdentityImpl.this.errorHandler.receivedException(socket.getIdentifier(), ioe);
                }

                @Override
                public void receiveSelectResult(P2PSocket<LowerIdentifier> socket, boolean canRead, boolean canWrite) throws IOException {
                    if (socket.read(this.buf) < 0L) {
                        if (LowerIdentityImpl.this.logger.level <= 800) {
                            LowerIdentityImpl.this.errorHandler.receivedException(socket.getIdentifier(), new IOException("Socket closed while incoming."));
                        }
                        return;
                    }
                    if (this.buf.hasRemaining()) {
                        socket.register(true, false, this);
                        return;
                    }
                    this.buf.clear();
                    byte wantsToVerifyB = this.buf.get();
                    final boolean wantsToVerify = wantsToVerifyB == 1;
                    new P2PSocketReceiver<LowerIdentifier>(){
                        ByteBuffer buf;
                        {
                            this.buf = ByteBuffer.allocate(IdentityImpl.this.localIdentifier.length);
                        }

                        @Override
                        public void receiveException(P2PSocket<LowerIdentifier> socket, Exception ioe) {
                            LowerIdentityImpl.this.errorHandler.receivedException(socket.getIdentifier(), ioe);
                        }

                        @Override
                        public void receiveSelectResult(P2PSocket<LowerIdentifier> socket, boolean canRead, boolean canWrite) throws IOException {
                            if (canWrite) {
                                throw new IOException("Never asked to write!");
                            }
                            if (!canRead) {
                                throw new IOException("Can't read!");
                            }
                            if (wantsToVerify) {
                                if (socket.read(this.buf) < 0L) {
                                    if (LowerIdentityImpl.this.logger.level <= 800) {
                                        LowerIdentityImpl.this.errorHandler.receivedException(socket.getIdentifier(), new IOException("Socket closed while incoming."));
                                    }
                                    return;
                                }
                                if (this.buf.hasRemaining()) {
                                    socket.register(true, false, this);
                                    return;
                                }
                                if (!Arrays.equals(this.buf.array(), IdentityImpl.this.localIdentifier)) {
                                    if (LowerIdentityImpl.this.logger.level <= 800) {
                                        LowerIdentityImpl.this.logger.log("incomingSocket() FAILURE expected " + Arrays.toString(this.buf.array()) + " me:" + Arrays.toString(IdentityImpl.this.localIdentifier));
                                    }
                                    byte[] result = new byte[1 + IdentityImpl.this.localIdentifier.length];
                                    result[0] = 0;
                                    System.arraycopy(IdentityImpl.this.localIdentifier, 0, result, 1, IdentityImpl.this.localIdentifier.length);
                                    final ByteBuffer writeMe = ByteBuffer.wrap(result);
                                    new P2PSocketReceiver<LowerIdentifier>(){

                                        @Override
                                        public void receiveException(P2PSocket<LowerIdentifier> socket, Exception ioe) {
                                            LowerIdentityImpl.this.errorHandler.receivedException(socket.getIdentifier(), ioe);
                                        }

                                        @Override
                                        public void receiveSelectResult(P2PSocket<LowerIdentifier> socket, boolean canRead, boolean canWrite) throws IOException {
                                            if (canRead) {
                                                throw new IOException("Not expecting to read.");
                                            }
                                            if (!canWrite) {
                                                throw new IOException("Expecting to write.");
                                            }
                                            if (socket.write(writeMe) == -1L) {
                                                if (LowerIdentityImpl.this.logger.level <= 800) {
                                                    LowerIdentityImpl.this.errorHandler.receivedException(socket.getIdentifier(), new ClosedChannelException("Error on incoming socket."));
                                                }
                                                return;
                                            }
                                            if (buf.hasRemaining()) {
                                                socket.register(false, true, this);
                                                return;
                                            }
                                        }
                                    }.receiveSelectResult(socket, false, true);
                                    return;
                                }
                            } else if (LowerIdentityImpl.this.logger.level <= 800) {
                                LowerIdentityImpl.this.logger.log("Connection from " + socket.getIdentifier() + " didn't want to verify our identity.");
                            }
                            final SocketInputBuffer sib = new SocketInputBuffer(socket, 1024);
                            new P2PSocketReceiver<LowerIdentifier>(){

                                @Override
                                public void receiveException(P2PSocket<LowerIdentifier> socket, Exception ioe) {
                                    LowerIdentityImpl.this.errorHandler.receivedException(socket.getIdentifier(), ioe);
                                }

                                @Override
                                public void receiveSelectResult(P2PSocket<LowerIdentifier> socket, boolean canRead, boolean canWrite) throws IOException {
                                    Object from;
                                    if (canWrite) {
                                        throw new IOException("Never asked to write!");
                                    }
                                    if (!canRead) {
                                        throw new IOException("Can't read!");
                                    }
                                    final Map<String, Object> newOptions = OptionsFactory.copyOptions(socket.getOptions());
                                    try {
                                        from = IdentityImpl.this.serializer.deserialize(sib, socket.getIdentifier());
                                        newOptions.put(IdentityImpl.NODE_HANDLE_FROM_INDEX, from);
                                    }
                                    catch (InsufficientBytesException ibe) {
                                        socket.register(true, false, this);
                                        return;
                                    }
                                    if (!IdentityImpl.this.addBinding(from, socket.getIdentifier(), socket.getOptions())) {
                                        if (LowerIdentityImpl.this.logger.level <= 900) {
                                            LowerIdentityImpl.this.logger.log("Serious error.  There was an attempt to open a socket from a supposedly stale identifier:" + from + ". Current identifier is " + IdentityImpl.this.bindings.get(IdentityImpl.this.serializer.translateUp(socket.getIdentifier())) + " lower:" + socket.getIdentifier());
                                        }
                                        socket.close();
                                        return;
                                    }
                                    byte[] result = new byte[]{1};
                                    final ByteBuffer writeMe = ByteBuffer.wrap(result);
                                    new P2PSocketReceiver<LowerIdentifier>(){

                                        @Override
                                        public void receiveException(P2PSocket<LowerIdentifier> socket, Exception ioe) {
                                            if (LowerIdentityImpl.this.logger.level <= 800) {
                                                LowerIdentityImpl.this.errorHandler.receivedException(socket.getIdentifier(), ioe);
                                            }
                                        }

                                        @Override
                                        public void receiveSelectResult(P2PSocket<LowerIdentifier> socket, boolean canRead, boolean canWrite) throws IOException {
                                            if (canRead) {
                                                throw new IOException("Not expecting to read.");
                                            }
                                            if (!canWrite) {
                                                throw new IOException("Expecting to write.");
                                            }
                                            if (socket.write(writeMe) == -1L) {
                                                if (LowerIdentityImpl.this.logger.level <= 800) {
                                                    LowerIdentityImpl.this.errorHandler.receivedException(socket.getIdentifier(), new ClosedChannelException("Error on incoming socket."));
                                                }
                                                return;
                                            }
                                            if (writeMe.hasRemaining()) {
                                                socket.register(false, true, this);
                                                return;
                                            }
                                            SocketWrapperSocket returnMe = new SocketWrapperSocket(socket.getIdentifier(), socket, LowerIdentityImpl.this.logger, LowerIdentityImpl.this.errorHandler, newOptions);
                                            LowerIdentityImpl.this.callback.incomingSocket(returnMe);
                                        }
                                    }.receiveSelectResult(socket, false, true);
                                }
                            }.receiveSelectResult(socket, true, false);
                        }
                    }.receiveSelectResult(socket, true, false);
                }
            }.receiveSelectResult(s, true, false);
        }

        @Override
        public MessageRequestHandle<LowerIdentifier, ByteBuffer> sendMessage(final LowerIdentifier i, ByteBuffer m, final MessageCallback<LowerIdentifier, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
            byte[] msgWithHeader;
            if (this.logger.level <= 300) {
                byte[] b = new byte[m.remaining()];
                System.arraycopy(m.array(), m.position(), b, 0, b.length);
                this.logger.log("sendMessage(" + i + "," + m + ")" + Arrays.toString(b));
            } else if (this.logger.level <= 500) {
                this.logger.log("sendMessage(" + i + "," + m + ")");
            }
            final MessageRequestHandleImpl ret = new MessageRequestHandleImpl(i, m, options);
            if (options.containsKey(IdentityImpl.NODE_HANDLE_FROM_INDEX)) {
                msgWithHeader = new byte[1 + IdentityImpl.this.localIdentifier.length + m.remaining()];
                msgWithHeader[0] = 2;
                System.arraycopy(IdentityImpl.this.localIdentifier, 0, msgWithHeader, 1, IdentityImpl.this.localIdentifier.length);
                m.get(msgWithHeader, 1 + IdentityImpl.this.localIdentifier.length, m.remaining());
            } else {
                byte[] destBytes;
                Object dest = IdentityImpl.this.getIntendedDest(options);
                if (dest == null) {
                    if (deliverAckToMe != null) {
                        deliverAckToMe.sendFailed(ret, new MemoryExpiredException("No record of the upper identifier for " + i + " index=" + options.get(IdentityImpl.NODE_HANDLE_FROM_INDEX)));
                    }
                    return ret;
                }
                if (!IdentityImpl.this.addBinding(dest, i, options)) {
                    deliverAckToMe.sendFailed(ret, new NodeIsFaultyException(i, m));
                    return ret;
                }
                try {
                    SimpleOutputBuffer sob = new SimpleOutputBuffer((int)((double)IdentityImpl.this.localIdentifier.length * 2.5));
                    IdentityImpl.this.serializer.serialize(sob, dest);
                    destBytes = sob.getBytes();
                }
                catch (IOException ioe) {
                    deliverAckToMe.sendFailed(ret, ioe);
                    return ret;
                }
                msgWithHeader = new byte[1 + destBytes.length + IdentityImpl.this.localIdentifier.length + m.remaining()];
                msgWithHeader[0] = 1;
                System.arraycopy(destBytes, 0, msgWithHeader, 1, destBytes.length);
                System.arraycopy(IdentityImpl.this.localIdentifier, 0, msgWithHeader, 1 + destBytes.length, IdentityImpl.this.localIdentifier.length);
                m.get(msgWithHeader, 1 + destBytes.length + IdentityImpl.this.localIdentifier.length, m.remaining());
            }
            ByteBuffer buf = ByteBuffer.wrap(msgWithHeader);
            ret.setSubCancellable(this.tl.sendMessage(i, buf, new MessageCallback<LowerIdentifier, ByteBuffer>(){

                @Override
                public void ack(MessageRequestHandle<LowerIdentifier, ByteBuffer> msg) {
                    if (ret.getSubCancellable() != null && msg != ret.getSubCancellable()) {
                        throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + ret.getSubCancellable());
                    }
                    if (deliverAckToMe != null) {
                        deliverAckToMe.ack(ret);
                    }
                }

                @Override
                public void sendFailed(MessageRequestHandle<LowerIdentifier, ByteBuffer> msg, Exception ex) {
                    if (ret.getSubCancellable() != null && msg != ret.getSubCancellable()) {
                        throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + ret.getSubCancellable());
                    }
                    if (deliverAckToMe == null) {
                        LowerIdentityImpl.this.errorHandler.receivedException(i, ex);
                    } else {
                        deliverAckToMe.sendFailed(ret, ex);
                    }
                }
            }, options));
            return ret;
        }

        @Override
        public void messageReceived(LowerIdentifier i, ByteBuffer m, Map<String, Object> options) throws IOException {
            Map<String, Object> newOptions = OptionsFactory.copyOptions(options);
            byte msgType = m.get();
            if (this.logger.level <= 500) {
                this.logger.log("messageReceived(" + i + "," + m + "):" + msgType);
            }
            switch (msgType) {
                case 1: {
                    byte[] dest = new byte[IdentityImpl.this.localIdentifier.length];
                    m.get(dest);
                    if (!Arrays.equals(dest, IdentityImpl.this.localIdentifier)) {
                        if (this.logger.level <= 800) {
                            this.logger.log("received message for wrong node from:" + i + " intended:" + Arrays.toString(dest) + " me:" + Arrays.toString(IdentityImpl.this.localIdentifier));
                        }
                        byte[] errorMessage = new byte[1 + IdentityImpl.this.localIdentifier.length];
                        errorMessage[0] = 0;
                        System.arraycopy(IdentityImpl.this.localIdentifier, 0, errorMessage, 1, IdentityImpl.this.localIdentifier.length);
                        ByteBuffer buf = ByteBuffer.wrap(errorMessage);
                        this.tl.sendMessage(i, buf, null, options);
                        return;
                    }
                }
                case 2: {
                    SimpleInputBuffer sib = new SimpleInputBuffer(m.array(), m.position());
                    Object from = IdentityImpl.this.serializer.deserialize(sib, i);
                    m.position(m.array().length - sib.bytesRemaining());
                    if (!IdentityImpl.this.addBinding(from, i, options)) {
                        if (this.logger.level <= 900) {
                            this.logger.log("Warning.  Received message from stale identifier:" + from + ". Current identifier is " + IdentityImpl.this.bindings.get(IdentityImpl.this.serializer.translateUp(i)) + " lower:" + i + " Probably a delayed message, dropping.");
                        }
                        this.errorHandler.receivedUnexpectedData(i, m.array(), m.position(), newOptions);
                        return;
                    }
                    newOptions.put(IdentityImpl.NODE_HANDLE_FROM_INDEX, from);
                    if (this.logger.level <= 300) {
                        byte[] b = new byte[m.remaining()];
                        System.arraycopy(m.array(), m.position(), b, 0, b.length);
                        this.logger.log("received message for me from:" + from + "(" + from + "(" + i + ")) " + Arrays.toString(b));
                    } else if (this.logger.level <= 400) {
                        this.logger.log("received message for me from:" + from + "(" + i + ") " + m);
                    }
                    this.callback.messageReceived(i, m, newOptions);
                    break;
                }
                case 0: {
                    Object oldDest = IdentityImpl.this.bindings.get(IdentityImpl.this.serializer.translateUp(i));
                    Object newDest = IdentityImpl.this.serializer.deserialize(new SimpleInputBuffer(m.array(), m.position()), i);
                    if (this.logger.level <= 800) {
                        this.logger.log("received INCORRECT_IDENTITY:" + i + " old:" + oldDest + " new:" + newDest);
                    }
                    if (!IdentityImpl.this.addBinding(newDest, i, options)) break;
                }
            }
        }

        @Override
        public void acceptMessages(boolean b) {
            this.tl.acceptMessages(b);
        }

        @Override
        public void acceptSockets(boolean b) {
            this.tl.acceptMessages(b);
        }

        @Override
        public LowerIdentifier getLocalIdentifier() {
            return this.tl.getLocalIdentifier();
        }

        @Override
        public void setCallback(TransportLayerCallback<LowerIdentifier, ByteBuffer> callback) {
            this.callback = callback;
        }

        @Override
        public void setErrorHandler(ErrorHandler<LowerIdentifier> handler) {
            this.errorHandler = handler;
        }

        @Override
        public void destroy() {
            if (this.logger.level <= 800) {
                this.logger.log("destroy()");
            }
            this.tl.destroy();
        }
    }
}

