/*******************************************************************************

"FreePastry" Peer-to-Peer Application Development Substrate

Copyright 2002-2007, Rice University. Copyright 2006-2007, Max Planck Institute 
for Software Systems.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

- Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

- Neither the name of Rice  University (RICE), Max Planck Institute for Software 
Systems (MPI-SWS) nor the names of its contributors may be used to endorse or 
promote products derived from this software without specific prior written 
permission.

This software is provided by RICE, MPI-SWS and the contributors on an "as is" 
basis, without any representations or warranties of any kind, express or implied 
including, but not limited to, representations or warranties of 
non-infringement, merchantability or fitness for a particular purpose. In no 
event shall RICE, MPI-SWS or contributors be liable for any direct, indirect, 
incidental, special, exemplary, or consequential damages (including, but not 
limited to, procurement of substitute goods or services; loss of use, data, or 
profits; or business interruption) however caused and on any theory of 
liability, whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software, even if 
advised of the possibility of such damage.

*******************************************************************************/ 
package org.mpisws.p2p.transport.peerreview.evidence;

import java.io.IOException;

import org.mpisws.p2p.transport.peerreview.PeerReviewConstants;
import org.mpisws.p2p.transport.peerreview.audit.LogSnippet;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.infostore.Evidence;
import org.mpisws.p2p.transport.util.Serializer;

import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawSerializable;

/**
PROOF_NONCONFORMANT
byte type = PROOF_NONCONFORMANT
authenticator to
nodehandle myHandle
long long firstSeq
hash baseHash
[snippet; see RESP_AUDIT]  
*/

public class ProofNonconformant<Handle extends RawSerializable> implements PeerReviewConstants, Evidence {
  /**
   * Authenticates the last entry in the snippet
   */
  public Authenticator to;
  public Handle myHandle;
  public LogSnippet snippet;
  
  public ProofNonconformant(Authenticator to, Handle myHandle,
      LogSnippet snippet) {
    this.to = to;
    this.myHandle = myHandle;
    this.snippet = snippet;
  }
  
  public short getEvidenceType() {
    return PROOF_NONCONFORMANT;
  }
  
  public ProofNonconformant(InputBuffer buf, Serializer<Handle> serializer, int hashSize, int signatureSize) throws IOException {
    to = new Authenticator(buf, hashSize, signatureSize);
    myHandle = serializer.deserialize(buf);
    snippet = new LogSnippet(buf,hashSize);    
  }
   
  public void serialize(OutputBuffer buf) throws IOException {
    to.serialize(buf);
    myHandle.serialize(buf);
    snippet.serialize(buf);    
  }
}
