/*
 * #%L
 * Pollen :: Vote Counting
 * 
 * $Id: VotingPersonDTO.java 3122 2012-01-30 20:43:30Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-votecounting/src/main/java/org/chorem/pollen/votecounting/dto/VotingPersonDTO.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Classe DTO représentant un votant.
 *
 * @version $Id: VotingPersonDTO.java 3122 2012-01-30 20:43:30Z tchemit $
 */
public class VotingPersonDTO {

    private String votingId;

    private double weight;

    private String comment;

    private String email;

    private String login;

    private Date votingDate;

    private List<VoteToChoiceDTO> choices;

    public VotingPersonDTO(String votingId, double weight) {
        this.choices = new ArrayList<VoteToChoiceDTO>();
        this.comment = "";
        this.email = "";
        this.login = "";
        this.votingDate = new Date();
        this.votingId = votingId;
        this.weight = weight;
    }

    public String getVotingId() {
        return votingId;
    }

    public void setVotingId(String votingId) {
        this.votingId = votingId;
    }

    public double getWeight() {
        return weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public Date getVotingDate() {
        return votingDate;
    }

    public void setVotingDate(Date votingDate) {
        this.votingDate = votingDate;
    }

    public List<VoteToChoiceDTO> getChoices() {
        return choices;
    }

    public void setChoices(List<VoteToChoiceDTO> choices) {
        this.choices = choices;
    }

}