/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.votecounting.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;

/**
 * Classe DTO représentant un sondage.
 *
 * @version $Id: PollDTO.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class PollDTO {

    private String idPoll;

    private boolean anonymous;

    private PollType typePoll;

    private VoteCountingType typeVoteCounting;

    private int maxChoicesByPerson;

    private String title;

    private String description;

    private Date beginChoiceDate;

    private Date beginDate;

    private Date endDate;

    private boolean closed;

    private boolean anonymousVoteAllowed;

    private boolean choiceAddAllowed;

    private String creatorEmail;

    private String creatorID;

    private List<VotingGroupDTO> votingGroups;

    private List<CommentDTO> comments;

    private List<PollChoiceDTO> choices;

    public PollDTO(String idPoll, int maxChoicesByPerson, PollType typePoll,
            VoteCountingType typeVoteCounting) {
        this.idPoll = idPoll;
        this.beginChoiceDate = new Date();
        this.beginDate = new Date();
        this.choices = new ArrayList<PollChoiceDTO>();
        this.comments = new ArrayList<CommentDTO>();
        this.creatorEmail = "";
        this.creatorID = "";
        this.description = "";
        this.endDate = new Date();
        this.anonymous = false;
        this.anonymousVoteAllowed = false;
        this.choiceAddAllowed = false;
        this.closed = true;
        this.maxChoicesByPerson = maxChoicesByPerson;
        this.title = "";
        this.typePoll = typePoll;
        this.typeVoteCounting = typeVoteCounting;
        this.votingGroups = new ArrayList<VotingGroupDTO>();
    }

    public String getIdPoll() {
        return idPoll;
    }

    public void setIdPoll(String idPoll) {
        this.idPoll = idPoll;
    }

    public boolean isAnonymous() {
        return anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public PollType getTypePoll() {
        return typePoll;
    }

    public void setTypePoll(PollType typePoll) {
        this.typePoll = typePoll;
    }

    public VoteCountingType getTypeVoteCounting() {
        return typeVoteCounting;
    }

    public void setTypeVoteCounting(VoteCountingType typeVoteCounting) {
        this.typeVoteCounting = typeVoteCounting;
    }

    public int getMaxChoicesByPerson() {
        return maxChoicesByPerson;
    }

    public void setMaxChoicesByPerson(int maxChoicesByPerson) {
        this.maxChoicesByPerson = maxChoicesByPerson;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getBeginChoiceDate() {
        return beginChoiceDate;
    }

    public void setBeginChoiceDate(Date beginChoiceDate) {
        this.beginChoiceDate = beginChoiceDate;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isClosed() {
        return closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isChoiceAddAllowed() {
        return choiceAddAllowed;
    }

    public void setChoiceAddAllowed(boolean choiceAddAllowed) {
        this.choiceAddAllowed = choiceAddAllowed;
    }

    public boolean isAnonymousVoteAllowed() {
        return anonymousVoteAllowed;
    }

    public void setAnonymousVoteAllowed(boolean anonymousVoteAllowed) {
        this.anonymousVoteAllowed = anonymousVoteAllowed;
    }

    public String getCreatorEmail() {
        return creatorEmail;
    }

    public void setCreatorEmail(String creatorEmail) {
        this.creatorEmail = creatorEmail;
    }

    public String getCreatorID() {
        return creatorID;
    }

    public void setCreatorID(String creatorID) {
        this.creatorID = creatorID;
    }

    public List<VotingGroupDTO> getVotingGroups() {
        return votingGroups;
    }

    public void setVotingGroups(List<VotingGroupDTO> votingGroups) {
        this.votingGroups = votingGroups;
    }

    public List<CommentDTO> getComments() {
        return comments;
    }

    public void setComments(List<CommentDTO> comments) {
        this.comments = comments;
    }

    public List<PollChoiceDTO> getChoices() {
        return choices;
    }

    public void setChoices(List<PollChoiceDTO> choices) {
        this.choices = choices;
    }

}