/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.strategy;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteForChoice;
import org.chorem.pollen.votecounting.model.Voter;
import org.chorem.pollen.votecounting.strategy.AbstractVoteCountingStrategy;
import org.nuiton.i18n.I18n;

public class NormalStrategy
extends AbstractVoteCountingStrategy {
    public static final int ID = 0;

    public int getId() {
        return 0;
    }

    public String getI18nName() {
        return I18n.n_((String)"pollen.voteCountingType.normal", (Object[])new Object[0]);
    }

    public String getI18nHelp() {
        return I18n.n_((String)"pollen.voteCountingType.normal.help", (Object[])new Object[0]);
    }

    public VoteCountingResult votecount(Set<Voter> voters) {
        SortedMap resultByChoice = this.votersToResult(voters);
        for (Voter voter : voters) {
            this.addVoterChoices(voter, resultByChoice);
        }
        VoteCountingResult result = this.resultToList(resultByChoice);
        return result;
    }

    public String getDisplayVoteValue(Integer voteValue) {
        return voteValue != null ? "OK" : "";
    }

    public boolean isChoiceInVote(Integer voteValue) {
        return voteValue != null && voteValue > 0;
    }

    public boolean isVoteValueNull(Integer voteValue) {
        return voteValue == null || voteValue == 0;
    }

    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.CHECKBOX;
    }

    public boolean isDisplayResultsByChoice() {
        return false;
    }

    public boolean isVoteValueValid(Integer voteValue) {
        return true;
    }

    public boolean isTotalVoteValueValid(int totalValues) {
        return true;
    }

    public String getVoteValueNotValidMessage(Locale locale) {
        return null;
    }

    public String getTotalVoteValueNotValidMessage(Locale locale) {
        return null;
    }

    public void addVoterChoices(Voter voter, Map<String, ChoiceScore> resultByChoice) {
        double voterWeight = voter.getWeight();
        for (VoteForChoice voteForChoice : voter.getVoteForChoices()) {
            Double voteValue = voteForChoice.getVoteValue();
            if (voteValue == null) continue;
            String choiceId = voteForChoice.getChoiceId();
            ChoiceScore choiceScore = resultByChoice.get(choiceId);
            double scoreToAdd = voteValue * voterWeight;
            choiceScore.addScoreValue(scoreToAdd);
        }
    }
}

