/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: usersList.js 3702 2012-09-23 13:48:42Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.2/pollen-ui-struts2/src/main/webapp/js/usersList.js $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
function initUsersPage(action, userId) {

    if (action == 'create') {
        $('#createForm').show();
    }
    if (action == 'edit') {
        $('#editForm').show();
    }

    // listen row selection
    $.addRowSelectTopic('users', function () {
        if (action != '') {
            // come back from action
            action = '';
            return;
        }
        $(".userForm").hide();
    });

    $.addClearSelectTopic('users', function () {
        if (action != '') {
            // come back from action
            action = '';
            return;
        }
        $(".userForm").hide();
    });

    // to create a new row
    $.listenRowTopic('users-addRow', function (event) {

        $('#createForm .errorMessage').hide();
        $('#createForm [name="createUser.login"]').val("");
        $('#createForm [name="createUser.email"]').val("");
        $('#createForm [name="createUser.firstName"]').val("");
        $('#createForm [name="createUser.lastName"]').val("");
        $('#createForm [name="createUser.administrator"]').prop('checked', false);
        $('#editForm').hide();
        $('#deleteForm').hide();
        $('#createForm').show();
    });
}

function userFunctions(cellvalue, options, rowObject) {

    var id = rowObject.id;

    var result = "";

    if (cellvalue.indexOf('edit') > -1) {
        var script = 'return editUser("' + id + '");'
        result += formatLinkByScript(script, editImg, "Edit", editTitle)
    }
    if (cellvalue.indexOf('delete') > -1) {
        var script = 'return confirmDelete("' + id + '");'
        result += formatLinkByScript(script, deleteImg, "Delete", deleteTitle)
    }
    return result;
}

function formatLinkByScript(script, image, imageAlt, imageTitle) {
    return "<a href='#' onclick='" + script + "'><image alt='" + imageAlt + "' title='" + imageTitle + "' src='" + image + "'> </a>";
}

function editUser(id) {
    $('#editForm .errorMessage').hide();
    jQuery.getJSON(
            loadUserUrl, { "userId":id }, function (result) {

                var user = result.data;
                $('#editForm [name="editUser.topiaId"]').val(user.id);
                $('#editForm [name="editUser.login"]').val(user.login);
                $('#editForm [name="editUser.email"]').val(user.email);
                $('#editForm [name="editUser.firstName"]').val(user.firstName);
                $('#editForm [name="editUser.lastName"]').val(user.lastName);
                $('#editForm [name="editUser.administrator"]').prop('checked', false);
                $('#editForm [name="editUser.administrator"]').prop('checked', user.administrator);
                $('#editForm').show();
                $('#createForm').hide();
            }
    );
    return false;
}

function confirmDelete(id) {
    $('.ui-dialog-title').html(deleteTitle)
    var dialog = $("#confirmDialog");
    var url = deleteUrl + '?' + $.param({userId:id, redirectUrl:redirectUrl});
    dialog.load(url);
    dialog.dialog('open');
    return false;
}
