<%--
  #%L
  Pollen :: UI (struts2)
  $Id: favoriteLists.jsp 3522 2012-06-19 10:18:41Z tchemit $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/webapp/WEB-INF/jsp/user/favoriteLists.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>

<link rel="stylesheet" type="text/css"
      href="<s:url value='/css/tipTip.css'/>"/>

<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>
<script type="text/javascript"
        src="<s:url value='/js/favoriteLists.js' />"></script>
<script type="text/javascript"
        src="<s:url value='/js/jquery.tipTip.minified.js' />"></script>

<title><s:text name="pollen.title.favoriteLists"/></title>

<h1 class="title<s:property value='%{pageLogo}'/>">
  <s:text name="pollen.title.favoriteLists"/>
</h1>

<s:url id="loadFavoriteLists" action="getFavoriteLists" namespace="/json"/>

<script type="text/javascript">

  var redirectUrl = '<s:url namespace="/user" action="favoriteLists"/>';
  var deleteTitle = '<s:text name="pollen.action.deleteFavoriteList"/>';
  var deleteUrl = '<s:url action="confirmDeleteFavoriteList" namespace="/user"/>';
  var loadUserUrl = '<s:url action="getFavoriteList" namespace="/json"/>';
  var editImg = '<s:url value='/img/edit.png'/>';
  var editTitle = '<s:text name="pollen.action.editFavoriteList"/>';
  var deleteImg = '<s:url value='/img/delete.png'/>';
  var csvHelp = "<div><s:text name='pollen.common.favoriteList.csvImport.help'/>" +
                "<br/><img src=\"<s:url value="/img/import_csv_help.png"/>\"/></div>";

  jQuery(document).ready(function () {

    initFavoritesPage("<s:property value='%{#action.action}'/>");
  });
</script>

<sjg:grid id="favoriteLists" dataType="json" href='%{loadFavoriteLists}'
          gridModel="favoriteLists" sortable="true" pager="true"
          pagerButtons="true" pagerInput="true" navigator="true"
          rownumbers="false" autowidth="true" viewrecords="true"
          onSelectRowTopics='favoriteLists-rowSelect'
          onCompleteTopics='favoriteLists-clearSelect'
          navigatorEdit="false" navigatorDelete="false"
          navigatorSearch="false" navigatorRefresh="false"
          navigatorAdd="false" rowList="10,15,20,50,100" rowNum="10"
          navigatorExtraButtons="{
                add:   { title: '%{getText(\"pollen.action.createFavoriteList\")}', icon: 'ui-icon-plus',   topic: 'favoriteLists-addRow'   }}">

  <sjg:gridColumn name="id" title="id" hidden="true"/>
  <sjg:gridColumn name="name" title='%{getText("pollen.common.name")}'/>
  <sjg:gridColumn name="nbAccounts"
                  title='%{getText("pollen.common.nbAccounts")}'/>
  <sjg:gridColumn name="functions" title='%{getText("pollen.common.functions")}'
                  formatter="favoriteListsFunctions" width="40"
                  sortable="false"/>
</sjg:grid>

<br/>
<s:form id='createForm' method="POST" namespace="/user"
        cssClass="hidden favoriteForm" enctype="multipart/form-data">

  <s:hidden name="action" value="create"/>
  <fieldset>
    <legend>
      <s:text name="pollen.fieldset.userFavoriteList.toCreate"/>
    </legend>
    <s:textfield key="createFavoriteList.name" required="true" size="40"
                 label="%{getText('pollen.common.name')}"/>
    <s:file key="csvImport" label="%{getText('pollen.common.csvImport')}"/>
    <s:textfield key="ldapImport" label="%{getText('pollen.common.ldapImport')}"
                 size="40"/>
  </fieldset>
  <br/>
  <s:submit action="createFavoriteList" key="pollen.action.create"
            align="center"/>
</s:form>

<s:form id='editForm' method="POST" namespace="/user" theme="simple"
        action="editFavoriteList" cssClass="hidden">

  <s:hidden key="favoriteListId" label=""/>
  <s:submit action="editFavoriteList"/>

</s:form>

<sj:dialog id="confirmDialog" autoOpen="false" modal="true" width="500"/>

