/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: PollenSession.java 3374 2012-05-18 12:48:26Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/PollenSession.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.ActionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.UserAccount;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.List;
import java.util.Map;

/**
 * User session to put in servlet session.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollenSession {

    /** Logger. */
    private static final Log log = LogFactory.getLog(PollenSession.class);

    /** Key to store the {@link PollenSession} instance in the session's map. */
    protected static final String SESSION_PARAMETER = "pollenSession";

    public static final String SESSION_TOKEN_MESSAGES = "messages";

    public static final String SESSION_TOKEN_ERRORS = "errors";

    public static final String SESSION_TOKEN_WARNINGS = "warnings";

    public static PollenSession get(ServletRequest servletRequest) {
        HttpSession httpSession = ((HttpServletRequest) servletRequest).getSession(true);
        PollenSession pollenSession = (PollenSession) httpSession.getAttribute(SESSION_PARAMETER);
        if (pollenSession == null) {
            pollenSession = new PollenSession();
            httpSession.setAttribute(SESSION_PARAMETER, pollenSession);
        }
        return pollenSession;
    }

    public static PollenSession get(ActionContext actionContext) {

        // load it from session
        Map<String, Object> strutsSession =
                actionContext.getSession();
        PollenSession session = (PollenSession)
                strutsSession.get(SESSION_PARAMETER);

        if (session == null) {

            // create an empty session
            session = new PollenSession();

            // and store it in the struts session
            strutsSession.put(SESSION_PARAMETER, session);
        }
        return session;
    }


    /** User loggued account (if anonymous, then userAccount is null). */
    private UserAccount userAccount;

    /** To push dynamic data which should be consumed in a page scope. */
    private Map<String, Object> dynamicData;

    public UserAccount getUserAccount() {
        return userAccount;
    }

    public void setUserAccount(UserAccount userAccount) {
        this.userAccount = userAccount;
    }

    public <T> T getDynamicData(String token) {
        Object result = getDynamicData().get(token);
        return (T) result;
    }

    public <T> T consumeDynamicData(String token) {
        Object result = getDynamicData().get(token);
        if (result != null) {
            removeDynamicData(token);
        }
        return (T) result;
    }

    public void putDynamicData(String token, Object data) {
        getDynamicData().put(token, data);
        if (log.isDebugEnabled()) {
            log.debug("Dynamic attributes size : " + getDynamicData().size());
        }
    }

    public void removeDynamicData(String token) {
        getDynamicData().remove(token);
        if (log.isDebugEnabled()) {
            log.debug("Dynamic attributes size : " + getDynamicData().size());
        }
    }

    public void clearDynamicData() {
        if (dynamicData != null) {
            dynamicData.clear();
            if (log.isDebugEnabled()) {
                log.debug("Dynamic attributes size : " + dynamicData.size());
            }
        }
    }

    protected Map<String, Object> getDynamicData() {
        if (dynamicData == null) {
            dynamicData = Maps.newHashMap();
        }
        return dynamicData;
    }

    public void addMessage(String messageScope, String message) {
        List<String> messages = getDynamicData(messageScope);
        if (messages == null) {
            messages = Lists.newArrayList(message);
            putDynamicData(messageScope, messages);
        } else {
            messages.add(message);
        }
    }
}
