/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollType;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.persistence.entity.VoterList;
import org.chorem.pollen.persistence.entity.VoterListMember;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.bean.PollenBean;
import org.chorem.pollen.services.bean.PollenEntityId;
import org.chorem.pollen.services.bean.PollenEntityRef;
import org.chorem.pollen.services.bean.VoterListBean;
import org.chorem.pollen.services.bean.VoterListMemberBean;
import org.chorem.pollen.services.bean.export.ExportBean;
import org.chorem.pollen.services.service.InvalidEntityLinkException;
import org.chorem.pollen.services.service.InvalidFormException;
import org.chorem.pollen.services.service.PollenErrors;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.security.PollenPermissions;
import org.nuiton.csv.Exporter;
import org.nuiton.csv.ExporterBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class VoterListService
extends PollenServiceSupport {
    public VoterListMemberBean toVoterListMemberBean(VoterListMember entity) {
        VoterListMemberBean bean = new VoterListMemberBean();
        bean.setEntityId(entity.getTopiaId());
        PollenPrincipal pollenPrincipal = entity.getMember();
        if (pollenPrincipal != null) {
            bean.setName(pollenPrincipal.getName());
            bean.setEmail(pollenPrincipal.getEmail());
            if (pollenPrincipal.getPollenUser() != null && pollenPrincipal.getPollenUser().getAvatar() != null) {
                bean.setAvatar(this.getPollenResourceService().getReduceIdByTopiaId(pollenPrincipal.getPollenUser().getAvatar().getTopiaId()));
            }
        }
        bean.setWeight(entity.getWeight());
        bean.getVoterListId().setEntityId(entity.getVoterList().getTopiaId());
        bean.setInvitationSent(entity.isInvitationSent());
        boolean voting = this.getVoteDao().forVoterListMemberContains(entity).exists();
        bean.setVoting(voting);
        if (pollenPrincipal != null) {
            bean.setInvalidEmail(pollenPrincipal.isInvalid());
        }
        return bean;
    }

    public VoterListMemberBean toVoterListMemberLightBean(VoterListMember entity) {
        VoterListMemberBean bean = new VoterListMemberBean();
        PollenPrincipal pollenPrincipal = entity.getMember();
        if (pollenPrincipal != null) {
            bean.setName(pollenPrincipal.getName());
            if (pollenPrincipal.getPollenUser() != null && pollenPrincipal.getPollenUser().getAvatar() != null) {
                bean.setAvatar(this.getPollenResourceService().getReduceIdByTopiaId(pollenPrincipal.getPollenUser().getAvatar().getTopiaId()));
            }
        }
        boolean voting = this.getVoteDao().forVoterListMemberContains(entity).exists();
        bean.setVoting(voting);
        return bean;
    }

    public VoterListBean toVoterListBean(VoterList entity) {
        this.checkIsConnectedRequired();
        VoterListBean bean = new VoterListBean();
        bean.setEntityId(entity.getTopiaId());
        bean.setName(entity.getName());
        bean.setWeight(entity.getWeight());
        if (entity.getParent() != null) {
            bean.getParentId().setEntityId(entity.getParent().getTopiaId());
        }
        long countSubLists = this.getVoterListDao().forParentEquals(entity).count();
        long countMembers = this.getVoterListMemberDao().forVoterListEquals(entity).count();
        bean.setCountSubLists(countSubLists);
        bean.setCountMembers(countMembers);
        bean.setAllEmails(this.getVoterListMemberMails(entity));
        return bean;
    }

    public List<VoterListBean> getVoterLists(String pollId, String parentId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.read(poll));
        List<VoterList> voterLists = this.getVoterLists0(poll, parentId);
        return voterLists.stream().map(this::toVoterListBean).toList();
    }

    public VoterListBean getMainVoterList(String pollId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.read(poll));
        VoterList voterList = (VoterList)this.getVoterListDao().forPollEquals(poll).addNull("parent").findUniqueOrNull();
        VoterListBean result = null;
        if (voterList != null) {
            result = this.toVoterListBean(voterList);
        }
        return result;
    }

    public VoterListBean getVoterList(String pollId, String voterListId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(voterListId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.read(poll));
        VoterList voterList = this.getVoterList0(poll, voterListId);
        return this.toVoterListBean(voterList);
    }

    public PollenEntityRef<VoterList> addVoterList(String pollId, VoterListBean voterList, List<VoterListMemberBean> members) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(voterList);
        this.checkIsNotPersisted(voterList);
        this.saveVoters(pollId, Collections.singletonList(voterList), members, Collections.emptyList(), Collections.emptyList(), null);
        VoterList result = (VoterList)this.getVoterListDao().forTopiaIdEquals(voterList.getEntityId()).findUnique();
        return PollenEntityRef.of(result);
    }

    public VoterListBean editVoterList(String pollId, VoterListBean voterList) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(voterList);
        this.checkIsPersisted(voterList);
        this.saveVoters(pollId, Collections.singletonList(voterList), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null);
        VoterList result = (VoterList)this.getVoterListDao().forTopiaIdEquals(voterList.getEntityId()).findUnique();
        return this.toVoterListBean(result);
    }

    public void deleteVoterList(String pollId, String voterListId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(voterListId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        VoterList voterList = this.getVoterList0(poll, voterListId);
        this.getVoterListDao().delete(voterList);
        this.commit();
    }

    public Set<VoterListMemberBean> getVoterListMembers(String pollId, String voterListId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(voterListId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.read(poll));
        VoterList voterList = this.getVoterList0(poll, voterListId);
        List<VoterListMember> members = this.getVoterListMembers0(voterList);
        return members.stream().map(this::toVoterListMemberBean).collect(Collectors.toSet());
    }

    public PaginationResult<VoterListMemberBean> getAllVoterListMembers(String pollId, PaginationParameter page) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.readParticipants(poll));
        PaginationParameter orderedPage = VoterListService.orderedPage(page, "member.name");
        PaginationResult result = this.getVoterListMemberDao().forVoterList_PollEquals(poll).findPage(orderedPage);
        return result.transform(this::toVoterListMemberLightBean);
    }

    public ExportBean exportAllVoterListMembers(String pollId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.readParticipants(poll));
        List members = this.getVoterListMemberDao().forVoterList_PollEquals(poll).setOrderByArguments(new String[]{"member.name"}).findAll();
        List<VoterListMemberBean> memberBeans = members.stream().map(this::toVoterListMemberLightBean).toList();
        Exporter beanExporter = new ExporterBuilder().addColumn("name", VoterListMemberBean::getName).addColumn("voting", VoterListMemberBean::isVoting, b -> Boolean.toString(b)).build();
        ExportBean exportBean = new ExportBean();
        try {
            exportBean.setContent(beanExporter.toString(memberBeans));
        }
        catch (IOException e) {
            throw new PollenTechnicalException("erron on export participants", e);
        }
        exportBean.setName(I18n.l((Locale)this.getLocale(), (String)"pollen.export.voterListMember", (Object[])new Object[]{poll.getTitle(), this.getNow()}));
        exportBean.setContentType("text/csv");
        return exportBean;
    }

    public VoterListMemberBean getVoterListMember(String pollId, String voterListId, String memberId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(voterListId);
        this.checkNotNull(memberId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.read(poll));
        VoterList voterList = this.getVoterList0(poll, voterListId);
        VoterListMember member = this.getVoterListMember0(voterList, memberId);
        return this.toVoterListMemberBean(member);
    }

    public VoterListMemberBean addVoterListMember(String pollId, VoterListMemberBean member) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(member);
        this.checkIsNotPersisted(member);
        this.saveVoters(pollId, Collections.emptyList(), Collections.singletonList(member), Collections.emptyList(), Collections.emptyList(), null);
        VoterListMember result = (VoterListMember)this.getVoterListMemberDao().forTopiaIdEquals(member.getEntityId()).findUnique();
        return this.toVoterListMemberBean(result);
    }

    public VoterListMemberBean editVoterListMember(String pollId, VoterListMemberBean member) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(member);
        this.checkIsPersisted(member);
        this.saveVoters(pollId, Collections.emptyList(), Collections.singletonList(member), Collections.emptyList(), Collections.emptyList(), null);
        VoterListMember result = (VoterListMember)this.getVoterListMemberDao().forTopiaIdEquals(member.getEntityId()).findUnique();
        return this.toVoterListMemberBean(result);
    }

    public void deleteVoterListMember(String pollId, String voterListId, String memberId) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(voterListId);
        this.checkNotNull(memberId);
        this.saveVoters(pollId, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(memberId), null);
    }

    protected List<VoterList> getVoterLists0(Poll poll, String parentId) {
        return this.getVoterListDao().forPollEquals(poll).addEquals("parent.topiaId", (Object)parentId).findAll();
    }

    protected VoterList getMainVoterList0(Poll poll) {
        return (VoterList)this.getVoterListDao().forPollEquals(poll).addNull("parent").findUniqueOrNull();
    }

    protected VoterList getVoterList0(Poll poll, String voterListId) {
        VoterList result = (VoterList)this.getVoterListDao().forTopiaIdEquals(voterListId).findUnique();
        if (!poll.equals((Object)result.getPoll())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)result, (PollenEntity)poll);
        }
        return result;
    }

    protected VoterList getVoterList0(String pollId, String voterListId) {
        this.checkNotNull(pollId);
        this.checkNotNull(voterListId);
        Poll poll = this.getPollService().getPoll0(pollId);
        return this.getVoterList0(poll, voterListId);
    }

    protected List<VoterListMember> getVoterListMembers0(VoterList voterList) {
        return this.getVoterListMemberDao().forVoterListEquals(voterList).setOrderByArguments(new String[]{"member.name"}).findAll();
    }

    protected List<VoterListMember> getVoterListMembers0(String voterListId) {
        return this.getVoterListMemberDao().forVoterListIdEquals(voterListId).findAll();
    }

    protected VoterListMember getVoterListMember0(VoterList voterList, String memberId) {
        VoterListMember result = (VoterListMember)this.getVoterListMemberDao().forTopiaIdEquals(memberId).findUnique();
        if (!voterList.equals((Object)result.getVoterList())) {
            throw new InvalidEntityLinkException("voterList", (PollenEntity)voterList, (PollenEntity)result);
        }
        return result;
    }

    protected VoterList saveVoterList(Poll poll, VoterListBean voterList) {
        VoterList toSave;
        boolean voterListExists = voterList.isPersisted();
        if (voterListExists) {
            toSave = this.getVoterList0(poll, voterList.getEntityId());
        } else {
            toSave = (VoterList)this.getVoterListDao().create();
            toSave.setPoll(poll);
            String parentId = voterList.getParentId().getEntityId();
            if (parentId != null) {
                VoterList parent = this.getVoterList0(poll, parentId);
                toSave.setParent(parent);
            }
        }
        toSave.setName(voterList.getName());
        toSave.setWeight(voterList.getWeight());
        return toSave;
    }

    protected VoterListMember saveVoterListMember(Poll poll, VoterListMemberBean voterListMember) {
        PollenPrincipal member;
        VoterListMember toSave;
        boolean voterListMemberExists = voterListMember.isPersisted();
        VoterList voterList = this.getVoterList0(poll, voterListMember.getVoterListId().getEntityId());
        String cleanMail = this.getCleanMail(voterListMember.getEmail());
        if (voterListMemberExists) {
            toSave = this.getVoterListMember0(voterList, voterListMember.getEntityId());
        } else {
            member = this.searchMember(poll, voterListMember, cleanMail);
            toSave = (VoterListMember)this.getVoterListMemberDao().newInstance();
            toSave.setMember(member);
            toSave.setVoterList(voterList);
            this.getVoterListMemberDao().create((PollenEntity)toSave);
        }
        if (!cleanMail.equals(toSave.getMember().getEmail())) {
            member = this.searchMember(poll, voterListMember, cleanMail);
            toSave.setMember(member);
        }
        toSave.getMember().setName(voterListMember.getName());
        toSave.setWeight(voterListMember.getWeight());
        return toSave;
    }

    private PollenPrincipal searchMember(Poll poll, VoterListMemberBean voterListMember, String cleanMail) {
        PollenPrincipal member = this.searchOrCreatePrincipal(poll, cleanMail, voterListMember.getName());
        PollenUser user = this.getPollenUserDao().findUserWithEmailAddressOrNull(cleanMail);
        if (user != null) {
            member.setPollenUser(user);
            member.setName(user.getName());
        }
        return member;
    }

    protected PollenPrincipal searchOrCreatePrincipal(Poll poll, String email, String name) {
        PollenPrincipal principal = poll.getCreator().getEmail() != null && poll.getCreator().getEmail().equals(email) ? poll.getCreator() : (PollenPrincipal)this.getVoterListMemberDao().forVoterList_PollAndMember_EmailEquals(poll, email).tryFindAny().map(VoterListMember::getMember).orElse(null);
        if (principal == null) {
            principal = this.getSecurityService().generatePollenPrincipal();
            principal.setEmail(email);
            principal.setName(name);
        }
        return principal;
    }

    protected PollenErrors checkVoterList(Set<String> sisterNames, VoterListBean voterList, List<VoterListMemberBean> members, List<VoterListBean> subLists) {
        PollenErrors errors = new PollenErrors();
        this.checkNotBlank(errors, "name", voterList.getName(), "pollen.error.voterList.name.mandatory", new Object[0]);
        this.check(errors, "weight", voterList.getWeight() > 0.0, "pollen.error.voterList.weight.greaterThan0", voterList.getWeight(), new Object[0]);
        boolean condition = subLists.isEmpty() && voterList.getCountMembers() == 0L ? false : subLists.stream().noneMatch(voterListBean -> voterListBean.getCountMembers() == 0L);
        this.check(errors, "member", condition, "pollen.error.voterList.member.mandatory", null, new Object[0]);
        boolean nameAlreadyUse = sisterNames.contains(voterList.getName());
        this.check(errors, "name", !nameAlreadyUse, "pollen.error.voterList.name.alreadyUsed", voterList.getName(), new Object[0]);
        int voterListMemberIndex = 0;
        if (CollectionUtils.isNotEmpty(members)) {
            HashSet brotherNames = Sets.newHashSet();
            HashSet brotherEmails = Sets.newHashSet();
            for (VoterListMemberBean voterListMember : members) {
                PollenErrors voterListMemberErrors = this.checkVoterListMember(brotherNames, brotherEmails, voterListMember);
                voterListMemberErrors.copyTo(errors, "member[" + voterListMemberIndex++ + "].");
                brotherNames.add(voterListMember.getName());
                brotherEmails.add(voterListMember.getEmail());
            }
        }
        return errors;
    }

    protected PollenErrors checkVoterListMember(Set<String> voterListMemberNames, Set<String> voterListMemberEmails, VoterListMemberBean voterListMember) {
        String voterListMemberEmail;
        boolean emailNotBlank;
        PollenErrors errors = new PollenErrors();
        String voterListMemberName = voterListMember.getName();
        boolean nameNotblank = this.checkNotBlank(errors, "name", voterListMemberName, "pollen.error.voterList.member.name.mandatory", new Object[0]);
        if (nameNotblank) {
            boolean nameAlreadyUsed = voterListMemberNames.contains(voterListMemberName);
            this.check(errors, "name", !nameAlreadyUsed, "pollen.error.voterList.member.name.alreadyUsed", voterListMemberName, new Object[0]);
        }
        if (emailNotBlank = this.checkNotBlank(errors, "email", voterListMemberEmail = this.getCleanMail(voterListMember.getEmail()), "pollen.error.voterList.member.email.mandatory", new Object[0])) {
            this.checkValidEmail(errors, "email", voterListMemberEmail, "pollen.error.voterList.member.email.invalid", new Object[0]);
            boolean emailAlreadyUsed = voterListMemberEmails.contains(voterListMemberEmail);
            this.check(errors, "email", !emailAlreadyUsed, "pollen.error.voterList.member.email.alreadyUsed", voterListMemberEmail, new Object[0]);
        }
        this.check(errors, "weight", voterListMember.getWeight() > 0.0, "pollen.error.voterList.member.weight.greaterThan0", voterListMember.getWeight(), new Object[0]);
        return errors;
    }

    public void saveVoters(String pollId, List<VoterListBean> listsToSave, List<VoterListMemberBean> membersToSave, List<String> listIdsToDelete, List<String> memberIdsToDelete, PollType pollType) throws InvalidFormException {
        PollType forcePollType;
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        PollType pollType2 = forcePollType = pollType != null ? pollType : poll.getPollType();
        if (forcePollType == PollType.RESTRICTED) {
            this.checkVoters(poll, listsToSave, membersToSave);
        }
        this.checkNotNull(listIdsToDelete);
        this.checkNotNull(memberIdsToDelete);
        LinkedList voterListToDelete = Lists.newLinkedList();
        for (String listIdToDelete : listIdsToDelete) {
            VoterList voterList = (VoterList)this.getVoterListDao().forTopiaIdEquals(listIdToDelete).findUnique();
            if (!voterList.getPoll().equals((Object)poll)) {
                throw new InvalidEntityLinkException("poll", (PollenEntity)voterList, (PollenEntity)poll);
            }
            voterListToDelete.add(voterList);
        }
        LinkedList voterListMemberToDelete = Lists.newLinkedList();
        for (String memberIdToDelete : memberIdsToDelete) {
            VoterListMember voterListMember = (VoterListMember)this.getVoterListMemberDao().forTopiaIdEquals(memberIdToDelete).findUnique();
            if (!voterListMember.getVoterList().getPoll().equals((Object)poll)) {
                throw new InvalidEntityLinkException("voterList.poll", (PollenEntity)voterListMember, (PollenEntity)poll);
            }
            voterListMemberToDelete.add(voterListMember);
        }
        this.createVoters(poll, listsToSave, membersToSave);
        for (VoterList voterList : voterListToDelete) {
            this.getVoterListDao().delete(voterList);
        }
        for (VoterListMember voterListMember : voterListMemberToDelete) {
            this.getVoterListMemberDao().delete(voterListMember);
        }
        this.commit();
    }

    protected void checkVoters(Poll poll, List<VoterListBean> listsToSave, List<VoterListMemberBean> membersToSave) throws InvalidFormException {
        this.checkNotNull(listsToSave);
        this.checkNotNull(membersToSave);
        HashMap listNameByParentId = Maps.newHashMap();
        Set idsToIgnore = listsToSave.stream().map(PollenBean::getEntityId).collect(Collectors.toSet());
        for (VoterListBean voterList : listsToSave) {
            List<VoterListMemberBean> members = membersToSave.stream().filter(member -> voterList.getId().equals(member.getVoterListId())).collect(Collectors.toList());
            List<VoterListBean> subLists = listsToSave.stream().filter(list -> voterList.getId().equals(list.getParentId())).collect(Collectors.toList());
            Set sisterNames = listNameByParentId.computeIfAbsent(voterList.getParentId(), parentId -> {
                if (poll == null || parentId.isNotEmpty() || parentId.isTemporaryId()) {
                    return Sets.newHashSet();
                }
                List<VoterList> existingVoterLists = this.getVoterLists0(poll, parentId.getEntityId());
                return existingVoterLists.stream().filter(voterList0 -> !idsToIgnore.contains(voterList0.getTopiaId())).map(VoterList::getName).collect(Collectors.toSet());
            });
            PollenErrors pollenErrors = this.checkVoterList(sisterNames, voterList, members, subLists);
            pollenErrors.failIfNotEmpty();
            sisterNames.add(voterList.getName());
        }
        HashMap listNamesEmailsByListId = Maps.newHashMap();
        for (VoterListMemberBean voterListMember : membersToSave) {
            if (voterListMember.getVoterListId().getEntityId() == null || voterListMember.getVoterListId().isTemporaryId()) continue;
            Pair brotherNamesEmails = listNamesEmailsByListId.computeIfAbsent(voterListMember.getVoterListId().getEntityId(), voterListId -> {
                List<VoterListMember> existingVoterListMembers = this.getVoterListMembers0((String)voterListId);
                Set names = existingVoterListMembers.stream().map(VoterListMember::getMember).map(PollenPrincipal::getName).collect(Collectors.toSet());
                Set emails = existingVoterListMembers.stream().map(VoterListMember::getMember).map(PollenPrincipal::getEmail).collect(Collectors.toSet());
                return Pair.of(names, emails);
            });
            Set brotherNames = (Set)brotherNamesEmails.getLeft();
            Set brotherEmails = (Set)brotherNamesEmails.getLeft();
            if (voterListMember.isPersisted() && poll != null) {
                VoterList voterList = this.getVoterList0(poll, voterListMember.getVoterListId().getEntityId());
                VoterListMember oldMember = this.getVoterListMember0(voterList, voterListMember.getEntityId());
                brotherNames.remove(oldMember.getMember().getName());
                brotherEmails.remove(oldMember.getMember().getEmail());
            }
            PollenErrors pollenErrors = this.checkVoterListMember(brotherNames, brotherEmails, voterListMember);
            pollenErrors.failIfNotEmpty();
            brotherNames.add(voterListMember.getName());
            brotherEmails.add(voterListMember.getEmail());
        }
    }

    protected void createVoters(Poll poll, List<VoterListBean> listsToSave, List<VoterListMemberBean> membersToSave) {
        Map voterListBeanByTempId = listsToSave.stream().filter(list -> list.getId().isEmpty() || list.isTemporaryId()).collect(Collectors.toMap(v -> v.getId().getReducedId(), Function.identity()));
        Set principalSentInvitation = this.getVoterListMemberDao().forVoterList_PollEqualsAndInvitationSent(poll).findAll().stream().map(VoterListMember::getMember).collect(Collectors.toSet());
        for (VoterListBean voterList : listsToSave) {
            if (voterList.getEntityId() == null || voterList.isTemporaryId()) {
                PollenEntityId<VoterList> parentId = voterList.getParentId();
                if (parentId.isNotEmpty() && parentId.isTemporaryId()) {
                    String parentIdString = ((VoterListBean)voterListBeanByTempId.get(parentId.getReducedId())).getEntityId();
                    voterList.getParentId().setEntityId(parentIdString);
                }
                voterList.setEntityId(null);
                VoterList voterListSaved = this.saveVoterList(poll, voterList);
                voterList.setEntityId(voterListSaved.getTopiaId());
                continue;
            }
            this.saveVoterList(poll, voterList);
        }
        for (VoterListMemberBean voterListMember : membersToSave) {
            if (!voterListMember.isPersisted()) {
                PollenEntityId<VoterList> voterListId = voterListMember.getVoterListId();
                if (voterListId.isEmpty() || voterListId.isTemporaryId()) {
                    String voterListIdString = ((VoterListBean)voterListBeanByTempId.get(voterListId.getReducedId())).getEntityId();
                    voterListMember.getVoterListId().setEntityId(voterListIdString);
                }
                voterListMember.setEntityId(null);
                VoterListMember voterListMemberSaved = this.saveVoterListMember(poll, voterListMember);
                voterListMember.setEntityId(voterListMemberSaved.getTopiaId());
                if (!principalSentInvitation.contains(voterListMemberSaved.getMember())) continue;
                voterListMemberSaved.setInvitationSent(true);
                continue;
            }
            this.saveVoterListMember(poll, voterListMember);
        }
    }

    public int sendInvitationVoterList(String pollId, String voterListId, boolean allMemberNoVoting) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        VoterList voterList = this.getVoterList0(poll, voterListId);
        List members = this.getVoterListDao().getAllMembers(voterList);
        return this.sendInvitation(poll, members, allMemberNoVoting);
    }

    public boolean sendInvitationMember(String pollId, String voterListId, String memberId, boolean allMemberNoVoting) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        VoterList voterList = this.getVoterList0(poll, voterListId);
        VoterListMember member = this.getVoterListMember0(voterList, memberId);
        return this.sendInvitation(poll, Collections.singletonList(member), allMemberNoVoting) == 1;
    }

    protected int sendInvitation(Poll poll, List<VoterListMember> members, boolean allMemberNoVoting) {
        List<Object> memberToSend;
        List<Question> questions = this.getQuestionService().getQuestions(poll);
        ArrayList votes = new ArrayList();
        for (Question question : questions) {
            List questionVotes = this.getVoteDao().forQuestionEquals(question).findAll();
            votes.addAll(questionVotes);
        }
        if (allMemberNoVoting) {
            Set memberVoting = votes.stream().map(Vote::getVoterListMember).flatMap(Collection::stream).collect(Collectors.toSet());
            memberToSend = members.stream().filter(member -> !memberVoting.contains(member)).collect(Collectors.toList());
        } else {
            memberToSend = members.stream().filter(member -> !member.isInvitationSent()).collect(Collectors.toList());
        }
        this.getNotificationService().sendInvitation(poll, memberToSend);
        List pollenPrincipals = memberToSend.stream().map(VoterListMember::getMember).collect(Collectors.toList());
        this.getVoterListMemberDao().forVoterList_PollEqualsAndMemberIn(poll, pollenPrincipals).findAll().forEach(m -> m.setInvitationSent(true));
        this.commit();
        return memberToSend.size();
    }

    public long getVoterListMemberCount(Poll poll) {
        return this.getVoterListMemberDao().countDistinctMembers(poll, false);
    }

    public long getVoterListMemberInvitedCount(Poll poll) {
        return this.getVoterListMemberDao().countDistinctMembers(poll, true);
    }

    public Set<String> getVoterListMemberMails(VoterList voterList) {
        List allMembers = this.getVoterListDao().getAllMembers(voterList);
        return allMembers.stream().map(VoterListMember::getMember).map(PollenPrincipal::getEmail).collect(Collectors.toSet());
    }
}

