/**
 * *##% Lima Neogia service
 * Copyright (C) 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
/**
 * # #% Copyright (C) 2008 Code Lutin, Tony Chemit 
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * # #%
 */
package org.chorem.lima.service.neogia;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.PeriodDTO;
import org.chorem.lima.dto.StatusDTO;
import org.chorem.lima.service.PeriodService;
import org.chorem.lima.service.neogia.util.NeogiaUtil;
import org.chorem.lima.service.util.ServiceHelper;
import org.ofbiz.webservice.proxies.GetAllPeriodResponseDocument;
import org.ofbiz.webservice.wrappers.xsd.GenericValueGlPeriod;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * @author chemit
 */
public class NeogiaPeriodService implements PeriodService {

    /**
     * log
     */
    protected static final Log log = LogFactory.getLog(NeogiaPeriodService.class);

    /**
     * Constructor
     */
    public NeogiaPeriodService() {
    }

    @Override
    public List<PeriodDTO> getAllPeriod(List<StatusDTO> status) {
        // Map of all objects
        Map<String, PeriodDTO> map = new HashMap<String, PeriodDTO>();
        // List of parents
        List<PeriodDTO> list = new LinkedList<PeriodDTO>();
        try {

            GetAllPeriodStub stub = new GetAllPeriodStub();
            GetAllPeriodResponseDocument response = stub.getAllPeriod();
            GenericValueGlPeriod[] array = response.getGetAllPeriodResponse().getReturnArray();

            for (GenericValueGlPeriod value : array) {
                PeriodDTO period = NeogiaUtil.mapToPeriodDTO(status, value);
                map.put(value.getIdNum(), period);

                // Do not has a parent
                if (period.getParent() == null) {
                    list.add(period);
                }
                // Look for parent
                if (map.containsKey(value.getParentPeriodIdNum())) {
                    PeriodDTO parent = map.get(value.getParentPeriodIdNum());
                    parent.addChild(period);
                }
            }
            return list;
        } catch (RemoteException ex) {
            log.error(ex);
            return null;
        }
    }

    /**
     * TODO
     * @param periodDTO
     * @return
     */
    @Override
    public String blockPeriod (PeriodDTO periodDTO,List<StatusDTO> status)
    {
        return ServiceHelper.RESPOND_SUCCESS;
    }

    /**
     * TODO
     * @param periodDTO
     * @return
     */
    @Override
    public String blockPeriodMonthly (PeriodDTO periodDTO,List<StatusDTO> status)
    {
        return ServiceHelper.RESPOND_SUCCESS;
    }

    /**
     * TODO
     * @param periodDTO
     * @return
     */
    @Override
    public String createPeriod (PeriodDTO periodDTO,List<StatusDTO> status)
    {
        return ServiceHelper.RESPOND_SUCCESS;
    }

    /**
     * TODO
     * @param periodDTO
     * @return
     */
    @Override
    public String unBlockPeriodMonthly (PeriodDTO periodDTO,List<StatusDTO> status)
    {
        return ServiceHelper.RESPOND_SUCCESS;
    }
}
