/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.service.neogia.util;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.AccountDTO;
import org.chorem.lima.dto.EntryDTO;
import org.chorem.lima.dto.JournalDTO;
import org.chorem.lima.dto.PeriodDTO;
import org.chorem.lima.dto.StatusDTO;
import org.chorem.lima.dto.TransactionDTO;
import org.chorem.lima.dto.util.DTOHelper;
import org.chorem.lima.service.util.ServiceHelper;
import org.ofbiz.webservice.wrappers.xsd.GenericValueAcctgTransactionItemAndGlPeriod;
import org.ofbiz.webservice.wrappers.xsd.GenericValueAcctgTransactionType;
import org.ofbiz.webservice.wrappers.xsd.GenericValueGlEntryAndGlEntryAccount;
import org.ofbiz.webservice.wrappers.xsd.GenericValueGlPeriod;
import org.ofbiz.webservice.wrappers.xsd.GenericValueStatusItem;

public class NeogiaUtil {
    private static final Log log = LogFactory.getLog(NeogiaUtil.class);
    private static final String ATS_WIP = "ATS_WIP";
    private static final String ATS_BALANCED = "ATS_BALANCED";
    private static final String ATS_FINALIZED = "ATS_FINALIZED";
    private static final String PS_OPEN = "PS_OPEN";
    private static final String PS_CLOSETMP = "PS_CLOSETMP";
    private static final String PS_CLOSE = "PS_CLOSE";

    public static StatusDTO mapToStatusDTO(GenericValueStatusItem value) {
        return new StatusDTO(value.getStatusId(), NeogiaUtil.findStatusType(value.getStatusId()), value.getDescription());
    }

    public static String findStatusType(String id) {
        if (id.equals(ATS_WIP)) {
            return "TR_WIP";
        }
        if (id.equals(ATS_BALANCED)) {
            return "TR_BALANCED";
        }
        if (id.equals(ATS_FINALIZED)) {
            return "TR_FINALIZED";
        }
        if (id.equals(PS_OPEN)) {
            return "PE_OPEN";
        }
        if (id.equals(PS_CLOSETMP)) {
            return "PE_CLOSETMP";
        }
        if (id.equals(PS_CLOSE)) {
            return "PE_CLOSE";
        }
        log.warn((Object)"Can't find status type of StatusDTO");
        return null;
    }

    public static TransactionDTO mapToTransactionDTO(GenericValueAcctgTransactionItemAndGlPeriod value, List<PeriodDTO> periods, List<JournalDTO> journals, List<StatusDTO> status) {
        return new TransactionDTO(value.getSequenceId(), value.getAtranIdName(), value.getEntryDate() != null ? value.getEntryDate().getTime() : null, value.getVoucherRef(), value.getDescription(), ServiceHelper.findJournalById(journals, (String)value.getAtrnstypIdName()), new LinkedList(), ServiceHelper.findPeriodById(periods, (String)value.getIdNum()), ServiceHelper.findStatusById(status, (String)value.getVoucherContentId()));
    }

    public static JournalDTO mapToJournalDTO(GenericValueAcctgTransactionType value) {
        return new JournalDTO("0", value.getIdName(), value.getDescription(), value.getAentfrmEnumId());
    }

    public static Long getLowLevelCode(AccountDTO account) {
        return new Long(NeogiaUtil.getParentsCount(account) - 1);
    }

    public static PeriodDTO mapToPeriodDTO(List<StatusDTO> status, GenericValueGlPeriod value) {
        return new PeriodDTO(value.getIdNum(), value.getIdName(), value.getFromDate().getTime(), value.getThruDate().getTime(), value.getParentPeriodIdNum() == null ? new LinkedList() : null, value.getParentPeriodIdNum() == null ? null : new PeriodDTO(value.getParentPeriodIdNum(), null, null, null, null, null, null), ServiceHelper.findStatusById(status, (String)value.getPeriodStatusStatusId()));
    }

    private static int getParentsCount(AccountDTO account) {
        if (account.getParent() == null) {
            return 0;
        }
        return 1 + NeogiaUtil.getParentsCount(account.getParent());
    }

    public static String getTreePath(AccountDTO account) {
        List<String> pathList = NeogiaUtil.getPathList(account);
        String res = "GL_STD_ROLLUP#";
        for (int i = 0; i < pathList.size(); ++i) {
            String s = pathList.get(i);
            if (s.equals("0")) continue;
            if (i != 0) {
                res = res + "|";
            }
            res = res + s;
        }
        res = res + "#";
        return res;
    }

    private static List<String> getPathList(AccountDTO account) {
        LinkedList<String> list = new LinkedList<String>();
        NeogiaUtil.getPathListRec(account.getParent(), list);
        return list;
    }

    private static void getPathListRec(AccountDTO account, List<String> list) {
        if (account.getParent() != null) {
            list.add(account.getIdNumber());
            NeogiaUtil.getPathListRec(account.getParent(), list);
        }
    }

    public static EntryDTO mapToEntryDTO(GenericValueGlEntryAndGlEntryAccount value, List<AccountDTO> accounts) {
        return new EntryDTO(String.valueOf(value.getSequenceId()), value.getDescription(), DTOHelper.format((double)value.getAmount()), value.getDebitCreditEnumId().equals("DEBIT"), null, ServiceHelper.findAccountById(accounts, (String)value.getAccountAccount()), null, null);
    }
}

