/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.service.neogia;

import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JProgressBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.AccountDTO;
import org.chorem.lima.dto.EntryDTO;
import org.chorem.lima.dto.JournalDTO;
import org.chorem.lima.dto.PeriodDTO;
import org.chorem.lima.dto.StatusDTO;
import org.chorem.lima.dto.TransactionDTO;
import org.chorem.lima.service.EntryService;
import org.chorem.lima.service.ServiceFactory;
import org.chorem.lima.service.TransactionService;
import org.chorem.lima.service.neogia.AddTransactionStub;
import org.chorem.lima.service.neogia.GetAllTransactionStub;
import org.chorem.lima.service.neogia.NeogiaPeriodService;
import org.chorem.lima.service.neogia.RemoveTransactionStub;
import org.chorem.lima.service.neogia.UpdateTransactionStub;
import org.chorem.lima.service.neogia.util.NeogiaUtil;
import org.chorem.lima.service.util.ServiceHelper;
import org.ofbiz.webservice.proxies.AddTransactionDocument;
import org.ofbiz.webservice.proxies.AddTransactionResponseDocument;
import org.ofbiz.webservice.proxies.GetAllTransactionResponseDocument;
import org.ofbiz.webservice.proxies.RemoveTransactionDocument;
import org.ofbiz.webservice.proxies.UpdateTransactionDocument;
import org.ofbiz.webservice.proxies.UpdateTransactionResponseDocument;
import org.ofbiz.webservice.wrappers.xsd.GenericValueAcctgTransactionItem;
import org.ofbiz.webservice.wrappers.xsd.GenericValueAcctgTransactionItemAndGlPeriod;

public class NeogiaTransactionService
implements TransactionService {
    protected static final Log log = LogFactory.getLog(NeogiaPeriodService.class);

    public List<TransactionDTO> getAllTransaction(List<PeriodDTO> periods, List<JournalDTO> journals, List<AccountDTO> accounts, List<StatusDTO> status) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllTransaction : ");
        }
        try {
            GenericValueAcctgTransactionItemAndGlPeriod[] array;
            LinkedList<TransactionDTO> list = new LinkedList<TransactionDTO>();
            ServiceFactory neogiaFactory = ServiceFactory.getServiceFactory();
            EntryService entryServ = neogiaFactory.getEntryService();
            GetAllTransactionStub stub = new GetAllTransactionStub();
            GetAllTransactionResponseDocument response = stub.getAllTransaction();
            for (GenericValueAcctgTransactionItemAndGlPeriod value : array = response.getGetAllTransactionResponse().getReturnArray()) {
                TransactionDTO trans = NeogiaUtil.mapToTransactionDTO(value, periods, journals, status);
                List entries = entryServ.getEntryByTransaction(trans, accounts);
                for (EntryDTO entry : entries) {
                    trans.addChild(entry);
                }
                list.add(trans);
            }
            return list;
        }
        catch (RemoteException ex) {
            log.error((Object)ex);
            return null;
        }
    }

    public List<TransactionDTO> getAllTransaction(List<PeriodDTO> periods, List<JournalDTO> journals, List<AccountDTO> accounts, List<StatusDTO> status, JProgressBar barre) {
        return this.getAllTransaction(periods, journals, accounts, status);
    }

    public String removeTransaction(TransactionDTO trans, List<StatusDTO> status) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeTransaction : ");
        }
        for (EntryDTO entry : trans.getEntries()) {
            String response = ServiceFactory.getServiceFactory().getEntryService().removeEntry(null, entry);
            if ("success".equals(response)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Entry removed : " + entry.getIdSeq()));
                continue;
            }
            if (log.isErrorEnabled()) {
                log.error((Object)("Entry can't be removed : " + entry.getIdSeq()));
            }
            return "error";
        }
        try {
            RemoveTransactionStub stub = new RemoveTransactionStub();
            RemoveTransactionDocument document = RemoveTransactionDocument.Factory.newInstance();
            RemoveTransactionDocument.RemoveTransaction element = RemoveTransactionDocument.RemoveTransaction.Factory.newInstance();
            element.setAtranIdName(trans.getIdName());
            element.setSequenceId(trans.getIdSeq());
            element.setIdNumPeriod(trans.getPeriod().getIdSeq());
            document.setRemoveTransaction(element);
            stub.removeTransaction(document);
            return "success";
        }
        catch (RemoteException ex) {
            log.error((Object)ex);
            return "error";
        }
    }

    public String updateTransaction(List<StatusDTO> list, TransactionDTO oldTrans, TransactionDTO newTrans) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateTransaction : ");
        }
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(newTrans.getEntryDate());
            UpdateTransactionStub stub = new UpdateTransactionStub();
            UpdateTransactionDocument document = UpdateTransactionDocument.Factory.newInstance();
            UpdateTransactionDocument.UpdateTransaction element = UpdateTransactionDocument.UpdateTransaction.Factory.newInstance();
            element.setAtranIdName(newTrans.getIdName());
            element.setSequenceId(newTrans.getIdSeq());
            element.setDescription(newTrans.getDescription());
            element.setEntryDate(cal);
            element.setAtrnstypIdName(newTrans.getJournal().getIdName());
            element.setVoucherRef(newTrans.getVoucherRef());
            if (newTrans.getPeriod() != oldTrans.getPeriod()) {
                element.setIdNumPeriod(oldTrans.getPeriod().getIdSeq());
                element.setNewIdNumPeriod(newTrans.getPeriod().getIdSeq());
            }
            document.setUpdateTransaction(element);
            UpdateTransactionResponseDocument response = stub.updateTransaction(document);
            String status = response.getUpdateTransactionResponse().getReturn();
            newTrans.setStatus(ServiceHelper.findStatusById(list, (String)status));
            return "success";
        }
        catch (RemoteException ex) {
            log.error((Object)ex);
            return "error";
        }
    }

    public String addTransaction(TransactionDTO trans, List<StatusDTO> status) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"addTransaction : ");
            }
            AddTransactionStub stub = new AddTransactionStub();
            AddTransactionDocument document = AddTransactionDocument.Factory.newInstance();
            AddTransactionDocument.AddTransaction element = AddTransactionDocument.AddTransaction.Factory.newInstance();
            element.setIdNumPeriod(trans.getPeriod().getIdSeq());
            Calendar cal = Calendar.getInstance();
            cal.setTime(trans.getEntryDate());
            element.setEntryDate(cal);
            element.setAtrnstypIdName(trans.getJournal().getIdName());
            document.setAddTransaction(element);
            AddTransactionResponseDocument response = stub.addTransaction(document);
            GenericValueAcctgTransactionItem value = response.getAddTransactionResponse().getReturn();
            trans.setIdName(value.getAtranIdName());
            trans.setIdSeq(value.getSequenceId());
            return "success";
        }
        catch (RemoteException ex) {
            log.error((Object)ex);
            return "error";
        }
    }
}

