/**
 * *##% Lima Neogia service
 * Copyright (C) 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
/**
 * # #% Copyright (C) 2008 Code Lutin, Tony Chemit 
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * # #%
 */
package org.chorem.lima.service.neogia;

import org.chorem.lima.service.AccountService;
import java.rmi.RemoteException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.AccountDTO;

import org.chorem.lima.service.neogia.parser.NGLAccountToAccountDTO;
import org.chorem.lima.service.neogia.util.NeogiaUtil;
import org.chorem.lima.service.util.ServiceHelper;
import org.ofbiz.webservice.proxies.AddAccountDocument;
import org.ofbiz.webservice.proxies.AddAccountDocument.AddAccount;
import org.ofbiz.webservice.proxies.GetAllAccountResponseDocument;
import org.ofbiz.webservice.proxies.RemoveAccountDocument;
import org.ofbiz.webservice.proxies.RemoveAccountDocument.RemoveAccount;
import org.ofbiz.webservice.proxies.UpdateAccountDocument;
import org.ofbiz.webservice.proxies.UpdateAccountDocument.UpdateAccount;
import org.ofbiz.webservice.wrappers.xsd.GenericValueNGlAccount;

/** @author chemit */
public class NeogiaAccountService implements AccountService {

    /** log */
    protected static final Log log = LogFactory.getLog(NeogiaAccountService.class);

    @Override
    public AccountDTO getAllAccount() {
        try {
            GetAllAccountStub stub = new GetAllAccountStub();
            GetAllAccountResponseDocument response = stub.getAllAccount();
            GenericValueNGlAccount[] array = response.getGetAllAccountResponse().getReturnArray();
            return new NGLAccountToAccountDTO().loadArray(array);
        } catch (RemoteException ex) {
            log.fatal("Can't get all accounts.", ex);
            return null;
        }
    }

    @Override
    public String addAccount(AccountDTO account) {
        try {
            if (log.isDebugEnabled()) {
                log.info("addAccount : ");
            }
            AddAccountStub stub = new AddAccountStub();
            AddAccountDocument document = AddAccountDocument.Factory.newInstance();
            AddAccount element = AddAccount.Factory.newInstance();
            element.setIdNumber(account.getIdNumber());
            element.setDescription(account.getDescription());
            element.setLowLevelCode(NeogiaUtil.getLowLevelCode(account));
            element.setTreePath(NeogiaUtil.getTreePath(account));
            document.setAddAccount(element);

            stub.addAccount(document);

            return ServiceHelper.RESPOND_SUCCESS;
        } catch (RemoteException ex) {
            log.fatal("Can't add an account.", ex);
            return ServiceHelper.RESPOND_ERROR;
        }
    }

    @Override
    public String updateAccount(AccountDTO account) {
        try {
            if (log.isDebugEnabled()) {
                log.info("updateAccount : ");
            }
            UpdateAccountStub stub = new UpdateAccountStub();
            UpdateAccountDocument document = UpdateAccountDocument.Factory.newInstance();
            UpdateAccount element = UpdateAccount.Factory.newInstance();
            element.setIdNumber(account.getIdNumber());
            element.setDescription(account.getDescription());
            document.setUpdateAccount(element);

            stub.updateAccount(document);

            if (log.isDebugEnabled()) {
                log.debug("account " + account.getIdNumber() + " updated");
            }
            return ServiceHelper.RESPOND_SUCCESS;
        } catch (RemoteException ex) {
            log.fatal("Can't update an account.", ex);
            return ServiceHelper.RESPOND_ERROR;
        }
    }

    @Override
    public String removeAccount(AccountDTO account) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("removeAccount : ");
            }
            RemoveAccountStub stub = new RemoveAccountStub();
            RemoveAccountDocument document = RemoveAccountDocument.Factory.newInstance();
            RemoveAccount element = RemoveAccount.Factory.newInstance();
            element.setAccount(account.getIdNumber());
            document.setRemoveAccount(element);

            stub.removeAccount(document);

            if (log.isDebugEnabled()) {
                log.debug("account " + account.getIdNumber() + " removed");
            }
            return ServiceHelper.RESPOND_SUCCESS;
        } catch (RemoteException ex) {
            log.fatal("Can't remove an account.", ex);
            return ServiceHelper.RESPOND_ERROR;
        }
    }
}
