/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;

import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={"label","accountNumber","type"}
)        
public interface Account extends TopiaEntity {

    public static final String LABEL = "label";

    public static final String ACCOUNT_NUMBER = "accountNumber";

    public static final String TYPE = "type";

    public static final String ENTRY = "entry";

    public static final String MASTER_ACCOUNT = "masterAccount";

    public static final String SUB_ACCOUNT = "subAccount";

    /**
     * @param label La valeur de l'attribut label à positionner.
     */
    public void setLabel(java.lang.String label);

    /**
     * @return La valeur de l'attribut label.
     */
    public java.lang.String getLabel();

    /**
     * @param accountNumber La valeur de l'attribut accountNumber à positionner.
     */
    public void setAccountNumber(java.lang.String accountNumber);

    /**
     * @return La valeur de l'attribut accountNumber.
     */
    public java.lang.String getAccountNumber();

    /**
     * @param type La valeur de l'attribut type à positionner.
     */
    public void setType(java.lang.String type);

    /**
     * @return La valeur de l'attribut type.
     */
    public java.lang.String getType();

    /**
     * @param entry L'instance de entry à ajouter.
     */
    public void addEntry(org.chorem.callao.entity.Entry entry);

    /**
     * @param entry Les instances de entry à ajouter.
     */
    public void addAllEntry(java.util.Collection<org.chorem.callao.entity.Entry> entry);

    /**
     * @param entry La Collection de entry à positionner.
     */
    public void setEntry(java.util.Collection<org.chorem.callao.entity.Entry> entry);

    /**
     * @param entry L'instance de entry à retirer.
     */
    public void removeEntry(org.chorem.callao.entity.Entry entry);

    /**
     * Vide la Collection de entry.
     */
    public void clearEntry();

    /**
     * @return La Liste de entry.
     */
    public java.util.Collection<org.chorem.callao.entity.Entry> getEntry();


    /**
     * Recupère l'attribut entry à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.callao.entity.Entry getEntryByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection entry.
     */
    public int sizeEntry();

    /**
     * @return <code>true</code> si la collection entry est vide.
     */
    public boolean isEntryEmpty();

    /**
     * @param masterAccount La valeur de l'attribut masterAccount à positionner.
     */
    public void setMasterAccount(org.chorem.callao.entity.Account masterAccount);

    /**
     * @return La valeur de l'attribut masterAccount.
     */
    public org.chorem.callao.entity.Account getMasterAccount();

    /**
     * @param subAccount L'instance de subAccount à ajouter.
     */
    public void addSubAccount(org.chorem.callao.entity.Account subAccount);

    /**
     * @param subAccount Les instances de subAccount à ajouter.
     */
    public void addAllSubAccount(java.util.Collection<org.chorem.callao.entity.Account> subAccount);

    /**
     * @param subAccount La Collection de subAccount à positionner.
     */
    public void setSubAccount(java.util.Collection<org.chorem.callao.entity.Account> subAccount);

    /**
     * @param subAccount L'instance de subAccount à retirer.
     */
    public void removeSubAccount(org.chorem.callao.entity.Account subAccount);

    /**
     * Vide la Collection de subAccount.
     */
    public void clearSubAccount();

    /**
     * @return La Liste de subAccount.
     */
    public java.util.Collection<org.chorem.callao.entity.Account> getSubAccount();


    /**
     * Recupère l'attribut subAccount à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.callao.entity.Account getSubAccountByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection subAccount.
     */
    public int sizeSubAccount();

    /**
     * @return <code>true</code> si la collection subAccount est vide.
     */
    public boolean isSubAccountEmpty();

} //Account
