/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité Transaction.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class TransactionDAOAbstract<E extends Transaction> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)Transaction.class;
    }

    public void delete(E entity) throws TopiaException {

                {
                List<org.chorem.callao.entity.Entry> list = getContext()
                            .getDAO(org.chorem.callao.entity.Entry.class)
                            .findAllByProperties("transaction", entity);
                    for (org.chorem.callao.entity.Entry item : list) {
                        item.setTransaction(null);

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut transDate
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * transDate le paramètre
     * @param v la valeur que doit avoir transDate
     * @return un element ou null
     */
    public E findByTransDate(java.util.Date v) throws TopiaException {
        E result = findByProperty("transDate", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * transDate le paramètre
     * @param v la valeur que doit avoir transDate
     * @return une liste
     */
    public List<E> findAllByTransDate(java.util.Date v) throws TopiaException {
        List<E> result = findAllByProperty("transDate", v);
        return result;
    }
    /**
     * Recherche sur l'attribut voucherRef
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * voucherRef le paramètre
     * @param v la valeur que doit avoir voucherRef
     * @return un element ou null
     */
    public E findByVoucherRef(java.lang.String v) throws TopiaException {
        E result = findByProperty("voucherRef", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * voucherRef le paramètre
     * @param v la valeur que doit avoir voucherRef
     * @return une liste
     */
    public List<E> findAllByVoucherRef(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("voucherRef", v);
        return result;
    }
    /**
     * Recherche sur l'attribut description
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * description le paramètre
     * @param v la valeur que doit avoir description
     * @return un element ou null
     */
    public E findByDescription(java.lang.String v) throws TopiaException {
        E result = findByProperty("description", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * description le paramètre
     * @param v la valeur que doit avoir description
     * @return une liste
     */
    public List<E> findAllByDescription(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("description", v);
        return result;
    }
    /**
     * Recherche sur l'attribut timeSpan
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * timeSpan le paramètre
     * @param v la valeur que doit avoir timeSpan
     * @return un element ou null
     */
    public E findByTimeSpan(org.chorem.callao.entity.TimeSpan v) throws TopiaException {
        E result = findByProperty("timeSpan", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * timeSpan le paramètre
     * @param v la valeur que doit avoir timeSpan
     * @return une liste
     */
    public List<E> findAllByTimeSpan(org.chorem.callao.entity.TimeSpan v) throws TopiaException {
        List<E> result = findAllByProperty("timeSpan", v);
        return result;
    }
    /**
     * Recherche sur l'attribut journal
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * journal le paramètre
     * @param v la valeur que doit avoir journal
     * @return un element ou null
     */
    public E findByJournal(org.chorem.callao.entity.Journal v) throws TopiaException {
        E result = findByProperty("journal", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * journal le paramètre
     * @param v la valeur que doit avoir journal
     * @return une liste
     */
    public List<E> findAllByJournal(org.chorem.callao.entity.Journal v) throws TopiaException {
        List<E> result = findAllByProperty("journal", v);
        return result;
    }
    /**
     * Recherche sur l'attribut entry
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * entry contient le paramètre
     * @param v la valeur que doit contenir entry
     * @return un element ou null
     */
    public E findContainsEntry(org.chorem.callao.entity.Entry ... v) throws TopiaException {
        E result = findContainsProperties("entry", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * entry contient le paramètre
     * @param v la valeur que doit contenir entry
     * @return une liste
     */
    public List<E> findAllContainsEntry(org.chorem.callao.entity.Entry ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("entry", Arrays.asList(v));
        return results;
    }

} // TransactionDAOAbstract
