/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;

public class CallaoDAOHelper {

    /**
     * no instance for this helper
     */
    protected CallaoDAOHelper() {
    }

    public static AccountDAO getAccountDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        AccountDAO result = (AccountDAO) ci.getDAO(Account.class);
        return result;
    }

    public static CallaoUserDAO getCallaoUserDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CallaoUserDAO result = (CallaoUserDAO) ci.getDAO(CallaoUser.class);
        return result;
    }

    public static ClientDAO getClientDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ClientDAO result = (ClientDAO) ci.getDAO(Client.class);
        return result;
    }

    public static EntryDAO getEntryDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        EntryDAO result = (EntryDAO) ci.getDAO(Entry.class);
        return result;
    }

    public static JournalDAO getJournalDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        JournalDAO result = (JournalDAO) ci.getDAO(Journal.class);
        return result;
    }

    public static LogDAO getLogDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        LogDAO result = (LogDAO) ci.getDAO(Log.class);
        return result;
    }

    public static PeriodDAO getPeriodDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PeriodDAO result = (PeriodDAO) ci.getDAO(Period.class);
        return result;
    }

    public static ProjectDAO getProjectDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ProjectDAO result = (ProjectDAO) ci.getDAO(Project.class);
        return result;
    }

    public static TaxDAO getTaxDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TaxDAO result = (TaxDAO) ci.getDAO(Tax.class);
        return result;
    }

    public static TimeSpanDAO getTimeSpanDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TimeSpanDAO result = (TimeSpanDAO) ci.getDAO(TimeSpan.class);
        return result;
    }

    public static TransactionDAO getTransactionDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TransactionDAO result = (TransactionDAO) ci.getDAO(Transaction.class);
        return result;
    }

    public static TypePrestaDAO getTypePrestaDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TypePrestaDAO result = (TypePrestaDAO) ci.getDAO(TypePresta.class);
        return result;
    }

    public static UsersDAO getUsersDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        UsersDAO result = (UsersDAO) ci.getDAO(Users.class);
        return result;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CallaoEntityEnum constant = CallaoEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CallaoEntityEnum constant = CallaoEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        CallaoEntityEnum constant = CallaoEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        CallaoEntityEnum constant = CallaoEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }

    @SuppressWarnings({"unchecked"})
    public static Class<? extends TopiaEntity>[] getContractClasses() {
        CallaoEntityEnum[] values = CallaoEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    @SuppressWarnings({"unchecked"})
    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        CallaoEntityEnum[] values = CallaoEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static CallaoEntityEnum[] getContracts() {
        return CallaoEntityEnum.values();
    }
 
    /*
     * Enumeration of all types of entities managed by this helper.
     */
    public enum CallaoEntityEnum implements org.nuiton.topia.persistence.TopiaEntityEnum {

        Account(Account.class),
        CallaoUser(CallaoUser.class),
        Client(Client.class),
        Entry(Entry.class),
        Journal(Journal.class),
        Log(Log.class),
        Period(Period.class),
        Project(Project.class),
        Tax(Tax.class),
        TimeSpan(TimeSpan.class),
        Transaction(Transaction.class),
        TypePresta(TypePresta.class),
        Users(Users.class);

        /** the contract of the entity */
        private Class<? extends TopiaEntity> contract;

        /** the fully qualified name of the implementation of the entity */
        private String implementationFQN;

        /** the implementation class of the entity (will be lazy computed at runtime)*/
        private Class<? extends TopiaEntity> implementation;

        CallaoEntityEnum(Class<? extends TopiaEntity > contract) {
            this.contract = contract;
            this.implementationFQN = contract.getName()+"Impl";
        }

        @Override
        public Class<? extends TopiaEntity> getContract() {
            return contract;
        }
       
        @Deprecated
        public Class<? extends TopiaEntity> getContractClass() {
            return getContract();
        }
        
        @Deprecated
        public Class<? extends TopiaEntity> getImplementationClass() {
            return getImplementation();
        }

        @Override
        public String getImplementationFQN() {
            return implementationFQN;
        }

        @Override
        public synchronized void setImplementationFQN(String implementationFQN) {
            this.implementationFQN = implementationFQN;
            this.implementation = null;
         }

        @Override
        public boolean accept(Class<? extends TopiaEntity> klass) {
            return CallaoDAOHelper.getContractClass(klass) == contract;
        }
 
        @Override
        @SuppressWarnings({"unchecked"})
        public Class<? extends TopiaEntity> getImplementation() {
            if (implementation == null) {
                try {
                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
                } catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + implementationFQN);
                }
            }
            return implementation;
        }

        public static CallaoEntityEnum valueOf(TopiaEntity entity) {
            return valueOf(entity.getClass());
        }

        public static CallaoEntityEnum valueOf(Class<?> klass) {
            if (klass.isInterface()) {
                return CallaoEntityEnum.valueOf(klass.getSimpleName());
            }
            for (CallaoEntityEnum entityEnum : CallaoEntityEnum.values()) {
                if (entityEnum.getContract().isAssignableFrom(klass)) {
                    //todo check it works for inheritance
                    return entityEnum;
                }
            }
            throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(CallaoEntityEnum.values()));
        }        
    }

    /**
     * use {@link #getImplementationClassesAsString()}
     *
     * @deprecated (will be removed soon).
     */
    public static final String entitiesList = "" +
        "org.chorem.callao.entity.AccountImpl," +
        "org.chorem.callao.entity.CallaoUserImpl," +
        "org.chorem.callao.entity.ClientImpl," +
        "org.chorem.callao.entity.EntryImpl," +
        "org.chorem.callao.entity.JournalImpl," +
        "org.chorem.callao.entity.LogImpl," +
        "org.chorem.callao.entity.PeriodImpl," +
        "org.chorem.callao.entity.ProjectImpl," +
        "org.chorem.callao.entity.TaxImpl," +
        "org.chorem.callao.entity.TimeSpanImpl," +
        "org.chorem.callao.entity.TransactionImpl," +
        "org.chorem.callao.entity.TypePrestaImpl," +
        "org.chorem.callao.entity.UsersImpl";

} //CallaoDAOHelper
