/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.entity;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.chorem.callao.entity.Account;
import org.chorem.callao.entity.AccountDAO;
import org.chorem.callao.entity.CallaoUser;
import org.chorem.callao.entity.CallaoUserDAO;
import org.chorem.callao.entity.Client;
import org.chorem.callao.entity.ClientDAO;
import org.chorem.callao.entity.Entry;
import org.chorem.callao.entity.EntryDAO;
import org.chorem.callao.entity.Journal;
import org.chorem.callao.entity.JournalDAO;
import org.chorem.callao.entity.Log;
import org.chorem.callao.entity.LogDAO;
import org.chorem.callao.entity.Period;
import org.chorem.callao.entity.PeriodDAO;
import org.chorem.callao.entity.Project;
import org.chorem.callao.entity.ProjectDAO;
import org.chorem.callao.entity.Tax;
import org.chorem.callao.entity.TaxDAO;
import org.chorem.callao.entity.TimeSpan;
import org.chorem.callao.entity.TimeSpanDAO;
import org.chorem.callao.entity.Transaction;
import org.chorem.callao.entity.TransactionDAO;
import org.chorem.callao.entity.TypePresta;
import org.chorem.callao.entity.TypePrestaDAO;
import org.chorem.callao.entity.Users;
import org.chorem.callao.entity.UsersDAO;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;

public class CallaoDAOHelper {
    public static final String entitiesList = "org.chorem.callao.entity.AccountImpl,org.chorem.callao.entity.CallaoUserImpl,org.chorem.callao.entity.ClientImpl,org.chorem.callao.entity.EntryImpl,org.chorem.callao.entity.JournalImpl,org.chorem.callao.entity.LogImpl,org.chorem.callao.entity.PeriodImpl,org.chorem.callao.entity.ProjectImpl,org.chorem.callao.entity.TaxImpl,org.chorem.callao.entity.TimeSpanImpl,org.chorem.callao.entity.TransactionImpl,org.chorem.callao.entity.TypePrestaImpl,org.chorem.callao.entity.UsersImpl";

    protected CallaoDAOHelper() {
    }

    public static AccountDAO getAccountDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        AccountDAO result = (AccountDAO)ci.getDAO(Account.class);
        return result;
    }

    public static CallaoUserDAO getCallaoUserDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        CallaoUserDAO result = (CallaoUserDAO)ci.getDAO(CallaoUser.class);
        return result;
    }

    public static ClientDAO getClientDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        ClientDAO result = (ClientDAO)ci.getDAO(Client.class);
        return result;
    }

    public static EntryDAO getEntryDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        EntryDAO result = (EntryDAO)ci.getDAO(Entry.class);
        return result;
    }

    public static JournalDAO getJournalDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        JournalDAO result = (JournalDAO)ci.getDAO(Journal.class);
        return result;
    }

    public static LogDAO getLogDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        LogDAO result = (LogDAO)ci.getDAO(Log.class);
        return result;
    }

    public static PeriodDAO getPeriodDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        PeriodDAO result = (PeriodDAO)ci.getDAO(Period.class);
        return result;
    }

    public static ProjectDAO getProjectDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        ProjectDAO result = (ProjectDAO)ci.getDAO(Project.class);
        return result;
    }

    public static TaxDAO getTaxDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        TaxDAO result = (TaxDAO)ci.getDAO(Tax.class);
        return result;
    }

    public static TimeSpanDAO getTimeSpanDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        TimeSpanDAO result = (TimeSpanDAO)ci.getDAO(TimeSpan.class);
        return result;
    }

    public static TransactionDAO getTransactionDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        TransactionDAO result = (TransactionDAO)ci.getDAO(Transaction.class);
        return result;
    }

    public static TypePrestaDAO getTypePrestaDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        TypePrestaDAO result = (TypePrestaDAO)ci.getDAO(TypePresta.class);
        return result;
    }

    public static UsersDAO getUsersDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        UsersDAO result = (UsersDAO)ci.getDAO(Users.class);
        return result;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        CallaoEntityEnum constant = CallaoEntityEnum.valueOf(klass);
        TopiaDAO dao = ci.getDAO(constant.getContract());
        return (D)dao;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        CallaoEntityEnum constant = CallaoEntityEnum.valueOf(entity);
        TopiaDAO dao = ci.getDAO(constant.getContract());
        return (D)dao;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        CallaoEntityEnum constant = CallaoEntityEnum.valueOf(klass);
        return constant.getContract();
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        CallaoEntityEnum constant = CallaoEntityEnum.valueOf(klass);
        return constant.getImplementation();
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        CallaoEntityEnum[] values = CallaoEntityEnum.values();
        Class[] result = (Class[])Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        CallaoEntityEnum[] values = CallaoEntityEnum.values();
        Class[] result = (Class[])Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : CallaoDAOHelper.getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static CallaoEntityEnum[] getContracts() {
        return CallaoEntityEnum.values();
    }

    public static enum CallaoEntityEnum implements TopiaEntityEnum
    {
        Account(Account.class),
        CallaoUser(CallaoUser.class),
        Client(Client.class),
        Entry(Entry.class),
        Journal(Journal.class),
        Log(Log.class),
        Period(Period.class),
        Project(Project.class),
        Tax(Tax.class),
        TimeSpan(TimeSpan.class),
        Transaction(Transaction.class),
        TypePresta(TypePresta.class),
        Users(Users.class);

        private Class<? extends TopiaEntity> contract;
        private String implementationFQN;
        private Class<? extends TopiaEntity> implementation;

        private CallaoEntityEnum(Class<? extends TopiaEntity> contract) {
            this.contract = contract;
            this.implementationFQN = contract.getName() + "Impl";
        }

        public Class<? extends TopiaEntity> getContract() {
            return this.contract;
        }

        @Deprecated
        public Class<? extends TopiaEntity> getContractClass() {
            return this.getContract();
        }

        @Deprecated
        public Class<? extends TopiaEntity> getImplementationClass() {
            return this.getImplementation();
        }

        public String getImplementationFQN() {
            return this.implementationFQN;
        }

        public synchronized void setImplementationFQN(String implementationFQN) {
            this.implementationFQN = implementationFQN;
            this.implementation = null;
        }

        public boolean accept(Class<? extends TopiaEntity> klass) {
            return CallaoDAOHelper.getContractClass(klass) == this.contract;
        }

        public Class<? extends TopiaEntity> getImplementation() {
            if (this.implementation == null) {
                try {
                    this.implementation = Class.forName(this.implementationFQN);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + this.implementationFQN);
                }
            }
            return this.implementation;
        }

        public static CallaoEntityEnum valueOf(TopiaEntity entity) {
            return CallaoEntityEnum.valueOf(entity.getClass());
        }

        public static CallaoEntityEnum valueOf(Class<?> klass) {
            if (klass.isInterface()) {
                return CallaoEntityEnum.valueOf(klass.getSimpleName());
            }
            for (CallaoEntityEnum entityEnum : CallaoEntityEnum.values()) {
                if (!entityEnum.getContract().isAssignableFrom(klass)) continue;
                return entityEnum;
            }
            throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString((Object[])CallaoEntityEnum.values()));
        }
    }
}

