/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité Entry.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class EntryDAOAbstract<E extends Entry> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)Entry.class;
    }

    public void delete(E entity) throws TopiaException {

                {
                List<org.chorem.callao.entity.Log> list = getContext()
                            .getDAO(org.chorem.callao.entity.Log.class)
                            .findAllByProperties("entry", entity);
                    for (org.chorem.callao.entity.Log item : list) {
                        item.setEntry(null);

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut description
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * description le paramètre
     * @param v la valeur que doit avoir description
     * @return un element ou null
     */
    public E findByDescription(java.lang.String v) throws TopiaException {
        E result = findByProperty("description", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * description le paramètre
     * @param v la valeur que doit avoir description
     * @return une liste
     */
    public List<E> findAllByDescription(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("description", v);
        return result;
    }
    /**
     * Recherche sur l'attribut amount
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * amount le paramètre
     * @param v la valeur que doit avoir amount
     * @return un element ou null
     */
    public E findByAmount(java.lang.String v) throws TopiaException {
        E result = findByProperty("amount", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * amount le paramètre
     * @param v la valeur que doit avoir amount
     * @return une liste
     */
    public List<E> findAllByAmount(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("amount", v);
        return result;
    }
    /**
     * Recherche sur l'attribut debit
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * debit le paramètre
     * @param v la valeur que doit avoir debit
     * @return un element ou null
     */
    public E findByDebit(boolean v) throws TopiaException {
        E result = findByProperty("debit", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * debit le paramètre
     * @param v la valeur que doit avoir debit
     * @return une liste
     */
    public List<E> findAllByDebit(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("debit", v);
        return result;
    }
    /**
     * Recherche sur l'attribut lettering
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * lettering le paramètre
     * @param v la valeur que doit avoir lettering
     * @return un element ou null
     */
    public E findByLettering(java.lang.String v) throws TopiaException {
        E result = findByProperty("lettering", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * lettering le paramètre
     * @param v la valeur que doit avoir lettering
     * @return une liste
     */
    public List<E> findAllByLettering(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("lettering", v);
        return result;
    }
    /**
     * Recherche sur l'attribut detail
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * detail le paramètre
     * @param v la valeur que doit avoir detail
     * @return un element ou null
     */
    public E findByDetail(java.lang.String v) throws TopiaException {
        E result = findByProperty("detail", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * detail le paramètre
     * @param v la valeur que doit avoir detail
     * @return une liste
     */
    public List<E> findAllByDetail(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("detail", v);
        return result;
    }
    /**
     * Recherche sur l'attribut transaction
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * transaction le paramètre
     * @param v la valeur que doit avoir transaction
     * @return un element ou null
     */
    public E findByTransaction(org.chorem.callao.entity.Transaction v) throws TopiaException {
        E result = findByProperty("transaction", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * transaction le paramètre
     * @param v la valeur que doit avoir transaction
     * @return une liste
     */
    public List<E> findAllByTransaction(org.chorem.callao.entity.Transaction v) throws TopiaException {
        List<E> result = findAllByProperty("transaction", v);
        return result;
    }
    /**
     * Recherche sur l'attribut account
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * account le paramètre
     * @param v la valeur que doit avoir account
     * @return un element ou null
     */
    public E findByAccount(org.chorem.callao.entity.Account v) throws TopiaException {
        E result = findByProperty("account", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * account le paramètre
     * @param v la valeur que doit avoir account
     * @return une liste
     */
    public List<E> findAllByAccount(org.chorem.callao.entity.Account v) throws TopiaException {
        List<E> result = findAllByProperty("account", v);
        return result;
    }
    /**
     * Recherche sur l'attribut log
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * log contient le paramètre
     * @param v la valeur que doit contenir log
     * @return un element ou null
     */
    public E findContainsLog(org.chorem.callao.entity.Log ... v) throws TopiaException {
        E result = findContainsProperties("log", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * log contient le paramètre
     * @param v la valeur que doit contenir log
     * @return une liste
     */
    public List<E> findAllContainsLog(org.chorem.callao.entity.Log ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("log", Arrays.asList(v));
        return results;
    }

} // EntryDAOAbstract
