/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.net.InetAddress;
import java.net.Socket;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.SocketSessionHandler;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.TcpipSMBPacketHandler;

public class TcpipSMBSessionSocketHandler
extends SocketSessionHandler {
    private static final ThreadGroup TcpipSMBGroup = new ThreadGroup("TcpipSMBSessions");

    public TcpipSMBSessionSocketHandler(SMBServer srv, int port, InetAddress bindAddr, boolean debug) {
        super("TCP-SMB", "SMB", srv, bindAddr, port);
        this.setDebug(debug);
    }

    @Override
    protected void acceptConnection(Socket sock) {
        block2: {
            try {
                sock.setSoTimeout(this.getSocketTimeout());
                SMBServer smbServer = (SMBServer)this.getServer();
                TcpipSMBPacketHandler pktHandler = new TcpipSMBPacketHandler(sock, smbServer.getPacketPool());
                SMBSrvSession srvSess = SMBSrvSession.createSession(pktHandler, smbServer, this.getNextSessionId());
                Thread srvThread = new Thread(TcpipSMBGroup, srvSess);
                srvThread.setDaemon(true);
                srvThread.setName("Sess_T" + srvSess.getSessionId() + "_" + sock.getInetAddress().getHostAddress());
                srvThread.start();
            }
            catch (Exception ex) {
                if (!this.hasDebug()) break block2;
                Debug.println("[SMB] TCP-SMB Failed to create session, " + ex.toString());
            }
        }
    }

    public static final void createSessionHandlers(SMBServer server, boolean sockDbg) throws Exception {
        ServerConfiguration config = server.getConfiguration();
        CIFSConfigSection cifsConfig = (CIFSConfigSection)config.getConfigSection("CIFS");
        TcpipSMBSessionSocketHandler sessHandler = new TcpipSMBSessionSocketHandler(server, cifsConfig.getTcpipSMBPort(), cifsConfig.getSMBBindAddress(), sockDbg);
        sessHandler.setSocketTimeout(cifsConfig.getSocketTimeout());
        sessHandler.initializeSessionHandler(server);
        Thread tcpThread = new Thread(sessHandler);
        tcpThread.setName("TcpipSMB_Handler");
        tcpThread.start();
        if (sockDbg) {
            Debug.println("[SMB] Native SMB TCP session handler created");
        }
    }
}

