/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Queue;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.NetBIOSException;
import org.alfresco.jlan.netbios.NetBIOSSession;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.AuthenticatorException;
import org.alfresco.jlan.server.auth.ICifsAuthenticator;
import org.alfresco.jlan.server.filesys.DeferredPacketException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.TooManyConnectionsException;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.thread.ThreadRequestPool;
import org.alfresco.jlan.smb.Dialect;
import org.alfresco.jlan.smb.DialectSelector;
import org.alfresco.jlan.smb.NTTime;
import org.alfresco.jlan.smb.PacketType;
import org.alfresco.jlan.smb.SMBDate;
import org.alfresco.jlan.smb.SMBErrorText;
import org.alfresco.jlan.smb.server.CIFSPacketPool;
import org.alfresco.jlan.smb.server.CIFSThreadRequest;
import org.alfresco.jlan.smb.server.DefaultSrvSessionFactory;
import org.alfresco.jlan.smb.server.NTParameterPacker;
import org.alfresco.jlan.smb.server.PacketHandler;
import org.alfresco.jlan.smb.server.ProtocolFactory;
import org.alfresco.jlan.smb.server.ProtocolHandler;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.SMBSrvException;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSessionState;
import org.alfresco.jlan.smb.server.SrvSessionFactory;
import org.alfresco.jlan.smb.server.VirtualCircuit;
import org.alfresco.jlan.smb.server.VirtualCircuitList;
import org.alfresco.jlan.smb.server.notify.NotifyRequest;
import org.alfresco.jlan.smb.server.notify.NotifyRequestList;
import org.alfresco.jlan.util.DataPacker;
import org.alfresco.jlan.util.HexDump;
import org.alfresco.jlan.util.StringList;

public class SMBSrvSession
extends SrvSession
implements Runnable {
    public static final int DefaultBufferSize = 65540;
    public static final int LanManBufferSize = 8192;
    public static final int LanManMaxMultiplexed = 1;
    public static final int NTMaxMultiplexed = 4;
    private static final int MaxVirtualCircuits = 0;
    public static final int DBG_NETBIOS = 1;
    public static final int DBG_STATE = 2;
    public static final int DBG_RXDATA = 4;
    public static final int DBG_TXDATA = 8;
    public static final int DBG_DUMPDATA = 16;
    public static final int DBG_NEGOTIATE = 32;
    public static final int DBG_TREE = 64;
    public static final int DBG_SEARCH = 128;
    public static final int DBG_INFO = 256;
    public static final int DBG_FILE = 512;
    public static final int DBG_FILEIO = 1024;
    public static final int DBG_TRAN = 2048;
    public static final int DBG_ECHO = 4096;
    public static final int DBG_ERROR = 8192;
    public static final int DBG_IPC = 16384;
    public static final int DBG_LOCK = 32768;
    public static final int DBG_PKTTYPE = 65536;
    public static final int DBG_DCERPC = 131072;
    public static final int DBG_STATECACHE = 262144;
    public static final int DBG_TIMING = 524288;
    public static final int DBG_NOTIFY = 0x100000;
    public static final int DBG_STREAMS = 0x200000;
    public static final int DBG_SOCKET = 0x400000;
    public static final int DBG_PKTPOOL = 0x800000;
    public static final int DBG_PKTSTATS = 0x1000000;
    public static final int DBG_THREADPOOL = 0x2000000;
    public static final int DBG_BENCHMARK = 0x4000000;
    public static final int DBG_OPLOCK = 0x8000000;
    public static final int DBG_PKTALLOC = 0x10000000;
    private static SrvSessionFactory m_factory = new DefaultSrvSessionFactory();
    private PacketHandler m_pktHandler;
    private ProtocolHandler m_handler;
    private int m_state = 0;
    private int m_dialect = -1;
    private String m_callerNBName;
    private String m_targetNBName;
    private NotifyRequestList m_notifyList;
    private boolean m_notifyPending;
    private int m_defFlags;
    private int m_defFlags2;
    private Queue<SMBSrvPacket> m_asynchQueue;
    private int m_maxBufSize;
    private int m_maxMultiplex;
    private int m_clientCaps;
    private VirtualCircuitList m_vcircuits;
    private Hashtable<Integer, Object> m_setupObjects;
    private boolean m_asyncRead;

    protected SMBSrvSession(PacketHandler handler, SMBServer srv, int maxVC) {
        super(-1, srv, handler.isProtocolName(), null);
        this.m_pktHandler = handler;
        if (this.isProtocol() == 1 || this.isProtocol() == 2) {
            this.setState(1);
            if (handler.hasClientName()) {
                this.m_callerNBName = handler.getClientName();
            }
        }
        this.setMaximumVirtualCircuits(maxVC);
    }

    public final int isProtocol() {
        return this.m_pktHandler.isProtocol();
    }

    public final TreeConnection findTreeConnection(SMBSrvPacket smbPkt) {
        TreeConnection tree = null;
        VirtualCircuit vc = this.findVirtualCircuit(smbPkt.getUserId());
        if (vc != null) {
            tree = vc.findConnection(smbPkt.getTreeId());
        }
        return tree;
    }

    public final synchronized int addVirtualCircuit(VirtualCircuit vc) {
        if (this.m_vcircuits == null) {
            this.m_vcircuits = new VirtualCircuitList();
        }
        return this.m_vcircuits.addCircuit(vc);
    }

    public final VirtualCircuit findVirtualCircuit(int uid) {
        VirtualCircuit vc;
        if (this.m_vcircuits == null) {
            this.m_vcircuits = new VirtualCircuitList();
        }
        if ((vc = this.m_vcircuits.findCircuit(uid)) != null) {
            this.setClientInformation(vc.getClientInformation());
            this.getSMBServer().getCifsAuthenticator().setCurrentUser(this.getClientInformation());
        }
        return vc;
    }

    public final void removeVirtualCircuit(int uid) {
        if (this.m_vcircuits != null) {
            this.m_vcircuits.removeCircuit(uid, this);
        }
    }

    public final int numberOfVirtualCircuits() {
        return this.m_vcircuits != null ? this.m_vcircuits.getCircuitCount() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void cleanupSession() {
        try {
            if (this.hasDebug(2)) {
                this.debugPrintln("Cleanup session, vcircuits=" + this.m_vcircuits.getCircuitCount() + ", changeNotify=" + this.getNotifyChangeCount());
            }
            this.m_vcircuits.clearCircuitList(this);
            if (this.m_notifyList != null && this.m_notifyList.numberOfRequests() > 0) {
                for (int i = 0; i < this.m_notifyList.numberOfRequests(); ++i) {
                    NotifyRequest curReq = this.m_notifyList.getRequest(i);
                    if (!curReq.getDiskContext().hasChangeHandler()) continue;
                    curReq.getDiskContext().getChangeHandler().removeNotifyRequests(this);
                }
            }
            this.getSMBServer().deleteTemporaryShares(this);
        }
        finally {
            if (this.hasTransaction()) {
                this.endTransaction();
            }
        }
    }

    protected final void closeSocket() {
        this.setShutdown(true);
        try {
            this.m_pktHandler.closeHandler();
        }
        catch (Exception ex) {
            Debug.println(ex);
        }
    }

    @Override
    public final void closeSession() {
        this.cleanupSession();
        super.closeSession();
        try {
            this.setState(5);
            this.closeSocket();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finalize() {
        this.cleanupSession();
        this.closeSocket();
    }

    public final int getDefaultFlags() {
        return this.m_defFlags;
    }

    public final int getDefaultFlags2() {
        return this.m_defFlags2;
    }

    public final int getNotifyChangeCount() {
        if (this.m_notifyList == null) {
            return 0;
        }
        return this.m_notifyList.numberOfRequests();
    }

    public final int getClientMaximumBufferSize() {
        return this.m_maxBufSize;
    }

    public final int getClientMaximumMultiplex() {
        return this.m_maxMultiplex;
    }

    public final int getClientCapabilities() {
        return this.m_clientCaps;
    }

    public final boolean hasClientCapability(int cap) {
        return (this.m_clientCaps & cap) != 0;
    }

    public final int getNegotiatedSMBDialect() {
        return this.m_dialect;
    }

    public final PacketHandler getPacketHandler() {
        return this.m_pktHandler;
    }

    public final CIFSPacketPool getPacketPool() {
        return this.m_pktHandler.getPacketPool();
    }

    public final ThreadRequestPool getThreadPool() {
        return this.getSMBServer().getThreadPool();
    }

    public final String getRemoteNetBIOSName() {
        return this.m_callerNBName;
    }

    public final boolean hasTargetNetBIOSName() {
        return this.m_targetNBName != null;
    }

    public final String getTargetNetBIOSName() {
        return this.m_targetNBName;
    }

    public final boolean hasRemoteAddress() {
        return this.m_pktHandler.hasRemoteAddress();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.m_pktHandler.getRemoteAddress();
    }

    public final SMBServer getSMBServer() {
        return (SMBServer)this.getServer();
    }

    public final String getServerName() {
        return this.getSMBServer().getServerName();
    }

    public final int getState() {
        return this.m_state;
    }

    public final int getMaximumVirtualCircuits() {
        return this.m_vcircuits != null ? this.m_vcircuits.getMaximumVirtualCircuits() : 0;
    }

    public void hangupSession(String reason) {
        if (this.hasDebug(2)) {
            this.debugPrint("## Session closing. ");
            this.debugPrintln(reason);
        }
        this.setState(5);
    }

    public final boolean hasMacintoshExtensions() {
        return this.getSMBServer().getCIFSConfiguration().hasMacintoshExtensions();
    }

    public final boolean hasNotifyPending() {
        return this.m_notifyPending;
    }

    public final boolean hasSetupObject(int pid) {
        if (this.m_setupObjects == null) {
            return false;
        }
        return this.m_setupObjects.get(new Integer(pid)) != null;
    }

    public final Object getSetupObject(int pid) {
        if (this.m_setupObjects == null) {
            return null;
        }
        return this.m_setupObjects.get(new Integer(pid));
    }

    public final void setSetupObject(int pid, Object obj) {
        if (this.m_setupObjects == null) {
            this.m_setupObjects = new Hashtable();
        }
        this.m_setupObjects.put(new Integer(pid), obj);
    }

    public final Object removeSetupObject(int pid) {
        if (this.m_setupObjects == null) {
            return null;
        }
        return this.m_setupObjects.remove(new Integer(pid));
    }

    public final void setNotifyPending(boolean pend) {
        this.m_notifyPending = pend;
    }

    public final void setClientMaximumBufferSize(int maxBuf) {
        this.m_maxBufSize = maxBuf;
    }

    public final void setClientMaximumMultiplex(int maxMpx) {
        this.m_maxMultiplex = maxMpx;
    }

    public final void setClientCapabilities(int flags) {
        this.m_clientCaps = flags;
    }

    public final void setDefaultFlags(int flags) {
        this.m_defFlags = flags;
    }

    public final void setDefaultFlags2(int flags) {
        this.m_defFlags2 = flags;
    }

    protected void setState(int state) {
        if (this.hasDebug(2)) {
            this.debugPrintln("State changed to " + SMBSrvSessionState.getStateAsString(state));
        }
        this.m_state = state;
    }

    public final synchronized void setMaximumVirtualCircuits(int maxVC) {
        if (this.m_vcircuits != null) {
            throw new RuntimeException("Virtual circuit list is already allocated");
        }
        this.m_vcircuits = new VirtualCircuitList(maxVC);
    }

    protected void procNetBIOSSessionRequest(SMBSrvPacket smbPkt) throws IOException, NetBIOSException {
        if (smbPkt.getReceivedLength() < 72 || smbPkt.getHeaderType() != 129) {
            if (this.hasDebug(1)) {
                Debug.println("NBREQ invalid packet len=" + smbPkt.getReceivedLength() + ", header=0x" + Integer.toHexString(smbPkt.getHeaderType()));
                HexDump.Dump(smbPkt.getBuffer(), smbPkt.getReceivedLength(), 0, Debug.getDebugInterface());
            }
            throw new NetBIOSException("NBREQ Invalid packet len=" + smbPkt.getReceivedLength());
        }
        byte[] buf = smbPkt.getBuffer();
        if (buf[4] != 32 || buf[38] != 32) {
            throw new NetBIOSException("NBREQ Invalid NetBIOS name data");
        }
        StringBuffer nbName = new StringBuffer(32);
        for (int i = 0; i < 32; ++i) {
            nbName.append((char)buf[5 + i]);
        }
        String toName = NetBIOSSession.DecodeName(nbName.toString());
        toName = toName.trim();
        nbName.setLength(0);
        for (int i = 0; i < 32; ++i) {
            nbName.append((char)buf[39 + i]);
        }
        String fromName = NetBIOSSession.DecodeName(nbName.toString());
        fromName = fromName.trim();
        if (this.hasDebug(1)) {
            this.debugPrintln("NetBIOS CALL From " + fromName + " to " + toName);
        }
        boolean forThisServer = false;
        if (toName.compareTo(this.getServerName()) == 0 || toName.compareTo("*SMBSERVER") == 0 || toName.compareTo("*SMBSERV") == 0 || toName.compareTo("*") == 0) {
            forThisServer = true;
        } else if (this.getSMBServer().getCIFSConfiguration().hasAliasNames()) {
            StringList aliasNames = this.getSMBServer().getCIFSConfiguration().getAliasNames();
            if (aliasNames.containsString(toName)) {
                forThisServer = true;
            }
        } else {
            InetAddress[] srvAddr = this.getSMBServer().getServerAddresses();
            if (srvAddr != null) {
                int idx = 0;
                while (idx < srvAddr.length && !forThisServer) {
                    if (srvAddr[idx++].getHostAddress().compareTo(toName) != 0) continue;
                    forThisServer = true;
                }
            }
        }
        if (!forThisServer) {
            throw new NetBIOSException("NBREQ Called name is not this server (" + toName + ")");
        }
        if (this.hasDebug(1)) {
            this.debugPrintln("NetBIOS session request from " + fromName);
        }
        this.m_callerNBName = fromName;
        this.m_targetNBName = toName;
        this.setState(1);
        this.setRemoteName(fromName);
        smbPkt.setHeaderType(130);
        smbPkt.setHeaderFlags(0);
        smbPkt.setHeaderLength(0);
        this.m_pktHandler.writePacket(smbPkt, 4, true);
    }

    protected void procSMBNegotiate(SMBSrvPacket smbPkt) throws SMBSrvException, IOException {
        boolean extendedSecurity;
        byte[] buf = smbPkt.getBuffer();
        buf[0] = 0;
        if (smbPkt.getCommand() != 114 || !smbPkt.checkPacketIsValid(0, 2)) {
            this.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        int dataPos = smbPkt.getByteOffset();
        String diaStr = null;
        StringList dialects = new StringList();
        for (int dataLen = smbPkt.getByteCount(); dataLen > 0; dataLen -= diaStr.length() + 2) {
            diaStr = DataPacker.getDataString('\u0002', buf, dataPos, dataLen, false);
            if (diaStr == null) {
                this.sendErrorResponseSMB(smbPkt, 1, 2);
                this.setState(5);
                return;
            }
            dialects.addString(diaStr);
            dataPos += diaStr.length() + 2;
        }
        DialectSelector dia = this.getSMBServer().getCIFSConfiguration().getEnabledDialects();
        int diaIdx = -1;
        for (int i = 0; i < 8; ++i) {
            if (!dia.hasDialect(i)) continue;
            for (int j = 0; j < Dialect.SMB_PROT_MAXSTRING; ++j) {
                if (Dialect.DialectType(j) != i || !dialects.containsString(Dialect.DialectString(j)) || i <= diaIdx) continue;
                diaIdx = i;
            }
        }
        if (this.hasDebug(32)) {
            if (diaIdx == -1) {
                this.debugPrintln("Failed to negotiate SMB dialect");
            } else {
                this.debugPrintln("Negotiated SMB dialect - " + Dialect.DialectTypeString(diaIdx));
            }
        }
        if (diaIdx != -1) {
            this.m_dialect = diaIdx;
            diaIdx = dialects.findString(Dialect.DialectTypeString(diaIdx));
            this.m_handler = ProtocolFactory.getHandler(this.m_dialect);
            if (this.m_handler != null) {
                if (this.hasDebug(32)) {
                    this.debugPrintln("Assigned protocol handler - " + this.m_handler.getClass().getName());
                }
                this.m_handler.setSession(this);
            } else {
                diaIdx = -1;
            }
        }
        boolean bl = extendedSecurity = (smbPkt.getFlags2() & 0x800) != 0;
        if (this.m_dialect == -1 || this.m_dialect <= 1) {
            smbPkt.setParameterCount(1);
            smbPkt.setParameter(0, diaIdx);
            smbPkt.setByteCount(0);
            smbPkt.setTreeId(0);
            smbPkt.setUserId(0);
        } else {
            if (this.m_dialect <= 6) {
                smbPkt.setFlags(8);
                smbPkt.setFlags2(1);
                ICifsAuthenticator auth = this.getSMBServer().getCifsAuthenticator();
                smbPkt.setParameterCount(13);
                smbPkt.setParameter(0, diaIdx);
                smbPkt.setParameter(1, auth.getSecurityMode());
                smbPkt.setParameter(2, 8192);
                smbPkt.setParameter(3, 1);
                smbPkt.setParameter(4, 0);
                smbPkt.setParameter(5, 0);
                smbPkt.setParameterLong(6, (int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL));
                SMBDate srvDate = new SMBDate(System.currentTimeMillis());
                smbPkt.setParameter(8, srvDate.asSMBTime());
                smbPkt.setParameter(9, srvDate.asSMBDate());
                smbPkt.setParameter(10, this.getServer().getGlobalConfiguration().getTimeZoneOffset());
                smbPkt.setParameter(11, auth.getEncryptionKeyLength());
                smbPkt.setParameter(12, 0);
                smbPkt.setTreeId(0);
                smbPkt.setUserId(0);
                try {
                    auth.generateNegotiateResponse(this, smbPkt, false);
                }
                catch (AuthenticatorException ex) {
                    if (this.hasDebug(32)) {
                        this.debugPrintln("Negotiate error - " + ex.getMessage());
                    }
                    this.setState(5);
                    return;
                }
            }
            if (this.m_dialect == 7) {
                this.setDefaultFlags(8);
                this.setDefaultFlags2(32769);
                ICifsAuthenticator auth = this.getSMBServer().getCIFSConfiguration().getAuthenticator();
                if (!auth.hasExtendedSecurity()) {
                    extendedSecurity = false;
                }
                NTParameterPacker nt = new NTParameterPacker(smbPkt.getBuffer());
                smbPkt.setParameterCount(17);
                nt.packWord(diaIdx);
                nt.packByte(auth.getSecurityMode());
                nt.packWord(4);
                nt.packWord(0);
                int maxBufSize = this.getSMBServer().getPacketPool().getLargestSize() - 4;
                nt.packInt(maxBufSize);
                nt.packInt(0);
                if (!auth.hasExtendedSecurity() || !extendedSecurity) {
                    nt.packInt((int)(System.currentTimeMillis() & 0xFFFFFFFFL));
                } else {
                    nt.packInt(0);
                }
                int srvCapabs = auth.getServerCapabilities();
                if (!auth.hasExtendedSecurity() || !extendedSecurity) {
                    srvCapabs &= Integer.MAX_VALUE;
                }
                nt.packInt(srvCapabs);
                long srvTime = NTTime.toNTTime(new Date(System.currentTimeMillis()));
                nt.packLong(srvTime);
                nt.packWord(this.getServer().getGlobalConfiguration().getTimeZoneOffset());
                if (!auth.hasExtendedSecurity() || !extendedSecurity) {
                    nt.packByte(auth.getEncryptionKeyLength());
                } else {
                    nt.packByte(0);
                }
                smbPkt.setFlags(this.getDefaultFlags());
                smbPkt.setFlags2(this.getDefaultFlags2());
                smbPkt.setTreeId(0);
                smbPkt.setUserId(0);
                try {
                    auth.generateNegotiateResponse(this, smbPkt, extendedSecurity);
                }
                catch (AuthenticatorException ex) {
                    if (this.hasDebug(32)) {
                        this.debugPrintln("Negotiate error - " + ex.getMessage());
                    }
                    this.setState(5);
                    return;
                }
            }
        }
        smbPkt.setTreeId(65535);
        smbPkt.setUserId(65535);
        if (!smbPkt.isResponse()) {
            smbPkt.setFlags(smbPkt.getFlags() + 128);
        }
        this.m_pktHandler.writePacket(smbPkt, smbPkt.getLength());
        if (this.m_dialect == -1) {
            this.setState(5);
        } else if (Dialect.DialectSupportsCommand(this.m_dialect, 115)) {
            this.setState(2);
        } else {
            this.setState(3);
        }
        if (this.m_dialect != -1) {
            this.getSMBServer().sessionOpened(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        SMBSrvPacket smbPkt = null;
        try {
            if (this.hasDebug(32)) {
                this.debugPrintln("Server session started");
            }
            while (this.m_state != 5) {
                try {
                    smbPkt = this.m_pktHandler.readPacket();
                }
                catch (SocketTimeoutException ex) {
                    if (this.hasDebug(0x400000)) {
                        this.debugPrintln("Socket read timed out, closing session");
                    }
                    this.hangupSession("Socket read timeout");
                    smbPkt = null;
                }
                catch (IOException ex) {
                    this.hangupSession("Remote disconnect");
                    smbPkt = null;
                }
                if (smbPkt == null) continue;
                if (this.m_state > 0) {
                    if (smbPkt.isSMB2()) {
                        if (!this.hasDebug(65536)) continue;
                        this.debugPrintln("SMB2 request received, ignoring");
                        continue;
                    }
                    if (!smbPkt.checkPacketSignature()) {
                        if (!this.hasDebug(65536)) continue;
                        this.debugPrintln("Invalid SMB packet signature received, packet ignored");
                        continue;
                    }
                }
                this.getThreadPool().queueRequest(new CIFSThreadRequest(this, smbPkt));
                smbPkt = null;
            }
            this.closeSession();
            if (smbPkt != null) {
                this.getSMBServer().getPacketPool().releasePacket(smbPkt);
            }
        }
        catch (Exception ex) {
            if (!this.isShutdown()) {
                this.debugPrintln("Closing session due to exception");
                this.debugPrintln(ex);
                Debug.println(ex);
            }
            if (smbPkt != null) {
                this.getSMBServer().getPacketPool().releasePacket(smbPkt);
            }
        }
        catch (Throwable ex2) {
            this.debugPrintln("Closing session due to throwable");
            this.debugPrintln(ex2.toString());
            Debug.println(ex2);
            if (smbPkt != null) {
                this.getSMBServer().getPacketPool().releasePacket(smbPkt);
            }
            {
                catch (Throwable throwable) {
                    if (smbPkt != null) {
                        this.getSMBServer().getPacketPool().releasePacket(smbPkt);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runHandler(SMBSrvPacket smbPkt) throws IOException, SMBSrvException, TooManyConnectionsException {
        SMBSrvPacket asynchPkt;
        if (this.hasDebug(65536)) {
            this.debugPrintln("Rx packet type - " + smbPkt.getPacketTypeString() + ", SID=" + smbPkt.getSID());
        }
        if (!this.m_handler.runProtocol(smbPkt)) {
            this.sendErrorResponseSMB(smbPkt, 65535, 2);
        }
        if (this.hasTransaction()) {
            this.endTransaction();
        }
        while ((asynchPkt = this.removeFirstAsynchResponse()) != null) {
            this.sendResponseSMB(asynchPkt, asynchPkt.getLength());
            if (!this.hasDebug(0x100000)) continue;
            this.debugPrintln("Sent queued asynch response type=" + asynchPkt.getPacketTypeString() + ", mid=" + asynchPkt.getMultiplexId() + ", pid=" + asynchPkt.getProcessId());
            SMBSrvSession sMBSrvSession = this;
            synchronized (sMBSrvSession) {
                this.debugPrintln("  Async queue len=" + this.m_asynchQueue.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processPacket(SMBSrvPacket smbPkt) {
        if (smbPkt != null) {
            try {
                long startTime = 0L;
                long endTime = 0L;
                if (this.hasDebug(524288)) {
                    startTime = System.currentTimeMillis();
                }
                if (this.hasDebug(4)) {
                    this.debugPrintln("Rx Data len=" + smbPkt.getReceivedLength());
                    HexDump.Dump(smbPkt.getBuffer(), smbPkt.getReceivedLength(), 0, Debug.getDebugInterface());
                }
                if (smbPkt.getReceivedLength() > 0) {
                    switch (this.m_state) {
                        case 0: {
                            this.procNetBIOSSessionRequest(smbPkt);
                            break;
                        }
                        case 1: {
                            this.procSMBNegotiate(smbPkt);
                            break;
                        }
                        case 2: {
                            this.m_handler.runProtocol(smbPkt);
                            break;
                        }
                        case 3: {
                            long duration;
                            this.runHandler(smbPkt);
                            if (!this.hasDebug(524288) || (duration = (endTime = System.currentTimeMillis()) - startTime) <= 20L) break;
                            this.debugPrintln("Processed packet " + PacketType.getCommandName(smbPkt.getCommand()) + " (0x" + Integer.toHexString(smbPkt.getCommand()) + ") in " + duration + "ms, MID=" + smbPkt.getMultiplexId());
                        }
                    }
                }
                this.getPacketPool().releasePacket(smbPkt);
                smbPkt = null;
                if (this.hasDebug(0x1000000)) {
                    Debug.println("[SMB] Packet pool stats: " + this.getPacketPool());
                }
            }
            catch (DeferredPacketException ex) {
                smbPkt = null;
            }
            catch (SocketException ex) {
                if (this.hasDebug(2)) {
                    this.debugPrintln("Socket closed by remote client");
                }
            }
            catch (Exception ex) {
                if (!this.isShutdown()) {
                    this.debugPrintln("Closing session due to exception");
                    this.debugPrintln(ex);
                    Debug.println(ex);
                }
            }
            catch (Throwable ex) {
                this.debugPrintln("Closing session due to throwable");
                this.debugPrintln(ex.toString());
                Debug.println(ex);
            }
            finally {
                if (smbPkt != null) {
                    this.getSMBServer().getPacketPool().releasePacket(smbPkt);
                }
            }
        }
        if (this.hasTransaction()) {
            this.debugPrintln("** Active transaction after packet processing, cleaning up **");
            this.endTransaction();
        }
        if (this.m_state == 5) {
            this.cleanupSession();
            if (this.hasDebug(2)) {
                this.debugPrintln("Server session closed");
            }
            this.closeSocket();
            this.getSMBServer().sessionClosed(this);
        }
        if (this.hasClientInformation()) {
            this.getSMBServer().getCifsAuthenticator().setCurrentUser(null);
        }
    }

    public final void sendResponseSMB(SMBSrvPacket pkt) throws IOException {
        this.sendResponseSMB(pkt, pkt.getLength());
    }

    public final synchronized void sendResponseSMB(SMBSrvPacket pkt, int len) throws IOException {
        if (this.hasTransaction()) {
            long elapsedTime;
            long startTime = 0L;
            if (this.hasDebug(0x4000000)) {
                startTime = System.currentTimeMillis();
            }
            this.endTransaction();
            if (this.hasDebug(0x4000000) && (elapsedTime = System.currentTimeMillis() - startTime) > 5L) {
                Debug.println("Benchmark: End transaction took " + elapsedTime + "ms");
            }
        }
        if (!pkt.isRequestPacket() && !pkt.isResponse()) {
            pkt.setFlags(pkt.getFlags() + 128);
        }
        pkt.setFlags(pkt.getFlags() | this.getDefaultFlags());
        int flags2 = pkt.getFlags2() | this.getDefaultFlags2();
        pkt.setFlags2(flags2 &= 0xFFFFEFF9);
        this.m_pktHandler.writePacket(pkt, len);
        this.m_pktHandler.flushPacket();
        if (this.hasDebug(8)) {
            this.debugPrintln("Tx Data len=" + len);
            HexDump.Dump(pkt.getBuffer(), 64, 0, Debug.getDebugInterface());
        }
    }

    public final void sendSuccessResponseSMB(SMBSrvPacket smbPkt) throws IOException {
        if (!smbPkt.isResponse()) {
            smbPkt.setFlags(smbPkt.getFlags() + 128);
        }
        smbPkt.setFlags(smbPkt.getFlags() | this.getDefaultFlags());
        smbPkt.setFlags2(smbPkt.getFlags2() | this.getDefaultFlags2());
        smbPkt.setParameterCount(0);
        smbPkt.setByteCount(0);
        if (smbPkt.isLongErrorCode()) {
            smbPkt.setLongErrorCode(0);
        } else {
            smbPkt.setErrorClass(0);
            smbPkt.setErrorCode(0);
        }
        this.sendResponseSMB(smbPkt, smbPkt.getLength());
        if (this.hasDebug(8)) {
            this.debugPrintln("Tx Data len=" + smbPkt.getLength() + ", success SMB");
        }
    }

    public final void sendErrorResponseSMB(SMBSrvPacket smbPkt, int ntCode, int stdCode, int stdClass) throws IOException {
        if (smbPkt.isLongErrorCode()) {
            if (ntCode != -1) {
                this.sendErrorResponseSMB(smbPkt, ntCode, 6);
            } else {
                this.sendErrorResponseSMB(smbPkt, stdCode, stdClass);
            }
        } else {
            this.sendErrorResponseSMB(smbPkt, stdCode, stdClass);
        }
    }

    public final void sendErrorResponseSMB(SMBSrvPacket smbPkt, int errCode, int errClass) throws IOException {
        if (!smbPkt.isResponse()) {
            smbPkt.setFlags(smbPkt.getFlags() + 128);
        }
        smbPkt.setParameterCount(0);
        smbPkt.setByteCount(0);
        smbPkt.setFlags(smbPkt.getFlags() | this.getDefaultFlags());
        smbPkt.setFlags2(smbPkt.getFlags2() | this.getDefaultFlags2());
        if (errClass == 6) {
            if (!smbPkt.isLongErrorCode()) {
                smbPkt.setFlags2(smbPkt.getFlags2() + 16384);
            }
            smbPkt.setLongErrorCode(errCode);
        } else {
            if (smbPkt.isLongErrorCode()) {
                smbPkt.setFlags2(smbPkt.getFlags2() - 16384);
            }
            smbPkt.setErrorCode(errCode);
            smbPkt.setErrorClass(errClass);
        }
        this.sendResponseSMB(smbPkt, smbPkt.getLength());
        if (this.hasDebug(8192)) {
            this.debugPrintln("Error : Cmd = " + smbPkt.getPacketTypeString() + " - " + SMBErrorText.ErrorString(errClass, errCode));
        }
    }

    public final boolean sendAsyncErrorResponseSMB(SMBSrvPacket smbPkt, int errCode, int errClass) throws IOException {
        if (!smbPkt.isResponse()) {
            smbPkt.setFlags(smbPkt.getFlags() + 128);
        }
        smbPkt.setParameterCount(0);
        smbPkt.setByteCount(0);
        smbPkt.setFlags(smbPkt.getFlags() | this.getDefaultFlags());
        smbPkt.setFlags2(smbPkt.getFlags2() | this.getDefaultFlags2());
        if (errClass == 6) {
            if (!smbPkt.isLongErrorCode()) {
                smbPkt.setFlags2(smbPkt.getFlags2() + 16384);
            }
            smbPkt.setLongErrorCode(errCode);
        } else {
            if (smbPkt.isLongErrorCode()) {
                smbPkt.setFlags2(smbPkt.getFlags2() - 16384);
            }
            smbPkt.setErrorCode(errCode);
            smbPkt.setErrorClass(errClass);
        }
        boolean sentOK = this.sendAsynchResponseSMB(smbPkt, smbPkt.getLength());
        if (this.hasDebug(8192)) {
            this.debugPrintln("Async Error : Cmd = " + smbPkt.getPacketTypeString() + " - " + SMBErrorText.ErrorString(errClass, errCode) + ", sent=" + sentOK);
        }
        return sentOK;
    }

    public final boolean sendAsynchResponseSMB(SMBSrvPacket pkt, int len) throws IOException {
        boolean sts = false;
        if (this.m_pktHandler.availableBytes() == 0) {
            this.sendResponseSMB(pkt, len);
            this.m_pktHandler.flushPacket();
            sts = true;
        } else {
            this.queueAsynchResponseSMB(pkt);
        }
        return sts;
    }

    protected final synchronized void queueAsynchResponseSMB(SMBSrvPacket pkt) {
        if (this.m_asynchQueue == null) {
            this.m_asynchQueue = new LinkedList<SMBSrvPacket>();
        }
        this.m_asynchQueue.add(pkt);
    }

    protected final synchronized SMBSrvPacket removeFirstAsynchResponse() {
        if (this.m_asynchQueue == null || this.m_asynchQueue.size() == 0) {
            return null;
        }
        SMBSrvPacket pkt = this.m_asynchQueue.poll();
        return pkt;
    }

    public final synchronized boolean hasAsyncResponseQueued() {
        return this.m_asynchQueue != null && this.m_asynchQueue.size() != 0;
    }

    public final synchronized int sendQueuedAsyncResponses() {
        SMBSrvPacket asynchPkt;
        int asyncCnt = 0;
        while ((asynchPkt = this.removeFirstAsynchResponse()) != null) {
            try {
                ++asyncCnt;
                this.sendResponseSMB(asynchPkt, asynchPkt.getLength());
                if (!this.hasDebug(0x100000) && !this.hasDebug(0x8000000)) continue;
                this.debugPrintln("Sent queued asynch response type=" + asynchPkt.getPacketTypeString() + ", mid=" + asynchPkt.getMultiplexId() + ", pid=" + asynchPkt.getProcessId());
                this.debugPrintln("  Async queue len=" + this.m_asynchQueue.size());
            }
            catch (Exception ex) {
                if (!this.hasDebug(0x100000) && !this.hasDebug(0x8000000)) continue;
                this.debugPrintln("Failed to send queued asynch response type=" + asynchPkt.getPacketTypeString() + ", mid=" + asynchPkt.getMultiplexId() + ", pid=" + asynchPkt.getProcessId() + ", ex=" + ex);
            }
        }
        return asyncCnt;
    }

    public final NotifyRequest findNotifyRequest(int mid, int tid, int uid, int pid) {
        if (this.m_notifyList == null) {
            return null;
        }
        return this.m_notifyList.findRequest(mid, tid, uid, pid);
    }

    public final NotifyRequest findNotifyRequest(NetworkFile dir, int filter, boolean watchTree) {
        if (this.m_notifyList == null) {
            return null;
        }
        return this.m_notifyList.findRequest(dir, filter, watchTree);
    }

    public final void addNotifyRequest(NotifyRequest req, DiskDeviceContext ctx) {
        if (this.m_notifyList == null) {
            this.m_notifyList = new NotifyRequestList();
        }
        this.m_notifyList.addRequest(req);
        ctx.addNotifyRequest(req);
    }

    public final void removeNotifyRequest(NotifyRequest req) {
        if (this.m_notifyList == null) {
            return;
        }
        this.m_notifyList.removeRequest(req);
        if (req.getDiskContext() != null) {
            req.getDiskContext().removeNotifyRequest(req);
        }
    }

    public static final SrvSessionFactory getFactory() {
        return m_factory;
    }

    public static final void setFactory(SrvSessionFactory factory) {
        m_factory = factory;
    }

    public static final SMBSrvSession createSession(PacketHandler handler, SMBServer server, int sessId) {
        return m_factory.createSession(handler, server, sessId);
    }

    public final boolean hasReadInProgress() {
        return this.m_asyncRead;
    }

    public final void setReadInProgress(boolean inProgress) {
        this.m_asyncRead = inProgress;
    }

    @Override
    public boolean useCaseSensitiveSearch() {
        return false;
    }

    @Override
    public boolean isPseudoFilesEnabled() {
        return true;
    }
}

