/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys;

import java.util.Vector;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.filesys.FileListener;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.alfresco.jlan.server.filesys.NetworkFile;

public abstract class NetworkFileServer
extends NetworkServer {
    private Vector<FileListener> m_fileListeners;
    private FilesystemsConfigSection m_filesysConfig;

    public NetworkFileServer(String proto, ServerConfiguration config) {
        super(proto, config);
        this.m_filesysConfig = (FilesystemsConfigSection)config.getConfigSection("Filesystems");
    }

    public final FilesystemsConfigSection getFilesystemConfiguration() {
        return this.m_filesysConfig;
    }

    public final void addFileListener(FileListener l) {
        if (this.m_fileListeners == null) {
            this.m_fileListeners = new Vector();
        }
        this.m_fileListeners.add(l);
    }

    public final void removeFileListener(FileListener l) {
        if (this.m_fileListeners == null) {
            return;
        }
        this.m_fileListeners.remove(l);
    }

    public final void fireCloseFileEvent(SrvSession sess, NetworkFile file) {
        if (this.m_fileListeners == null || this.m_fileListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_fileListeners.size(); ++i) {
            FileListener fileListener = this.m_fileListeners.elementAt(i);
            try {
                fileListener.fileClosed(sess, file);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public final void fireOpenFileEvent(SrvSession sess, NetworkFile file) {
        if (this.m_fileListeners == null || this.m_fileListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_fileListeners.size(); ++i) {
            FileListener fileListener = this.m_fileListeners.elementAt(i);
            try {
                fileListener.fileOpened(sess, file);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }
}

