/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.alfresco.jlan.client.SMBPacket;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.NetworkSession;
import org.alfresco.jlan.smb.Dialect;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.PacketType;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.util.DataPacker;

public class Session {
    public static final int SecurityModeUser = 1;
    public static final int SecurityModeShare = 2;
    protected static final int Closed = -1;
    public static final int DBGPacketType = 1;
    public static final int DBGDumpPacket = 2;
    public static final int DBGHexDump = 4;
    public static final int DBGSigning = 8;
    public static final int DEFAULT_BUFSIZE = 4096;
    public static final int NO_TRANSACTION = -1;
    private int m_dialect;
    private String m_diaStr;
    private NetworkSession m_netSession;
    protected SMBPacket m_pkt;
    private int m_defFlags = 8;
    private int m_defFlags2 = 1;
    private PCShare m_remoteShr;
    private String m_domain;
    private String m_srvOS;
    private String m_srvLM;
    private int m_secMode;
    private byte[] m_encryptKey;
    private int m_sessIdx;
    private int m_userId;
    private int m_processId;
    protected int m_treeid;
    private int m_devtype;
    private int m_maxPktSize;
    private int m_sessCaps;
    private int m_maxVCs;
    private int m_maxMPX;
    private boolean m_guest;
    private byte[] m_sessionKey;
    private int m_seqNo;
    private MessageDigest m_md5;
    private long m_lastTxSig;
    private int m_transMID = -1;
    private static int m_sessionIdx = 1;
    private static int m_multiplexId = 1;
    private static int m_debug = 0;

    protected Session(PCShare shr, int dialect, SMBPacket pkt) {
        this.m_dialect = dialect;
        this.m_remoteShr = shr;
        this.m_sessIdx = this.getNextSessionId();
        this.m_pkt = pkt;
        if (pkt == null) {
            this.m_pkt = new SMBPacket(4096);
        }
    }

    protected final SMBPacket allocatePacket(int pref) {
        if (pref > this.m_maxPktSize) {
            return new SMBPacket(this.m_maxPktSize + 4);
        }
        return new SMBPacket(pref + 4);
    }

    public final boolean supportsRawMode() {
        return (this.m_sessCaps & 1) != 0;
    }

    public final boolean supportsUnicode() {
        return (this.m_sessCaps & 4) != 0;
    }

    public final boolean supportsLargeFiles() {
        return (this.m_sessCaps & 8) != 0;
    }

    public final boolean supportsNTSmbs() {
        return (this.m_sessCaps & 0x10) != 0;
    }

    public final boolean supportsRPCAPIs() {
        return (this.m_sessCaps & 0x20) != 0;
    }

    public final boolean supportsNTStatusCodes() {
        return (this.m_sessCaps & 0x40) != 0;
    }

    public final boolean supportsLevel2Oplocks() {
        return (this.m_sessCaps & 0x80) != 0;
    }

    public final boolean supportsLockAndRead() {
        return (this.m_sessCaps & 0x100) != 0;
    }

    public final boolean supportsNTFind() {
        return (this.m_sessCaps & 0x200) != 0;
    }

    public void CloseSession() throws IOException, SMBException {
        if (this.isActive()) {
            this.m_netSession.Close();
            this.m_netSession = null;
        }
    }

    public final int getDefaultFlags() {
        return this.m_defFlags;
    }

    public final int getDefaultFlags2() {
        return this.m_defFlags2;
    }

    public final int getDeviceType() {
        return this.m_devtype;
    }

    public final int getDialect() {
        return this.m_dialect;
    }

    public final String getDialectString() {
        return this.m_diaStr;
    }

    public final String getDomain() {
        return this.m_domain;
    }

    public final boolean hasEncryptionKey() {
        return this.m_encryptKey != null;
    }

    public final byte[] getEncryptionKey() {
        return this.m_encryptKey;
    }

    public final String getLANManagerType() {
        return this.m_srvLM;
    }

    public final int getMaximumMultiplexedRequests() {
        return this.m_maxMPX;
    }

    public final int getMaximumPacketSize() {
        return this.m_maxPktSize;
    }

    public final int getMaximumVirtualCircuits() {
        return this.m_maxVCs;
    }

    public final synchronized int getNextMultiplexId() {
        return m_multiplexId++;
    }

    protected final synchronized int getNextSessionId() {
        return m_sessionIdx++;
    }

    public final String getOperatingSystem() {
        return this.m_srvOS;
    }

    public final String getPassword() {
        return this.m_remoteShr.getPassword();
    }

    public final PCShare getPCShare() {
        return this.m_remoteShr;
    }

    public final int getSecurityMode() {
        return this.m_secMode;
    }

    public final String getServer() {
        return this.m_remoteShr.getNodeName();
    }

    public final NetworkSession getSession() {
        return this.m_netSession;
    }

    public final int getCapabilities() {
        return this.m_sessCaps;
    }

    public final int getProcessId() {
        return this.m_processId;
    }

    public final int getSessionId() {
        return this.m_sessIdx;
    }

    public final String getShareName() {
        return this.m_remoteShr.getShareName();
    }

    public final int getTreeId() {
        return this.m_treeid;
    }

    public final int getUserId() {
        return this.m_userId;
    }

    public final String getUserName() {
        return this.m_remoteShr.getUserName();
    }

    public final boolean hasDataAvailable() throws IOException {
        return this.m_netSession.hasData();
    }

    public static boolean hasDebugOption(int opt) {
        if (m_debug == 0) {
            return false;
        }
        return (m_debug & opt) != 0;
    }

    public final boolean hasSMBSigning() {
        return this.m_sessionKey != null;
    }

    public final boolean isActive() {
        return this.m_netSession != null;
    }

    public static boolean hasDebug() {
        return m_debug != 0;
    }

    public final boolean isGuest() {
        return this.m_guest;
    }

    public final boolean isUnicode() {
        return (this.m_defFlags2 & 0x8000) != 0;
    }

    public final void pingServer() throws IOException, SMBException {
        this.pingServer(1);
    }

    public final void pingServer(int cnt) throws IOException, SMBException {
        this.m_pkt.setCommand(43);
        this.m_pkt.setFlags(0);
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setProcessId(this.getProcessId());
        this.m_pkt.setMultiplexId(1);
        this.m_pkt.setParameterCount(1);
        this.m_pkt.setParameter(0, cnt);
        String echoStr = "ECHO";
        this.m_pkt.setBytes(echoStr.getBytes());
        this.m_pkt.SendSMB(this);
        while (cnt > 0) {
            this.m_pkt.ReceiveSMB(this);
            --cnt;
        }
    }

    public static void setDebug(int dbg) {
        m_debug = dbg;
    }

    protected final void setDefaultFlags(int flg) {
        this.m_defFlags = flg;
    }

    protected final void setDefaultFlags2(int flg2) {
        this.m_defFlags2 = flg2;
    }

    protected final void setDeviceType(int dev) {
        this.m_devtype = dev;
    }

    protected final void setDialect(int dia) {
        this.m_dialect = dia;
    }

    protected final void setDialectString(String dia) {
        this.m_diaStr = dia;
    }

    protected final void setDomain(String dom) {
        this.m_domain = dom;
    }

    public final void setEncryptionKey(byte[] key) {
        this.m_encryptKey = key;
    }

    protected final void setGuest(boolean sts) {
        this.m_guest = sts;
    }

    protected final void setLANManagerType(String lm) {
        this.m_srvLM = lm;
    }

    protected final void setMaximumMultiplexedRequests(int maxMulti) {
        this.m_maxMPX = maxMulti;
    }

    protected final void setMaximumPacketSize(int siz) {
        this.m_maxPktSize = siz;
    }

    protected final void setMaximumVirtualCircuits(int maxVC) {
        this.m_maxVCs = maxVC;
    }

    protected final void setOperatingSystem(String os) {
        this.m_srvOS = os;
    }

    protected final void setPassword(String pwd) {
        this.m_remoteShr.setPassword(pwd);
    }

    public final void setSecurityMode(int secMode) {
        this.m_secMode = secMode;
    }

    protected final void setServer(String srv) {
        this.m_remoteShr.setNodeName(srv);
    }

    protected final void setSession(NetworkSession netSess) {
        this.m_netSession = netSess;
    }

    protected final void setCapabilities(int caps) {
        this.m_sessCaps = caps;
    }

    protected final void setShareName(String shr) {
        this.m_remoteShr.setShareName(shr);
    }

    public final void setProcessId(int id) {
        this.m_processId = id;
    }

    protected final void setTreeId(int id) {
        this.m_treeid = id;
    }

    protected final void setUserId(int uid) {
        this.m_userId = uid;
    }

    protected final void setUserName(String user) {
        this.m_remoteShr.setUserName(user);
    }

    protected void processAsynchResponse(SMBPacket pkt) {
        if (Session.hasDebug()) {
            Debug.println("++ Asynchronous response received, command = 0x" + pkt.getCommand());
        }
    }

    protected final void enableSMBSigning(byte[] sessKey) throws NoSuchAlgorithmException {
        this.m_sessionKey = sessKey;
        this.m_seqNo = 0;
        this.m_md5 = MessageDigest.getInstance("MD5");
    }

    protected final void disableSMBSigning() {
        this.m_sessionKey = null;
        this.m_md5 = null;
    }

    protected final void signTxPacket(SMBPacket pkt) {
        int seqNo = this.m_seqNo++;
        pkt.setSignature(seqNo);
        pkt.setLongErrorCode(0);
        if (!this.hasActiveTransaction()) {
            // empty if block
        }
        this.m_md5.update(this.m_sessionKey);
        this.m_md5.update(pkt.getBuffer(), 4, pkt.getLength());
        byte[] sigByts = this.m_md5.digest();
        this.m_lastTxSig = DataPacker.getIntelLong(sigByts, 0);
        pkt.setSignature(this.m_lastTxSig);
        if (Session.hasDebugOption(8)) {
            Debug.println("Sign request " + PacketType.getCommandName(pkt.getCommand()) + ", seq=" + seqNo + ", signature = 0x" + Long.toHexString(this.m_lastTxSig));
            Debug.println("Send length = " + pkt.getLength());
        }
    }

    protected final void verifyRxPacket(SMBPacket pkt) throws SMBException {
        long rxSig = pkt.getSignature();
        int seqNo = this.m_seqNo++;
        if (this.hasActiveTransaction()) {
            if (pkt.isValidResponse()) {
                seqNo = this.m_seqNo + 1;
            } else {
                if (Session.hasDebugOption(8)) {
                    Debug.println("Transaction error returned, signature NOT checked");
                }
                return;
            }
        }
        pkt.setSignature(seqNo);
        this.m_md5.update(this.m_sessionKey);
        this.m_md5.update(pkt.getBuffer(), 4, pkt.getLength());
        byte[] sigByts = this.m_md5.digest();
        long calcSig = DataPacker.getIntelLong(sigByts, 0);
        if (Session.hasDebugOption(8)) {
            Debug.println("Verify sign " + PacketType.getCommandName(pkt.getCommand()) + ", seq=" + seqNo + ", signature = 0x" + Long.toHexString(rxSig) + ", calc=" + Long.toHexString(calcSig));
            Debug.println("Received length = " + pkt.getLength());
            if (calcSig != rxSig) {
                Debug.println("#### SMB signature mismatch ####");
            }
        }
        if (calcSig != rxSig) {
            if (rxSig == this.m_lastTxSig) {
                this.disableSMBSigning();
                if (Session.hasDebugOption(8)) {
                    Debug.println("Received signature equals sent, disabling signing");
                }
            } else {
                throw new SMBException(5, 10);
            }
        }
    }

    public final void setTransactionMID(int mid) {
        this.m_transMID = mid;
        if (mid == -1) {
            this.m_seqNo += 2;
        }
    }

    public final boolean hasActiveTransaction() {
        return this.m_transMID != -1;
    }

    public final int getSMBSequence() {
        return this.m_seqNo;
    }

    public final void setSMBSequence(int seq) {
        this.m_seqNo = seq;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[\\\\");
        str.append(this.getServer());
        str.append("\\");
        str.append(this.getShareName());
        str.append(":");
        str.append(Dialect.DialectTypeString(this.m_dialect));
        str.append(",UserId=");
        str.append(this.getUserId());
        str.append("]");
        return str.toString();
    }
}

