/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client;

import java.io.IOException;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SMBInputStream;
import org.alfresco.jlan.client.SMBOutputStream;
import org.alfresco.jlan.client.SMBPacket;
import org.alfresco.jlan.client.Session;
import org.alfresco.jlan.client.info.FileInfo;
import org.alfresco.jlan.smb.SMBDate;
import org.alfresco.jlan.smb.SMBException;

public abstract class SMBFile {
    public static final int EndOfFile = 1;
    public static final int Closed = 2;
    protected Session m_sess;
    private FileInfo m_info;
    protected int m_FID;
    protected SMBPacket m_rxpkt = null;
    protected SMBPacket m_txpkt = null;
    protected long m_rxpos = 0L;
    protected long m_txpos = 0L;
    protected int m_rxoffset = 0;
    protected int m_rxlen = 0;
    protected int m_txoffset = 0;
    protected int m_txlen;
    private int m_flags = 0;

    protected SMBFile(Session sess, FileInfo finfo, int fid) {
        this.m_sess = sess;
        this.m_info = finfo;
        this.m_FID = fid;
        this.m_txpos = this.getFileSize();
    }

    public final boolean atEndOfFile() {
        return (this.m_flags & 1) != 0;
    }

    public final void clearEndOfFile() {
        if (this.atEndOfFile()) {
            --this.m_flags;
        }
    }

    public final int Available() {
        return this.m_rxlen;
    }

    public abstract void Close(SMBDate var1) throws IOException, SMBException;

    public final void Close() throws IOException, SMBException {
        this.Close(null);
    }

    protected void finalize() {
        if (!this.isClosed()) {
            try {
                this.Close();
            }
            catch (SMBException ex) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public abstract void Flush() throws IOException, SMBException;

    public final int getAttributes() {
        return this.m_info.getFileAttributes();
    }

    public final String getFileName() {
        return this.m_info.getFileName();
    }

    public final String getFilePath() {
        return this.m_info.getPath();
    }

    public final long getFileSize() {
        return this.m_info.getSize();
    }

    public final int getFileId() {
        return this.m_FID;
    }

    protected final Session getSession() {
        return this.m_sess;
    }

    public final long getReadPosition() {
        return this.m_rxpos;
    }

    public final long getWritePosition() {
        return this.m_txpos;
    }

    public final boolean isClosed() {
        return (this.m_flags & 2) != 0;
    }

    public final boolean isDirectory() {
        return this.m_info.isDirectory();
    }

    public final boolean isHidden() {
        return this.m_info.isHidden();
    }

    public final boolean isReadOnly() {
        return this.m_info.isReadOnly();
    }

    public final boolean isSystem() {
        return this.m_info.isSystem();
    }

    public abstract int Read(byte[] var1, int var2, int var3) throws IOException, SMBException;

    public final int Read(byte[] buf) throws IOException, SMBException {
        return this.Read(buf, buf.length, 0);
    }

    public abstract int Write(byte[] var1, int var2, int var3) throws IOException, SMBException;

    public final int Write(byte[] buf) throws IOException, SMBException {
        return this.Write(buf, buf.length, 0);
    }

    public final int Write(String str) throws IOException, SMBException {
        byte[] byts = str.getBytes();
        return this.Write(byts, byts.length, 0);
    }

    public abstract long Seek(long var1, int var3) throws IOException, SMBException;

    public abstract void Lock(long var1, long var3) throws IOException, SMBException;

    public abstract void Unlock(long var1, long var3) throws IOException, SMBException;

    protected void setStateFlag(int flag, boolean sts) {
        if (sts && (this.m_flags & flag) == 0) {
            this.m_flags += flag;
        } else if (!sts && (this.m_flags & flag) != 0) {
            this.m_flags -= flag;
        }
    }

    protected final void setFileInformation(FileInfo fInfo) {
        this.m_info = fInfo;
    }

    public final SMBInputStream asInputStream() throws SMBException {
        if (this.isDirectory()) {
            throw new SMBException(1, 1);
        }
        return new SMBInputStream(this);
    }

    public final SMBOutputStream asOutputStream() throws SMBException {
        if (this.isDirectory()) {
            throw new SMBException(1, 1);
        }
        return new SMBOutputStream(this);
    }

    public void refreshFileInformation() throws IOException, SMBException {
        DiskSession diskSess;
        FileInfo fInfo;
        if (this.m_sess instanceof DiskSession && (fInfo = (diskSess = (DiskSession)this.m_sess).getFileInformation(this.getFileName())) != null) {
            this.setFileInformation(fInfo);
        }
    }

    protected final boolean hasStateFlag(int flg) {
        return (this.m_flags & flg) != 0;
    }

    public final String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.m_info.toString());
        str.append(" ,FID=");
        str.append(this.m_FID);
        return str.toString();
    }
}

