/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services;

import java.util.List;
import java.util.SortedSet;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.MethodeExtraction;
import nc.ird.cantharella.data.model.TypeExtrait;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.utils.normalizers.ExtractionNormalizer;
import nc.ird.cantharella.service.utils.normalizers.MethodeExtractionNormalizer;
import nc.ird.cantharella.service.utils.normalizers.UniqueFieldNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalize;
import org.springframework.transaction.annotation.Transactional;

public interface ExtractionService {
    public long countExtractions();

    public void createExtraction(@Normalize(value=ExtractionNormalizer.class) Extraction var1) throws DataConstraintException;

    public void deleteExtraction(Extraction var1) throws DataConstraintException;

    @Transactional(readOnly=true)
    public List<Extraction> listExtractions(Utilisateur var1);

    public SortedSet<Extraction> listExtractionsForUser(Utilisateur var1);

    public boolean isExtractionUnique(Extraction var1);

    public Extraction loadExtraction(Integer var1) throws DataNotFoundException;

    public Extraction loadExtraction(@Normalize(value=UniqueFieldNormalizer.class) String var1) throws DataNotFoundException;

    public void updateExtraction(@Normalize(value=ExtractionNormalizer.class) Extraction var1) throws DataConstraintException;

    public boolean updateOrdeleteExtractionEnabled(Extraction var1, Utilisateur var2);

    public void createMethodeExtraction(@Normalize(value=MethodeExtractionNormalizer.class) MethodeExtraction var1) throws DataConstraintException;

    public void deleteMethodeExtraction(MethodeExtraction var1) throws DataConstraintException;

    public List<MethodeExtraction> listMethodesExtraction();

    public MethodeExtraction loadMethodeExtraction(Integer var1) throws DataNotFoundException;

    public MethodeExtraction loadMethodeExtraction(@Normalize(value=UniqueFieldNormalizer.class) String var1) throws DataNotFoundException;

    public void updateMethodeExtraction(@Normalize(value=MethodeExtractionNormalizer.class) MethodeExtraction var1) throws DataConstraintException;

    public void refreshMethodeExtraction(MethodeExtraction var1);

    public boolean isTypeExtraitReferenced(TypeExtrait var1);

    public boolean isExtraitUnique(Extrait var1);
}

