/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.utils.normalizers;

import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.ParamMethoPuriEffectif;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.service.utils.normalizers.UniqueFieldNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalizer;
import nc.ird.cantharella.utils.AssertTools;
import nc.ird.cantharella.utils.StringTransformer;

public final class PurificationNormalizer
extends Normalizer<Purification> {
    @Override
    protected Purification normalize(Purification purification) {
        AssertTools.assertNotNull((Object)purification);
        purification.setRef(Normalizer.normalize(UniqueFieldNormalizer.class, purification.getRef()));
        for (ParamMethoPuriEffectif param : purification.getParamsMetho()) {
            param.setValeur(new StringTransformer(param.getValeur()).trimToNull().replaceConsecutiveWhitespaces().toString());
        }
        for (Fraction curFraction : purification.getFractions()) {
            curFraction.setRef(Normalizer.normalize(UniqueFieldNormalizer.class, curFraction.getRef()));
        }
        return purification;
    }
}

