/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.util.Arrays;
import java.util.Collection;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.config.ServiceContext;
import nc.ird.cantharella.service.exceptions.EmailException;
import nc.ird.cantharella.service.services.MailService;
import nc.ird.cantharella.utils.AssertTools;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Service;

@Service
public final class MailServiceImpl
implements MailService {
    private static final Logger LOG = LoggerFactory.getLogger(MailServiceImpl.class);
    @Autowired
    private SimpleMailMessage mailMessage;
    @Autowired
    private MailSender mailSender;

    @Override
    public void sendMail(Collection<Utilisateur> recipients, String subject, String text) throws EmailException {
        this.sendMail(recipients, subject, text, null);
    }

    @Override
    public void sendMail(Collection<Utilisateur> recipients, String subject, String text, String replyTo) throws EmailException {
        AssertTools.assertCollectionNotNull(recipients);
        String[] courriels = new String[recipients.size()];
        int i = 0;
        for (Utilisateur recipient : recipients) {
            courriels[i++] = recipient.getCourriel();
        }
        this.sendMail(subject, text, replyTo, courriels);
    }

    @Override
    public void sendMail(Personne recipient, String subject, String text) throws EmailException {
        AssertTools.assertNotNull((Object)recipient);
        this.sendMail(subject, text, null, recipient.getCourriel());
    }

    private void sendMail(String subject, String text, String replyTo, String ... recipients) throws EmailException {
        LOG.info("sendMail " + subject + " [to] " + Arrays.toString(recipients));
        if (ServiceContext.isMailActivated()) {
            AssertTools.assertNotEmpty((String)subject);
            AssertTools.assertNotEmpty((String)text);
            AssertTools.assertNotEmpty((Object[])recipients);
            AssertTools.assertArrayNotEmpty((String[])recipients);
            this.mailMessage.setTo(recipients);
            this.mailMessage.setSubject(subject);
            this.mailMessage.setText(text);
            if (!StringUtils.isEmpty((CharSequence)replyTo)) {
                this.mailMessage.setReplyTo(replyTo);
            }
            try {
                this.mailSender.send(this.mailMessage);
            }
            catch (Exception e) {
                throw new EmailException(e);
            }
        }
    }

    @Override
    public void sendMailQuietly(Collection<Utilisateur> recipients, String subject, String text) {
        try {
            this.sendMail(recipients, subject, text);
        }
        catch (EmailException e) {
            LOG.warn(e.toString());
        }
    }

    @Override
    public void sendMailQuietly(Personne recipient, String subject, String text) {
        try {
            this.sendMail(recipient, subject, text);
        }
        catch (EmailException e) {
            LOG.warn(e.toString());
        }
    }
}

