/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.DocumentDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.TypeDocument;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import nc.ird.cantharella.service.exceptions.InvalidFileExtensionException;
import nc.ird.cantharella.service.services.DocumentService;
import nc.ird.cantharella.utils.AssertTools;
import org.apache.commons.io.FilenameUtils;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public final class DocumentServiceImpl
implements DocumentService {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentServiceImpl.class);
    @Autowired
    private GenericDao dao;
    private Collection<String> documentExtensionAllowed;

    @Value(value="${document.extension.allowed}")
    private void setDcumentExtensionAllowed(String documentExtensionAllowed) {
        String[] values = documentExtensionAllowed.split("\\s*,\\s*");
        this.documentExtensionAllowed = Arrays.asList(values);
    }

    @Override
    public List<TypeDocument> listTypeDocuments() {
        return this.dao.readList(TypeDocument.class, new String[]{"nom"});
    }

    @Override
    public void createTypeDocument(TypeDocument typeDocument) throws DataConstraintException {
        LOG.info("createTypeDocument: " + typeDocument.getNom());
        this.dao.create((AbstractModel)typeDocument);
    }

    @Override
    public TypeDocument loadTypeDocument(Integer idTypeDocument) throws DataNotFoundException {
        return (TypeDocument)this.dao.read(TypeDocument.class, (Serializable)idTypeDocument);
    }

    @Override
    public TypeDocument loadTypeDocument(String nom) throws DataNotFoundException {
        return (TypeDocument)this.dao.read(TypeDocument.class, "nom", (Serializable)((Object)nom));
    }

    @Override
    public void updateTypeDocument(TypeDocument typeDocument) throws DataConstraintException {
        LOG.info("updateTypeDocument: " + typeDocument.getNom());
        try {
            this.dao.update((AbstractModel)typeDocument);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public void deleteTypeDocument(TypeDocument typeDocument) throws DataConstraintException {
        AssertTools.assertNotNull((Object)typeDocument);
        LOG.info("deleteTypeDocument: " + typeDocument.getNom());
        try {
            this.dao.delete((AbstractModel)typeDocument);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public void updateDocumentAttachable(DocumentAttachable documentAttachable) throws DataConstraintException {
        AssertTools.assertNotNull((Object)documentAttachable);
        LOG.info("updateDocumentAttachable: " + documentAttachable.toString());
        try {
            this.dao.update((AbstractModel)documentAttachable);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public List<String> listDocumentEditeurs() {
        List result = this.dao.list(DocumentDao.CRITERIA_DISTINCT_DOCUMENT_EDITEURS);
        return result;
    }

    @Override
    public List<String> listDocumentContrainteLegales() {
        List result = this.dao.list(DocumentDao.CRITERIA_DISTINCT_DOCUMENT_CONTRAINTE_LEGALES);
        return result;
    }

    @Override
    public void addDocumentContent(Document document, String clientFileName, String contentType, byte[] content) throws InvalidFileExtensionException {
        AssertTools.assertNotEmpty((String)clientFileName);
        String extension = FilenameUtils.getExtension((String)clientFileName);
        extension = extension.toLowerCase();
        if (!this.documentExtensionAllowed.contains(extension)) {
            throw new InvalidFileExtensionException("File extension is not valid");
        }
        try {
            document.setFileName(clientFileName);
            document.setFileMimetype(contentType);
            document.setFileContent(content);
            if (contentType.startsWith("image/")) {
                BufferedImage originalImage = ImageIO.read(new ByteArrayInputStream(content));
                BufferedImage thumbImage = Scalr.resize((BufferedImage)originalImage, (int)100, (int)100, (BufferedImageOp[])new BufferedImageOp[0]);
                ByteArrayOutputStream thumbStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)thumbImage, "png", thumbStream);
                document.setFileContentThumb(thumbStream.toByteArray());
            }
        }
        catch (IOException ex) {
            LOG.error("Can't manipulate image", (Throwable)ex);
            throw new UnexpectedException("Can't manipulate image", (Exception)ex);
        }
    }

    @Override
    public boolean updateOrdeleteDocumentEnabled(Document document, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == document.getCreateur().getIdPersonne();
    }
}

