/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services;

import java.util.List;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.exceptions.EmailException;
import nc.ird.cantharella.service.utils.normalizers.EmailNormalizer;
import nc.ird.cantharella.service.utils.normalizers.PersonneNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalize;
import org.springframework.transaction.annotation.Transactional;

public interface PersonneService {
    public void checkOrCreateAdmin() throws DataConstraintException;

    public long countPersonnes();

    public void createPersonne(@Normalize(value=PersonneNormalizer.class) Personne var1) throws DataConstraintException;

    public void createUtilisateur(@Normalize(value=PersonneNormalizer.class) Utilisateur var1) throws DataConstraintException;

    public void deletePersonne(Personne var1) throws DataConstraintException;

    public void deleteUtilisateur(Utilisateur var1) throws DataConstraintException, EmailException;

    public String hashPassword(String var1);

    @Transactional(readOnly=true)
    public List<Personne> listPersonnes();

    @Transactional(readOnly=true)
    public List<Personne> listPersonnesWithInvalidUsers();

    @Transactional(readOnly=true)
    public List<String> listPersonneOrganismes();

    @Transactional(readOnly=true)
    public List<Utilisateur> listUtilisateursInvalid();

    @Transactional(readOnly=true)
    public List<Utilisateur> listUtilisateursValid();

    public Personne loadPersonne(Integer var1) throws DataNotFoundException;

    public Personne loadPersonne(@Normalize(value=EmailNormalizer.class) String var1) throws DataNotFoundException;

    public Utilisateur loadUtilisateur(Integer var1) throws DataNotFoundException;

    public Utilisateur loadUtilisateur(@Normalize(value=EmailNormalizer.class) String var1) throws DataNotFoundException;

    public boolean authenticateUtilisateur(@Normalize(value=EmailNormalizer.class) String var1, String var2);

    public void refreshPersonne(Personne var1);

    public void rejectUtilisateur(Utilisateur var1);

    public void resetPasswordUtilisateur(@Normalize(value=EmailNormalizer.class) String var1) throws DataNotFoundException, EmailException;

    public void sendMailAdmins(String var1, String var2, String var3) throws EmailException;

    public Utilisateur updateAndCreateUtilisateur(@Normalize(value=PersonneNormalizer.class) Personne var1) throws EmailException, DataConstraintException;

    public void updatePersonne(@Normalize(value=PersonneNormalizer.class) Personne var1) throws DataConstraintException;

    public void updateUtilisateur(@Normalize(value=PersonneNormalizer.class) Utilisateur var1, boolean var2) throws DataConstraintException;

    public void validAndUpdateUtilisateur(@Normalize(value=PersonneNormalizer.class) Utilisateur var1) throws DataConstraintException;

    public boolean updateOrDeletePersonneEnabled(Personne var1, Utilisateur var2);
}

