/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services;

import java.util.List;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.TypeDocument;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import nc.ird.cantharella.service.exceptions.InvalidFileExtensionException;
import nc.ird.cantharella.service.utils.normalizers.TypeDocumentNormalizer;
import nc.ird.cantharella.service.utils.normalizers.UniqueFieldNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalize;
import org.springframework.transaction.annotation.Transactional;

public interface DocumentService {
    @Transactional(readOnly=true)
    public List<TypeDocument> listTypeDocuments();

    public void createTypeDocument(@Normalize(value=TypeDocumentNormalizer.class) TypeDocument var1) throws DataConstraintException;

    public TypeDocument loadTypeDocument(Integer var1) throws DataNotFoundException;

    public TypeDocument loadTypeDocument(@Normalize(value=UniqueFieldNormalizer.class) String var1) throws DataNotFoundException;

    public void updateTypeDocument(@Normalize(value=TypeDocumentNormalizer.class) TypeDocument var1) throws DataConstraintException;

    public void deleteTypeDocument(TypeDocument var1) throws DataConstraintException;

    @Transactional(readOnly=true)
    public List<String> listDocumentEditeurs();

    @Transactional(readOnly=true)
    public List<String> listDocumentContrainteLegales();

    public void updateDocumentAttachable(DocumentAttachable var1) throws DataConstraintException;

    @Transactional(readOnly=true)
    public void addDocumentContent(Document var1, String var2, String var3, byte[] var4) throws InvalidFileExtensionException;

    @Transactional(readOnly=true)
    public boolean updateOrdeleteDocumentEnabled(Document var1, Utilisateur var2);
}

