/*
 * #%L
 * JMexico :: Model
 * 
 * $Id: InputDesignXmlWriter.java 70 2012-06-25 12:36:31Z sletellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/jmexico/tags/jmexico-0.6/jmexico-model/src/main/java/fr/reseaumexico/model/writer/InputDesignXmlWriter.java $
 * %%
 * Copyright (C) 2011 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package fr.reseaumexico.model.writer;

import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.InputDesign;
import fr.reseaumexico.model.Scenario;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

/**
 * Writer to create input design file with {@link InputDesign} model
 *
 * @author sletellier <letellier@codelutin.com>
 * @since 0.1
 */
public class InputDesignXmlWriter extends MexicoXmlWriter<InputDesign> {

    protected ExperimentDesignXmlWriter experimentDesignXmlWriter;

    public InputDesignXmlWriter(File file, InputDesign model) throws IOException {
        super(file, model);
        experimentDesignXmlWriter = new ExperimentDesignXmlWriter(file, model.getExperimentDesign());
    }

    @Override
    public XmlNode getRootElement() {
        XmlNode rootXmlNode = new XmlNode(INPUT_DESIGN);
        composeInputDesignMeta(rootXmlNode);
        composeScenarios(rootXmlNode);

        return rootXmlNode;
    }

    protected void composeInputDesignMeta(XmlNode rootXmlNode) {

        // date
        Date date = model.getDate();
        addParameter(rootXmlNode, INPUT_DESIGN_DATE, formatDate(date));

        // experiement design
        rootXmlNode.add(experimentDesignXmlWriter.getRootElement());
    }

    protected void composeScenarios(XmlNode rootXmlNode) {

        // scenarios
        Collection<Scenario> scenarios = model.getScenario();
        if (scenarios != null) {
            for (Scenario scenario : scenarios) {
                XmlNode scenariosXmlNode = XmlNode.createElement(rootXmlNode, SCENARIO);
                addParameter(scenariosXmlNode, SCENARIO_NAME, scenario.getName());
                addParameter(scenariosXmlNode, SCENARIO_ORDER_NUMBER, scenario.getOrderNumber());

                // factor  values
                Map<Factor, Object> factorValues = scenario.getFactorValues();
                for (Map.Entry<Factor, Object> entry : factorValues.entrySet()) {
                    Object value = entry.getValue();
                    XmlNode factorValueXmlNode = XmlNode.createElement(scenariosXmlNode, SCENARIO_FACTOR_VALUES, String.valueOf(value));
                    factorValueXmlNode.addAttribute(FACTOR, entry.getKey().getId());
                }

                // features
                addAllFeature(scenariosXmlNode, scenario.getFeature());
            }
        }
    }
}
