/*
 * #%L
 * JMexico :: Model
 * 
 * $Id: ScenarioFactorValueEvent.java 32 2012-01-18 16:58:27Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/jmexico/tags/jmexico-0.3/jmexico-model/src/main/java/fr/reseaumexico/model/event/ScenarioFactorValueEvent.java $
 * %%
 * Copyright (C) 2011 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package fr.reseaumexico.model.event;

import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.Scenario;

import java.util.EventObject;

/**
 * Event fired when {@link Factor} change on {@link Scenario}
 *
 * @author sletellier <letellier@codelutin.com>
 * @since 0.1
 */
public class ScenarioFactorValueEvent extends EventObject {

    private static final long serialVersionUID = 1L;

    protected String factorId;

    protected Object factorOldValue;

    protected Object factorNewValue;

    public ScenarioFactorValueEvent(Scenario scenario,
                                    String factorId,
                                    Object factorOldValue,
                                    Object factorNewValue) {
        super(scenario);
        this.factorId = factorId;
        this.factorOldValue = factorOldValue;
        this.factorNewValue = factorNewValue;
    }

    @Override
    public Scenario getSource() {
        return (Scenario) super.getSource();
    }

    public String getFactorId() {
        return factorId;
    }

    public Object getFactorOldValue() {
        return factorOldValue;
    }

    public Object getFactorNewValue() {
        return factorNewValue;
    }
}
