/*
 * #%L
 * JMexico :: Model
 * 
 * $Id: XmlParser.java 32 2012-01-18 16:58:27Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/jmexico/tags/jmexico-0.2/jmexico-model/src/main/java/fr/reseaumexico/model/parser/XmlParser.java $
 * %%
 * Copyright (C) 2011 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package fr.reseaumexico.model.parser;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;

/**
 * Abstract parser to get model from xml file using XPP3
 *
 * @author sletellier <letellier@codelutin.com>
 * @see XmlPullParser
 * @since 0.1
 */
public abstract class XmlParser<M> extends FileReader {

    public XmlParser(File file) throws FileNotFoundException {
        super(file);
    }

    public M getModel() throws XmlPullParserException, IOException, ParseException {

        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(this);

        // parse model
        return parseModel(parser);
    }

    protected abstract M parseModel(XmlPullParser parser) throws IOException, XmlPullParserException, ParseException;

    public boolean parserEqual(XmlPullParser parser, String name) {
        String tagName = parser.getName();
        return tagName.equals(name);
    }
}
