/*
 * #%L
 * JMexico :: Model
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2011 - 2012 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package fr.reseaumexico.model;

import fr.reseaumexico.model.event.ScenarioFactorValueListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public abstract class Scenario implements Serializable {

    private static final long serialVersionUID = 7076673858399974965L;

    public static final String PROPERTY_ORDER_NUMBER = "orderNumber";

    public static final String PROPERTY_NAME = "name";

    public static final String PROPERTY_FACTOR_VALUES = "factorValues";

    public static final String PROPERTY_FEATURE = "feature";

    protected int orderNumber;

    protected String name;

    protected Map<Factor, Object> factorValues;

    protected Collection<Feature> feature;

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);;

    public int getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(int orderNumber) {
        int oldValue = getOrderNumber();
        this.orderNumber = orderNumber;
        firePropertyChange(PROPERTY_ORDER_NUMBER, oldValue, orderNumber);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        String oldValue = getName();
        this.name = name;
        firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public Map<Factor, Object> getFactorValues() {
        return factorValues;
    }

    public void setFactorValues(Map<Factor, Object> factorValues) {
        Map<Factor, Object> oldValue = getFactorValues();
        this.factorValues = factorValues;
        firePropertyChange(PROPERTY_FACTOR_VALUES, oldValue, factorValues);
    }

    public Feature getFeature(int index) {
        Feature o = getChild(feature, index);
        return o;
    }

    public void addFeature(Feature feature) {
        getFeature().add(feature);
    
        firePropertyChange(PROPERTY_FEATURE, null, feature);
    }

    public void addAllFeature(Collection<Feature> feature) {
        getFeature().addAll(feature);
    
        firePropertyChange(PROPERTY_FEATURE, null, feature);
    }

    public boolean removeFeature(Feature feature) {
        boolean  removed = getFeature().remove(feature);
    
        if (removed) {
            firePropertyChange(PROPERTY_FEATURE, feature, null);
      }
    
        return removed;
    }

    public boolean removeAllFeature(Collection<Feature> feature) {
        boolean  removed = getFeature().removeAll(feature);
    
        if (removed) {
            firePropertyChange(PROPERTY_FEATURE, feature, null);
      }
    
        return removed;
    }

    public boolean containsFeature(Feature feature) {
        boolean contains = getFeature().contains(feature);
    
        return contains;
    }

    public boolean containsAllFeature(Collection<Feature> feature) {
        boolean  contains = getFeature().containsAll(feature);
    
        return contains;
    }

    public Collection<Feature> getFeature() {
        return feature;
    }

    public void setFeature(Collection<Feature> feature) {
        Collection<Feature> oldValue = getFeature();
        this.feature = feature;
        firePropertyChange(PROPERTY_FEATURE, oldValue, feature);
    }

    public abstract void setFactorValue(Factor factor, Object value);

    public abstract Object getFactorValue(Factor factor);

    public abstract void addFactorValueListener(ScenarioFactorValueListener factorListener);

    public abstract void removeFactorValueListener(ScenarioFactorValueListener factorListener);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }

    protected <T> T getChild(Collection<T> childs, int index) {
        if (childs != null) {
            int i = 0;
            for (T o : childs) {
                if (index == i) {
                    return o;
                }
                i++;
            }
        }
        return null;
    }

} //Scenario
